/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery.drink;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.brewery.other.WrappedText;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2561;

public record DrinkInfo(double bestCookingTime, double bestBarrelAge, List<String> bestBarrelType, List<WrappedText> additionalInfo) {
    public static Codec<DrinkInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.optionalFieldOf("best_cooking_time", (Object)-1.0).forGetter(DrinkInfo::bestCookingTime), (App)Codec.DOUBLE.optionalFieldOf("best_barrel_age", (Object)-1.0).forGetter(DrinkInfo::bestBarrelAge), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("best_barrel_type", List.of()).forGetter(DrinkInfo::bestBarrelType), (App)Codec.list(WrappedText.CODEC).optionalFieldOf("texts", List.of()).forGetter(DrinkInfo::additionalInfo)).apply((Applicative)instance, DrinkInfo::new));

    public static DrinkInfo defaults(double bestCookingTimeMinutes, double bestBarrelAgeDays, String bestBarrelType, List<class_2561> texts) {
        return new DrinkInfo(bestCookingTimeMinutes * 60.0, bestBarrelAgeDays * 1200.0, bestBarrelType.isEmpty() ? List.of() : List.of(bestBarrelType), texts.stream().map(x -> WrappedText.of(x)).collect(Collectors.toList()));
    }

    public static DrinkInfo defaults(double bestCookingTimeMinutes, double bestBarrelAgeDays, List<class_2561> texts) {
        return DrinkInfo.defaults(bestCookingTimeMinutes, bestBarrelAgeDays, bestBarrelAgeDays > 0.0 ? "*" : "", texts);
    }
}

