/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery.drink;

import com.mojang.datafixers.util.Pair;
import eu.pb4.brewery.BreweryInit;
import eu.pb4.brewery.drink.AlcoholValueEffect;
import eu.pb4.brewery.drink.ConsumptionEffect;
import eu.pb4.brewery.drink.DrinkType;
import eu.pb4.brewery.duck.LivingEntityExt;
import eu.pb4.brewery.other.BrewGameRules;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public final class AlcoholManager {
    public static final AlcoholManager FALLBACK = new AlcoholManager(null);
    @Nullable
    private final class_1309 entity;
    public double alcoholLevel = 0.0;
    public double quality = -1.0;
    private final List<DelayedEffect> delayedEffects = new ArrayList<DelayedEffect>();
    private final List<DelayedEffect> delayedEffectsNext = new ArrayList<DelayedEffect>();
    private final List<TimedAttributes> timedAttributes = new ArrayList<TimedAttributes>();

    public AlcoholManager(@Nullable class_1309 entity) {
        this.entity = entity;
    }

    public void drink(DrinkType type, double quality, double alcoholicValue) {
        if (this.entity == null) {
            return;
        }
        class_1937 class_19372 = this.entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            double multiplier = ((DoubleRule)world.method_64395().method_20746(BrewGameRules.ALCOHOL_MULTIPLIER)).get();
            this.alcoholLevel = Math.max(this.alcoholLevel + alcoholicValue * multiplier, alcoholicValue * multiplier);
            this.quality = this.quality == -1.0 ? quality : (this.quality + quality) / 2.0;
        }
    }

    public void eat(class_1799 stack) {
        if (this.alcoholLevel > 0.0) {
            this.alcoholLevel -= BreweryInit.ITEM_ALCOHOL_REMOVAL_VALUES.getDouble((Object)stack.method_7909());
        }
    }

    public static AlcoholManager of(class_1309 entity) {
        return entity != null ? ((LivingEntityExt)entity).brewery$getAlcoholManager() : FALLBACK;
    }

    public void writeData(class_11372 view) {
        view.method_71463("brewery:alcohol_level", this.alcoholLevel);
        view.method_71463("brewery:quality", this.quality);
        class_11372.class_11374 list = view.method_71476("brewery:delayed_effects");
        class_11372.class_11374 list2 = view.method_71476("brewery:timed_attributes");
        for (DelayedEffect delayedEffect : this.delayedEffects) {
            delayedEffect.writeData(list.method_71480());
        }
        for (TimedAttributes timedAttributes : this.timedAttributes) {
            timedAttributes.writeData(list2.method_71480());
        }
    }

    public void readData(class_11368 view) {
        this.alcoholLevel = view.method_71422("brewery:alcohol_level", 0.0);
        this.quality = view.method_71422("brewery:quality", 0.0);
        this.delayedEffects.clear();
        for (class_11368 effect : view.method_71438("brewery:delayed_effects")) {
            this.delayedEffects.add(DelayedEffect.readData(effect));
        }
        for (class_11368 effect : view.method_71438("brewery:timed_attributes")) {
            this.timedAttributes.add(TimedAttributes.readData(effect));
        }
    }

    public void tick() {
        if (this.entity == null) {
            return;
        }
        if (!this.delayedEffectsNext.isEmpty()) {
            this.delayedEffects.addAll(this.delayedEffectsNext);
            this.delayedEffectsNext.clear();
        }
        this.delayedEffects.removeIf(this::applyDelayedEffects);
        this.timedAttributes.removeIf(this::applyTimedAttributes);
        if (!this.delayedEffectsNext.isEmpty()) {
            this.delayedEffects.addAll(this.delayedEffectsNext);
            this.delayedEffectsNext.clear();
        }
        if (this.alcoholLevel > 0.0) {
            this.alcoholLevel -= 0.0012 * this.quality;
            double level = this.getModifiedAlcoholLevel();
            for (AlcoholValueEffect.Value effects : BreweryInit.ALCOHOL_EFFECTS) {
                if (!(level >= effects.minimumValue()) || this.entity.field_6012 % effects.rate() != 0) continue;
                for (ConsumptionEffect effect : effects.effects()) {
                    effect.apply(this.entity, 0.0, this.quality);
                }
            }
        }
    }

    private boolean applyTimedAttributes(TimedAttributes timedAttributes) {
        if (this.entity == null) {
            return false;
        }
        if (--timedAttributes.ticksLeft > 0) {
            for (Pair<class_6880<class_1320>, class_1322> effect : timedAttributes.attributes) {
                class_1324 x = this.entity.method_5996((class_6880)effect.getFirst());
                if (x == null || x.method_6196(((class_1322)effect.getSecond()).comp_2447())) continue;
                x.method_26835((class_1322)effect.getSecond());
            }
            return false;
        }
        for (Pair<class_6880<class_1320>, class_1322> effect : timedAttributes.attributes) {
            class_1324 x = this.entity.method_5996((class_6880)effect.getFirst());
            if (x == null || !x.method_6196(((class_1322)effect.getSecond()).comp_2447())) continue;
            x.method_6202((class_1322)effect.getSecond());
        }
        return true;
    }

    private boolean applyDelayedEffects(DelayedEffect delayedEffect) {
        if (this.entity == null) {
            return false;
        }
        if (--delayedEffect.ticksLeft <= 0) {
            for (ConsumptionEffect effect : delayedEffect.effects) {
                effect.apply(this.entity, delayedEffect.age, delayedEffect.quality);
            }
            return true;
        }
        return false;
    }

    public void addDelayedEffect(int ticks, double drinkAge, double drinkQuality, List<ConsumptionEffect> effects) {
        this.delayedEffectsNext.add(new DelayedEffect(ticks, drinkQuality, drinkAge, List.copyOf(effects)));
    }

    public void addTimedAttributes(int ticks, double drinkAge, double drinkQuality, List<Pair<class_6880<class_1320>, class_1322>> effects) {
        this.timedAttributes.add(new TimedAttributes(ticks, drinkQuality, drinkAge, List.copyOf(effects)));
    }

    public double getModifiedAlcoholLevel() {
        return this.alcoholLevel - (this.quality - 8.0) * 5.0;
    }

    private static class DelayedEffect {
        public int ticksLeft;
        private final double quality;
        private final double age;
        private final List<ConsumptionEffect> effects;

        public DelayedEffect(int ticks, double quality, double age, List<ConsumptionEffect> effects) {
            this.ticksLeft = ticks;
            this.quality = quality;
            this.age = age;
            this.effects = effects;
        }

        public void writeData(class_11372 view) {
            view.method_71465("ticks", this.ticksLeft);
            view.method_71463("quality", this.quality);
            view.method_71463("age", this.age);
            class_11372.class_11373 list = view.method_71467("entries", ConsumptionEffect.CODEC);
            for (ConsumptionEffect effect : this.effects) {
                list.method_71484((Object)effect);
            }
        }

        public static DelayedEffect readData(class_11368 view) {
            int ticks = view.method_71424("ticks", 0);
            double quality = view.method_71422("quality", 0.0);
            double age = view.method_71422("age", 0.0);
            ArrayList<ConsumptionEffect> list = new ArrayList<ConsumptionEffect>();
            for (ConsumptionEffect effect : view.method_71437("entries", ConsumptionEffect.CODEC)) {
                list.add(effect);
            }
            return new DelayedEffect(ticks, quality, age, list);
        }
    }

    private static class TimedAttributes {
        public int ticksLeft;
        private final double quality;
        private final double age;
        private final List<Pair<class_6880<class_1320>, class_1322>> attributes;

        public TimedAttributes(int ticks, double quality, double age, List<Pair<class_6880<class_1320>, class_1322>> effects) {
            this.ticksLeft = ticks;
            this.quality = quality;
            this.age = age;
            this.attributes = effects;
        }

        public void writeData(class_11372 view) {
            view.method_71465("ticks", this.ticksLeft);
            view.method_71463("quality", this.quality);
            view.method_71463("age", this.age);
            class_11372.class_11373 list = view.method_71467("entries", ConsumptionEffect.Attributes.ATTRIBUTE_PAIR.codec());
            for (Pair<class_6880<class_1320>, class_1322> effect : this.attributes) {
                list.method_71484(effect);
            }
        }

        public static TimedAttributes readData(class_11368 view) {
            int ticks = view.method_71424("ticks", 0);
            double quality = view.method_71422("quality", 0.0);
            double age = view.method_71422("age", 0.0);
            ArrayList<Pair<class_6880<class_1320>, class_1322>> list = new ArrayList<Pair<class_6880<class_1320>, class_1322>>();
            for (Pair effect : view.method_71437("entries", ConsumptionEffect.Attributes.ATTRIBUTE_PAIR.codec())) {
                list.add(effect);
            }
            return new TimedAttributes(ticks, quality, age, list);
        }
    }
}

