/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery.compat;

import eu.pb4.brewery.BreweryInit;
import eu.pb4.brewery.block.BarrelMaterial;
import eu.pb4.brewery.block.BrewBlocks;
import eu.pb4.brewery.drink.DrinkType;
import eu.pb4.brewery.drink.DrinkUtils;
import eu.pb4.brewery.item.BrewItems;
import eu.pb4.polydex.api.v1.recipe.PageBuilder;
import eu.pb4.polydex.api.v1.recipe.PolydexCategory;
import eu.pb4.polydex.api.v1.recipe.PolydexEntry;
import eu.pb4.polydex.api.v1.recipe.PolydexIngredient;
import eu.pb4.polydex.api.v1.recipe.PolydexPage;
import eu.pb4.polydex.api.v1.recipe.PolydexStack;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PolydexCompatImpl {
    public static final PolydexCategory CATEGORY = PolydexCategory.of((class_2960)BreweryInit.id("drink"));

    public static void init() {
        PolydexPage.register(PolydexCompatImpl::createPages);
        PolydexEntry.registerEntryCreator((class_1792)BrewItems.DRINK_ITEM, PolydexCompatImpl::createEntries);
    }

    private static PolydexEntry createEntries(class_1799 stack) {
        DrinkType type = DrinkUtils.getType(stack);
        if (type != null) {
            return PolydexEntry.of((class_2960)BreweryInit.id("drink_bottle/" + BreweryInit.DRINK_TYPE_ID.get(type).method_36181()), (class_1799)stack, PolydexCompatImpl::isPartOf);
        }
        return PolydexEntry.of((class_1799)stack);
    }

    private static boolean isPartOf(PolydexEntry entry, PolydexStack<?> polydexStack) {
        Object object = polydexStack.getBacking();
        if (object instanceof class_1799) {
            class_1799 checked = (class_1799)object;
            object = entry.stack().getBacking();
            if (object instanceof class_1799) {
                class_1799 base = (class_1799)object;
                return DrinkUtils.getType(checked) == DrinkUtils.getType(base) && checked.method_31574(base.method_7909());
            }
        }
        return false;
    }

    private static void createPages(MinecraftServer server, Consumer<PolydexPage> pageConsumer) {
        BreweryInit.DRINK_TYPES.forEach((id, type) -> pageConsumer.accept(new BrewingPage((class_2960)id, (DrinkType)type)));
    }

    public static class BrewingPage
    implements PolydexPage {
        private static final class_2561 TEXTURE = class_2561.method_43470((String)"0").method_10862(class_2583.field_24360.method_27704(BreweryInit.id("gui")));
        public static final class_1799 ICON = new GuiElementBuilder(class_1802.field_16307).setName((class_2561)class_2561.method_43471((String)"polydex.brewery.brewing_recipe")).asStack();
        public static final class_1799 INGREDIENTS = new GuiElementBuilder(class_1802.field_8638).setName((class_2561)class_2561.method_43471((String)"polydex.brewery.ingredients").method_27692(class_124.field_1065)).asStack();
        public static final class_1799 REQUIRE_DISTILLATION = new GuiElementBuilder(class_1802.field_8740).setName((class_2561)class_2561.method_43471((String)"polydex.brewery.require_distillation").method_27692(class_124.field_1054)).asStack();
        public static final class_1799[] ANY_BARREL;
        private final DrinkType type;
        private final List<PolydexIngredient<?>> ingredients;
        private final class_2960 identifier;
        private final class_2960 typeId;

        public BrewingPage(class_2960 identifier, DrinkType type) {
            this.identifier = identifier.method_45138("brewery_drink/");
            this.typeId = identifier;
            this.type = type;
            ArrayList list = new ArrayList();
            for (DrinkType.BrewIngredient x : type.ingredients()) {
                list.add(PolydexIngredient.of((class_1856)class_1856.method_8091((class_1935[])x.items().toArray(new class_1935[0])), (long)x.count()));
            }
            this.ingredients = list;
        }

        @Nullable
        public class_2561 texture(class_3222 player) {
            return TEXTURE;
        }

        public class_2960 identifier() {
            return this.identifier;
        }

        public class_1799 typeIcon(class_3222 serverPlayerEntity) {
            return ICON;
        }

        public class_1799 entryIcon(@Nullable PolydexEntry polydexEntry, class_3222 serverPlayerEntity) {
            return DrinkUtils.createDrink(this.typeId, 0, 10.0, this.type.distillationRuns(), class_2246.field_10124);
        }

        public void createPage(@Nullable PolydexEntry polydexEntry, class_3222 serverPlayerEntity, PageBuilder layer) {
            int i = 0;
            layer.set(4, 0, INGREDIENTS);
            for (PolydexIngredient<?> x : this.ingredients) {
                layer.setIngredient(i % 7 + 1, i / 7 + 1, x);
                if (++i != 14) continue;
                break;
            }
            while (i < 14) {
                layer.setEmpty(i % 7 + 1, i / 7 + 1);
                ++i;
            }
            int key = 2;
            layer.setOutput(4, 3, new class_1799[]{DrinkUtils.createDrink(this.typeId, 0, 10.0, this.type.distillationRuns(), class_2246.field_10124)});
            if (!this.type.barrelInfo().isEmpty()) {
                class_1799[] element;
                DrinkType.BarrelInfo universal = this.type.getBarrelInfo(DrinkType.BarrelInfo.ANY);
                if (universal != null) {
                    element = ANY_BARREL;
                } else if (this.type.barrelInfo().size() == 1) {
                    DrinkType.BarrelInfo data = this.type.barrelInfo().get(0);
                    BarrelMaterial material = BrewBlocks.BARREL_MATERIAL_MAP.get(data.type());
                    element = new class_1799[]{new GuiElementBuilder(material.planks().method_8389()).setName((class_2561)class_2561.method_43471((String)("container.brewery." + material.type().toString().replace("minecraft:", "") + "_barrel")).method_27692(class_124.field_1054)).asStack()};
                } else {
                    ArrayList<class_5250> lore = new ArrayList<class_5250>();
                    ArrayList<class_1792> item = new ArrayList<class_1792>();
                    for (DrinkType.BarrelInfo data : this.type.barrelInfo()) {
                        BarrelMaterial material = BrewBlocks.BARREL_MATERIAL_MAP.get(data.type());
                        item.add(material.planks().method_8389());
                        lore.add(class_2561.method_43471((String)("container.brewery." + String.valueOf(material.type()) + "_barrel")));
                    }
                    GuiElementBuilder b = new GuiElementBuilder();
                    b.setLore(lore);
                    b.setName((class_2561)class_2561.method_43471((String)"polydex.brewery.one_of_barrel").method_27692(class_124.field_1054));
                    ArrayList<class_1799> list = new ArrayList<class_1799>();
                    for (class_1792 a : item) {
                        b.setItem(a);
                        list.add(b.asStack());
                    }
                    element = list.toArray(new class_1799[0]);
                }
                layer.set(key++, 4, element);
            }
            if (this.type.requireDistillation()) {
                layer.set(key++, 4, REQUIRE_DISTILLATION);
            }
        }

        public List<PolydexIngredient<?>> ingredients() {
            return this.ingredients;
        }

        public List<PolydexCategory> categories() {
            return List.of(CATEGORY);
        }

        public boolean isOwner(MinecraftServer minecraftServer, PolydexEntry polydexEntry) {
            Object object = polydexEntry.stack().getBacking();
            if (object instanceof class_1799) {
                class_1799 stack = (class_1799)object;
                return DrinkUtils.getType(stack) == this.type;
            }
            return false;
        }

        static {
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            GuiElementBuilder e = new GuiElementBuilder();
            e.setName((class_2561)class_2561.method_43471((String)"polydex.brewery.any_barrel").method_27692(class_124.field_1054));
            for (BarrelMaterial barrel : BrewBlocks.BARREL_MATERIALS) {
                e.setItem(barrel.planks().method_8389());
                stacks.add(e.asStack());
            }
            ANY_BARREL = stacks.toArray(new class_1799[0]);
        }
    }
}

