/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery.block.entity;

import eu.pb4.brewery.BreweryInit;
import eu.pb4.brewery.block.BrewCauldronBlock;
import eu.pb4.brewery.block.entity.BrewBlockEntities;
import eu.pb4.brewery.block.entity.TickableContents;
import eu.pb4.brewery.drink.DrinkType;
import eu.pb4.brewery.drink.DrinkUtils;
import eu.pb4.brewery.item.BrewComponents;
import eu.pb4.brewery.item.BrewItems;
import eu.pb4.brewery.item.comp.CookingData;
import eu.pb4.brewery.other.BrewGameRules;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.ChunkAttachment;
import eu.pb4.polymer.virtualentity.api.elements.TextDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_5556;
import org.joml.Matrix4f;

public class BrewCauldronBlockEntity
extends class_2586
implements TickableContents {
    private List<class_1799> inventory = new ArrayList<class_1799>();
    private long lastTicked = -1L;
    private double timeCooking = 0.0;
    private ElementHolder elementHolder;
    private final TextDisplayElement[] textDisplayElement = new TextDisplayElement[4];

    public BrewCauldronBlockEntity(class_2338 pos, class_2680 state) {
        super(BrewBlockEntities.CAULDRON, pos, state);
    }

    public static <T extends class_2586> void ticker(class_1937 world, class_2338 pos, class_2680 state, T t) {
        if (t instanceof BrewCauldronBlockEntity) {
            BrewCauldronBlockEntity cauldron = (BrewCauldronBlockEntity)t;
            if (world instanceof class_3218) {
                class_3218 world1 = (class_3218)world;
                long currentTime = world.method_8510();
                if (cauldron.lastTicked == -1L) {
                    cauldron.lastTicked = currentTime;
                    return;
                }
                if (cauldron.elementHolder == null) {
                    cauldron.elementHolder = new ElementHolder();
                    Matrix4f matrix = new Matrix4f();
                    int seconds = (int)(cauldron.timeCooking / 20.0) % 60;
                    int minutes = (int)(cauldron.timeCooking / 1200.0);
                    class_5250 text = class_2561.method_43470((String)(minutes + ":" + (seconds < 10 ? "0" : "") + seconds));
                    for (int i = 0; i < 4; ++i) {
                        TextDisplayElement element = cauldron.textDisplayElement[i] = new TextDisplayElement();
                        element.setTransformation(matrix.rotationY((float)i * 1.5707964f).translate(0.0f, -0.14f, 0.51f));
                        element.setDisplayHeight(1.0f);
                        element.setDisplayWidth(1.0f);
                        element.setText((class_2561)text);
                        element.setViewRange(0.3f);
                        cauldron.elementHolder.addElement((VirtualElement)element);
                    }
                    ChunkAttachment.of((ElementHolder)cauldron.elementHolder, (class_3218)world1, (class_2338)cauldron.field_11867);
                }
                if (BrewCauldronBlock.isValid(pos, state, world)) {
                    cauldron.timeCooking = cauldron.timeCooking + (world1.method_64395().method_8355(BrewGameRules.AGE_UNLOADED) ? (double)(currentTime - cauldron.lastTicked) : 1.0);
                    world1.method_65096((class_2394)class_2398.field_11241, 0.4 * (double)world.field_9229.method_43057(), (6.0 + (double)((Integer)state.method_11654((class_2769)class_5556.field_27206)).intValue() * 3.0) / 16.0, 0.4 * (double)world.field_9229.method_43057(), 0, 0.0, 0.0, 0.0, 0.0);
                    if (cauldron.timeCooking % 20.0 == 0.0) {
                        int seconds = (int)(cauldron.timeCooking / 20.0) % 60;
                        int minutes = (int)(cauldron.timeCooking / 1200.0);
                        class_5250 text = class_2561.method_43470((String)(minutes + ":" + (seconds < 10 ? "0" : "") + seconds));
                        for (int i = 0; i < 4; ++i) {
                            cauldron.textDisplayElement[i].setText((class_2561)text);
                        }
                        cauldron.elementHolder.tick();
                    }
                }
                cauldron.lastTicked = currentTime;
            }
        }
    }

    public void method_11012() {
        super.method_11012();
        if (this.elementHolder != null) {
            this.elementHolder.destroy();
        }
        this.elementHolder = null;
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71466("LastTicked", this.lastTicked);
        class_11372.class_11373 list = view.method_71467("Ingredients", class_1799.field_49266);
        for (class_1799 stack : this.inventory) {
            list.method_71484((Object)stack);
        }
        view.method_71463("CookingTime", this.timeCooking);
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.lastTicked = view.method_71425("LastTicked", 0L);
        this.inventory.clear();
        for (class_1799 item : view.method_71437("Ingredients", class_1799.field_49266)) {
            this.inventory.add(item);
        }
        this.timeCooking = view.method_71422("CookingTime", 0.0);
    }

    public void addIngredients(List<class_1542> entities) {
        for (class_1542 entity : entities) {
            if (!entity.method_6983().method_7960()) {
                class_1799 stack = entity.method_6983().method_7972();
                for (class_1799 existing : this.inventory) {
                    if (class_1799.method_31577((class_1799)stack, (class_1799)existing)) {
                        int count = Math.min(stack.method_7947(), existing.method_7914() - existing.method_7947());
                        existing.method_7933(count);
                        stack.method_7934(count);
                    }
                    if (!stack.method_7960()) continue;
                    break;
                }
                if (!stack.method_7960()) {
                    this.inventory.add(stack);
                }
            }
            entity.method_31472();
        }
    }

    public boolean onUse(class_1657 player) {
        class_1799 stack = player.method_6047();
        if (!stack.method_7960() && BreweryInit.containerIngredient.method_8093(stack)) {
            class_1799 container = stack.method_46651(1);
            stack.method_7934(1);
            double agingMultiplier = ((DoubleRule)((class_3218)this.field_11863).method_64395().method_20746(BrewGameRules.CAULDRON_COOKING_TIME_MULTIPLIER)).get();
            ArrayList<class_1799> ingredients = new ArrayList<class_1799>();
            for (class_1799 nbt : this.inventory) {
                ingredients.add(nbt.method_7972());
            }
            class_2248 heatSource = this.method_10997().method_8320(this.field_11867.method_10074()).method_26204();
            List<DrinkType> types = DrinkUtils.findTypes(ingredients, null, heatSource, container);
            double age = this.timeCooking * agingMultiplier;
            double quality = Double.MIN_VALUE;
            DrinkType match = null;
            for (DrinkType drinkType : types) {
                double q;
                if (drinkType.requireDistillation() || !((q = drinkType.cookingQualityMult().expression().setVariable("age", age / 20.0).evaluate()) > quality)) continue;
                quality = q;
                match = drinkType;
            }
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            for (class_1799 st : this.inventory) {
                stacks.add(st.method_7972());
            }
            CookingData cookingData = new CookingData(age, stacks, heatSource, container);
            if (match == null || quality < 0.0) {
                class_1799 out = new class_1799((class_1935)BrewItems.INGREDIENT_MIXTURE);
                out.method_57379(BrewComponents.COOKING_DATA, (Object)cookingData);
                player.method_7270(out);
            } else {
                player.method_7270(DrinkUtils.createDrink(BreweryInit.DRINK_TYPE_ID.get(match), 0, quality * 10.0, 0, cookingData));
            }
            int level = (Integer)this.method_11010().method_11654((class_2769)class_5556.field_27206) - 1;
            if (level == 0) {
                this.field_11863.method_8501(this.field_11867, class_2246.field_10593.method_9564());
            } else {
                this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(level)));
            }
            return true;
        }
        return false;
    }

    @Override
    public void tickContents(double ticksPassed) {
        this.timeCooking += ticksPassed;
    }
}

