/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery.block.entity;

import com.mojang.serialization.Codec;
import eu.pb4.brewery.BreweryInit;
import eu.pb4.brewery.block.BarrelMaterial;
import eu.pb4.brewery.block.BrewBarrelPartBlock;
import eu.pb4.brewery.block.BrewBlocks;
import eu.pb4.brewery.block.entity.BrewBlockEntities;
import eu.pb4.brewery.block.entity.TickableContents;
import eu.pb4.brewery.drink.DrinkType;
import eu.pb4.brewery.drink.DrinkUtils;
import eu.pb4.brewery.item.BrewComponents;
import eu.pb4.brewery.item.BrewItems;
import eu.pb4.brewery.item.IngredientMixtureItem;
import eu.pb4.brewery.item.comp.BrewData;
import eu.pb4.brewery.item.comp.CookingData;
import eu.pb4.brewery.other.BrewGameRules;
import eu.pb4.sgui.api.gui.SimpleGui;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;

public final class BrewBarrelSpigotBlockEntity
extends class_2621
implements TickableContents,
class_1278 {
    private static final int[] SLOTS = IntStream.range(0, 27).toArray();
    private final LongSet parts = new LongArraySet();
    private class_2371<class_1799> inventory;
    private long lastTicked = -1L;
    private int loadedTime;
    private boolean requestUpdate;
    private BarrelMaterial material = BarrelMaterial.EMPTY;

    public BrewBarrelSpigotBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(BrewBlockEntities.BARREL_SPIGOT, blockPos, blockState);
        this.inventory = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
    }

    public static <T extends class_2586> void ticker(class_1937 world, class_2338 pos, class_2680 state, T t) {
        if (!(t instanceof BrewBarrelSpigotBlockEntity)) {
            return;
        }
        BrewBarrelSpigotBlockEntity barrel = (BrewBarrelSpigotBlockEntity)t;
        ++barrel.loadedTime;
        if (barrel.requestUpdate && world.method_8510() % 20L == 0L) {
            barrel.updateAges();
        }
    }

    private void requestUpdate() {
        this.requestUpdate = true;
    }

    public void updateAges() {
        long currentTime = this.field_11863.method_8510();
        if (this.lastTicked == -1L) {
            this.lastTicked = this.field_11863.method_8510();
            return;
        }
        double agingMultiplier = ((DoubleRule)((class_3218)this.field_11863).method_64395().method_20746(BrewGameRules.BARREL_AGING_MULTIPLIER)).get();
        this.tickContents(((class_3218)this.field_11863).method_64395().method_8355(BrewGameRules.AGE_UNLOADED) ? (double)(currentTime - this.lastTicked) * agingMultiplier : (double)this.loadedTime * agingMultiplier);
        this.lastTicked = currentTime;
        this.loadedTime = 0;
        this.requestUpdate = false;
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        if (!this.method_54872(view)) {
            class_1262.method_5426((class_11372)view, this.inventory);
        }
        view.method_71468("Parts", (Codec)Codec.LONG_STREAM, (Object)Arrays.stream(this.parts.toLongArray()));
        view.method_71469("BarrelType", this.material.type().toString());
        view.method_71466("LastTicked", this.lastTicked);
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (!this.method_54871(view)) {
            class_1262.method_5429((class_11368)view, this.inventory);
        }
        this.parts.clear();
        view.method_71426("Parts", (Codec)Codec.LONG_STREAM).orElse(LongStream.empty()).forEach(arg_0 -> ((LongSet)this.parts).add(arg_0));
        this.material = BrewBlocks.BARREL_MATERIAL_MAP.get(class_2960.method_60654((String)view.method_71428("BarrelType", "")));
        this.lastTicked = view.method_71425("LastTicked", 0L);
    }

    @Override
    public void tickContents(double l) {
        for (int i = 0; i < this.method_5439(); ++i) {
            DrinkType.BarrelInfo barrelInfo;
            class_1799 stack = this.method_5438(i);
            if (stack.method_7960() || !stack.method_31574(BrewItems.INGREDIENT_MIXTURE) && !stack.method_31574((class_1792)BrewItems.DRINK_ITEM)) continue;
            double age = DrinkUtils.getAgeInTicks(stack, 0.0) + l;
            double ageSec = age / 20.0;
            DrinkType oldType = DrinkUtils.getType(stack);
            if (oldType == null && stack.method_57826(BrewComponents.BREW_DATA) && Objects.requireNonNull((BrewData)stack.method_58694(BrewComponents.BREW_DATA)).type().isPresent()) continue;
            List<class_1799> ingredients = IngredientMixtureItem.getIngredients(stack);
            List<DrinkType> types = DrinkUtils.findTypes(ingredients, this.material.type(), DrinkUtils.getHeatSource(stack), DrinkUtils.getContainer(stack));
            if (types.isEmpty() && oldType == null) {
                this.method_5447(i, stack.method_56701((class_1935)BrewItems.FAILED_DRINK_ITEM, stack.method_7947()));
                continue;
            }
            double quality = -1.0;
            DrinkType match = null;
            for (DrinkType type : types) {
                DrinkType.BarrelInfo barrelInfo2 = type.getBarrelInfo(this.material.type());
                if (barrelInfo2 == null || !(ageSec >= (double)barrelInfo2.baseTime())) continue;
                double newAge = ageSec - (double)barrelInfo2.baseTime();
                double q = barrelInfo2.qualityChange().expression().setVariable("quality", type.baseQuality().expression().setVariable("age", newAge).evaluate()).setVariable("age", newAge).evaluate();
                if (!(q > quality)) continue;
                quality = q;
                match = type;
            }
            if (match == null && oldType != null) {
                match = oldType;
            }
            if (match == null) {
                stack.method_57368(BrewComponents.BREW_DATA, (Object)BrewData.DEFAULT, x -> x.withAge(age));
                continue;
            }
            if (quality < 0.0) {
                this.method_5447(i, stack.method_56701((class_1935)BrewItems.FAILED_DRINK_ITEM, stack.method_7947()));
                continue;
            }
            if (stack.method_31574(BrewItems.INGREDIENT_MIXTURE)) {
                class_1799 nStack = new class_1799((class_1935)BrewItems.DRINK_ITEM);
                nStack.method_57379(BrewComponents.COOKING_DATA, (Object)((CookingData)stack.method_58694(BrewComponents.COOKING_DATA)));
                stack = nStack;
                this.method_5447(i, stack);
            }
            if ((barrelInfo = match.getBarrelInfo(this.material.type())) == null) continue;
            double mult = match.cookingQualityMult().expression().setVariable("age", ((CookingData)stack.method_58695(BrewComponents.COOKING_DATA, (Object)CookingData.DEFAULT)).time() / 20.0).evaluate();
            if (quality * mult >= 0.0) {
                stack.method_57379(BrewComponents.BREW_DATA, (Object)new BrewData(Optional.of(BreweryInit.DRINK_TYPE_ID.get(match)), Math.min(quality * mult, 10.0), this.material.type().toString(), 0, age));
                continue;
            }
            this.method_5447(i, stack.method_56701((class_1935)BrewItems.FAILED_DRINK_ITEM, stack.method_7947()));
        }
    }

    protected class_2561 method_17823() {
        return this.material.name();
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return null;
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> inventory) {
        this.inventory = inventory;
    }

    public int method_5439() {
        return 27;
    }

    public void addPart(class_2338 pos) {
        this.parts.add(pos.method_10063());
        this.method_5431();
    }

    public LongSet getParts() {
        return this.parts;
    }

    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        if (this.field_11863 != null) {
            for (class_2338.class_2339 part : this.iterableParts()) {
                class_2680 partState = this.field_11863.method_8320((class_2338)part);
                class_2248 class_22482 = partState.method_26204();
                if (!(class_22482 instanceof BrewBarrelPartBlock)) continue;
                BrewBarrelPartBlock block = (BrewBarrelPartBlock)class_22482;
                this.field_11863.method_8501((class_2338)part, ((BrewBarrelPartBlock.Shape)((Object)partState.method_11654(BrewBarrelPartBlock.SHAPE))).state.apply(block.barrelMaterial));
            }
        }
    }

    public Iterable<class_2338.class_2339> iterableParts() {
        final class_2338.class_2339 pos = new class_2338.class_2339();
        return () -> new Iterator<class_2338.class_2339>(){
            final LongIterator iter;
            {
                this.iter = BrewBarrelSpigotBlockEntity.this.parts.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public class_2338.class_2339 next() {
                long val = this.iter.nextLong();
                return pos.method_10103(class_2338.method_10061((long)val), class_2338.method_10071((long)val), class_2338.method_10083((long)val));
            }
        };
    }

    public void setBarrelType(BarrelMaterial material) {
        this.material = material;
    }

    public void openGui(class_3222 player) {
        this.updateAges();
        new Gui(player);
    }

    public int[] method_5494(class_2350 side) {
        return SLOTS;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return this.canInsert(stack);
    }

    public boolean canInsert(class_1799 stack) {
        if (stack.method_31574((class_1792)BrewItems.DRINK_ITEM)) {
            DrinkType type = DrinkUtils.getType(stack);
            String barrelType = DrinkUtils.getBarrelType(stack);
            return type != null && !type.barrelInfo().isEmpty() && (barrelType.isEmpty() || barrelType.equals(this.material.type()) || DrinkUtils.getAgeInTicks(stack) <= 0.0);
        }
        return stack.method_31574(BrewItems.INGREDIENT_MIXTURE);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return true;
    }

    private class Gui
    extends SimpleGui {
        public Gui(class_3222 player) {
            super(class_3917.field_17326, player, false);
            this.setTitle(BrewBarrelSpigotBlockEntity.this.method_5476());
            for (int i = 0; i < BrewBarrelSpigotBlockEntity.this.method_5439(); ++i) {
                this.setSlotRedirect(i, new class_1735((class_1263)BrewBarrelSpigotBlockEntity.this, i, 0, 0){

                    public boolean method_7680(class_1799 stack) {
                        return BrewBarrelSpigotBlockEntity.this.canInsert(stack);
                    }

                    public int method_7675() {
                        return 1;
                    }

                    public int method_7676(class_1799 stack) {
                        return 1;
                    }
                });
            }
            this.open();
        }

        public void onTick() {
            if (BrewBarrelSpigotBlockEntity.this.method_11015() || BrewBarrelSpigotBlockEntity.this.method_11016().method_10268(this.player.method_23317(), this.player.method_23318(), this.player.method_23321()) > 400.0) {
                this.close();
            }
            BrewBarrelSpigotBlockEntity.this.requestUpdate();
            super.onTick();
        }
    }
}

