/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.pb4.brewery.CardboardWarning;
import eu.pb4.brewery.GenericModInfo;
import eu.pb4.brewery.block.BrewBlocks;
import eu.pb4.brewery.block.BrewCauldronBlock;
import eu.pb4.brewery.block.entity.BrewBlockEntities;
import eu.pb4.brewery.compat.PolydexCompatImpl;
import eu.pb4.brewery.drink.AlcoholValueEffect;
import eu.pb4.brewery.drink.DefaultDefinitions;
import eu.pb4.brewery.drink.DrinkType;
import eu.pb4.brewery.item.BookOfBreweryItem;
import eu.pb4.brewery.item.BrewComponents;
import eu.pb4.brewery.item.BrewItems;
import eu.pb4.brewery.other.BrewCommands;
import eu.pb4.brewery.other.BrewGameRules;
import eu.pb4.brewery.other.BrewNetworking;
import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3298;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BreweryInit
implements ModInitializer {
    public static final String MOD_ID = "brewery";
    public static final Map<class_2960, DrinkType> DRINK_TYPES = new Object2ObjectOpenHashMap();
    public static final Map<DrinkType, class_2960> DRINK_TYPE_ID = new Reference2ObjectOpenHashMap();
    public static final List<AlcoholValueEffect.Value> ALCOHOL_EFFECTS = new ArrayList<AlcoholValueEffect.Value>();
    public static final Object2DoubleMap<class_1792> ITEM_ALCOHOL_REMOVAL_VALUES = new Object2DoubleOpenHashMap();
    public static final Map<class_1792, class_2960> CONTAINER_TO_INGMIX_MODEL = new IdentityHashMap<class_1792, class_2960>();
    public static class_1856 containerIngredient = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8469});
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final boolean IS_DEV = FabricLoader.getInstance().isDevelopmentEnvironment();
    public static final boolean DISPLAY_DEV = IS_DEV;
    public static final boolean USE_GENERATOR = IS_DEV;
    private static class_3218 overworld = null;

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    @Nullable
    public static class_3218 getOverworld() {
        return overworld;
    }

    public void onInitialize() {
        GenericModInfo.build((ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).get());
        PolymerResourcePackUtils.addModAssets((String)MOD_ID);
        BrewBlocks.register();
        BrewComponents.register();
        BrewBlockEntities.register();
        BrewItems.register();
        BrewGameRules.register();
        BrewNetworking.register();
        class_2960 id = BreweryInit.id("early_reload");
        ServerLifecycleEvents.SERVER_STARTED.addPhaseOrdering(id, Event.DEFAULT_PHASE);
        ServerLifecycleEvents.SERVER_STARTING.register(id, BreweryInit::loadDrinks);
        ServerLifecycleEvents.SERVER_STARTED.register(id, BreweryInit::onServerStarted);
        ServerLifecycleEvents.SERVER_STOPPED.register(s -> {
            overworld = null;
        });
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.addPhaseOrdering(id, Event.DEFAULT_PHASE);
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register(id, (x, y, z) -> {
            BreweryInit.loadDrinks(x);
            BookOfBreweryItem.build(DRINK_TYPES.entrySet(), ((DoubleRule)x.method_30002().method_64395().method_20746(BrewGameRules.BARREL_AGING_MULTIPLIER)).get(), ((DoubleRule)x.method_30002().method_64395().method_20746(BrewGameRules.CAULDRON_COOKING_TIME_MULTIPLIER)).get());
        });
        CommandRegistrationCallback.EVENT.register(BrewCommands::register);
        UseBlockCallback.EVENT.register(BrewCauldronBlock::handleUseEvent);
        if (FabricLoader.getInstance().isModLoaded("polydex")) {
            PolydexCompatImpl.init();
        }
    }

    public static void clearData() {
        DRINK_TYPES.clear();
        DRINK_TYPE_ID.clear();
        ITEM_ALCOHOL_REMOVAL_VALUES.clear();
        ALCOHOL_EFFECTS.clear();
        CONTAINER_TO_INGMIX_MODEL.clear();
        containerIngredient = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8469});
    }

    public static void addDrink(class_2960 identifier, DrinkType type) {
        DRINK_TYPES.put(identifier, type);
        DRINK_TYPE_ID.put(type, identifier);
    }

    private static void loadDrinks(MinecraftServer server) {
        AlcoholValueEffect effects;
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)server.method_30611());
        BreweryInit.clearData();
        for (Map.Entry res : server.method_34864().method_14488("brewery_drinks", x -> x.method_12832().endsWith(".json")).entrySet()) {
            class_2960 id = class_2960.method_60655((String)((class_2960)res.getKey()).method_12836(), (String)((class_2960)res.getKey()).method_12832().substring("brewery_drinks/".length(), ((class_2960)res.getKey()).method_12832().length() - 5));
            try {
                Pair drinkType2 = (Pair)DrinkType.CODEC.decode((DynamicOps)ops, (Object)JsonParser.parseReader((Reader)((class_3298)res.getValue()).method_43039())).getOrThrow();
                BreweryInit.addDrink(id, (DrinkType)drinkType2.getFirst());
            }
            catch (Throwable e) {
                DRINK_TYPE_ID.remove(DRINK_TYPES.remove(id));
                LOGGER.warn("{} isn't valid brewery definition!", (Object)((class_2960)res.getKey()).toString());
                e.printStackTrace();
            }
        }
        for (Map.Entry res : server.method_34864().method_14488("", x -> x.method_12832().equals("brewery_effects.json")).entrySet()) {
            try {
                effects = (AlcoholValueEffect)((Pair)AlcoholValueEffect.CODEC.decode((DynamicOps)ops, (Object)JsonParser.parseReader((Reader)((class_3298)res.getValue()).method_43039())).result().get()).getFirst();
                if (effects.replace()) {
                    ALCOHOL_EFFECTS.clear();
                    ITEM_ALCOHOL_REMOVAL_VALUES.clear();
                    CONTAINER_TO_INGMIX_MODEL.clear();
                }
                CONTAINER_TO_INGMIX_MODEL.putAll(effects.ingredientMixModels());
                ALCOHOL_EFFECTS.addAll(effects.entries());
                ITEM_ALCOHOL_REMOVAL_VALUES.putAll(effects.itemReduction());
            }
            catch (Throwable e) {
                LOGGER.warn("{} isn't valid brewery effect definition!", (Object)((class_2960)res.getKey()).toString());
                e.printStackTrace();
            }
        }
        if (USE_GENERATOR) {
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            String potionModelJson = "";
            try {
                potionModelJson = Files.readString(PolymerCommonUtils.getClientJarRoot().resolve("assets/minecraft/items/potion.json"));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            Path dir = FabricLoader.getInstance().getGameDir().resolve("../src/main/resources/data/brewery/brewery_drinks/");
            Path dirModel = FabricLoader.getInstance().getGameDir().resolve("../src/main/resources/assets/brewery/items/");
            String finalPotionModelJson = potionModelJson;
            DefaultDefinitions.createBrews((key, drinkType) -> {
                class_2960 id = class_2960.method_60655((String)MOD_ID, (String)key);
                BreweryInit.addDrink(id, (DrinkType)drinkType.apply(id));
                if (id.method_12832().equals("the_testificate")) {
                    return;
                }
                try {
                    Files.writeString(dirModel.resolve("brewery_drink/" + key + ".json"), (CharSequence)finalPotionModelJson, new OpenOption[0]);
                    Files.writeString(dir.resolve(key + ".json"), (CharSequence)gson.toJson((JsonElement)DrinkType.CODEC.encodeStart((DynamicOps)ops, (Object)((DrinkType)drinkType.apply(id))).getOrThrow()), new OpenOption[0]);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            });
            effects = DefaultDefinitions.createEffects(server);
            if (effects.replace()) {
                ALCOHOL_EFFECTS.clear();
            }
            ALCOHOL_EFFECTS.addAll(effects.entries());
            try {
                Files.writeString(FabricLoader.getInstance().getGameDir().resolve("../src/main/resources/data/brewery/brewery_effects.json"), (CharSequence)gson.toJson((JsonElement)AlcoholValueEffect.CODEC.encodeStart((DynamicOps)ops, (Object)effects).result().get()), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ArrayList list = new ArrayList();
        for (DrinkType drink : DRINK_TYPES.values()) {
            drink.requiredContainer().method_8105().map(class_6880::comp_349).forEach(list::add);
        }
        containerIngredient = class_1856.method_26964(list.stream());
    }

    private static void onServerStarted(MinecraftServer server) {
        CardboardWarning.checkAndAnnounce();
        overworld = server.method_30002();
        BookOfBreweryItem.build(DRINK_TYPES.entrySet(), ((DoubleRule)server.method_30002().method_64395().method_20746(BrewGameRules.BARREL_AGING_MULTIPLIER)).get(), ((DoubleRule)server.method_30002().method_64395().method_20746(BrewGameRules.CAULDRON_COOKING_TIME_MULTIPLIER)).get());
    }
}

