/*
 * Decompiled with CFR 0.152.
 */
package net.kosmo.music.impl.toast;

import java.util.Objects;
import net.kosmo.music.impl.AlbumCover;
import net.kosmo.music.impl.ClientMusic;
import net.kosmo.music.impl.Helper;
import net.kosmo.music.impl.MusicManager;
import net.kosmo.music.impl.RenderHelper;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_368;
import net.minecraft.class_374;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2fStack;

public class MusicToast
implements class_368 {
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"musicnotification", (String)"toast/background");
    private static final class_2960 TEXTURE_EXTENDED = class_2960.method_60655((String)"musicnotification", (String)"toast/background_extended");
    private final Type type = Type.DEFAULT;
    private boolean justUpdated;
    private long startTime;
    private int rotation;
    private class_2561 title;
    private class_2561 author;
    private class_2561 albumName;
    private AlbumCover albumCover;
    private class_368.class_369 visibility;

    public MusicToast(MusicManager.Music music) {
        this.setContent(music);
    }

    public void setContent(MusicManager.Music music) {
        this.visibility = class_368.class_369.field_2210;
        this.title = class_2561.method_43470((String)music.getTitle());
        this.author = class_2561.method_43470((String)music.getAuthor());
        this.albumName = class_2561.method_43470((String)music.getAlbumName());
        this.albumCover = music.albumCover;
        this.justUpdated = true;
    }

    @NotNull
    public class_368.class_369 method_61988() {
        return this.visibility;
    }

    public void method_61989(class_374 toastManager, long l) {
        if (!Helper.isVolumeZero()) {
            this.visibility = class_368.class_369.field_2209;
            return;
        }
        this.visibility = (double)(l - this.startTime) >= 5000.0 * toastManager.method_48221() ? class_368.class_369.field_2209 : class_368.class_369.field_2210;
    }

    public void method_1986(class_332 guiGraphics, class_327 font, long startTime) {
        if (this.rotation >= 360) {
            this.rotation = 0;
        }
        ++this.rotation;
        if (this.justUpdated) {
            this.startTime = startTime;
            this.justUpdated = false;
        }
        if (ClientMusic.config.SHOW_ALBUM_NAME) {
            guiGraphics.method_52706(class_10799.field_56883, TEXTURE_EXTENDED, 0, 0, this.method_29049(), this.method_29050());
        } else {
            guiGraphics.method_52706(class_10799.field_56883, TEXTURE, 0, 0, this.method_29049(), this.method_29050());
        }
        guiGraphics.method_51448().pushMatrix();
        if (ClientMusic.config.ROTATE_ALBUM_COVER) {
            Matrix3x2fStack matrices = guiGraphics.method_51448();
            matrices.translate(0.0f, 0.0f);
            matrices.translate(16.0f, 16.0f);
            matrices.rotate((float)Math.toRadians(this.rotation));
            matrices.translate(-16.0f, -16.0f);
            matrices.translate(0.0f, 0.0f);
        }
        this.albumCover.drawAlbumCover(guiGraphics, 6, 6);
        guiGraphics.method_51448().popMatrix();
        int n = this.method_29049() - 4;
        Objects.requireNonNull(font);
        RenderHelper.drawScrollableText(guiGraphics, font, this.title, 30, 30, 7, n, 7 + 9, ClientMusic.isDarkModeEnabled ? -13108 : -11534256, false, 30, 0, this.method_29049() + 4, this.method_29050());
        if (ClientMusic.config.SHOW_AUTHOR) {
            int n2 = this.method_29049() - 4;
            Objects.requireNonNull(font);
            RenderHelper.drawScrollableText(guiGraphics, font, this.author, 30, 30, 18, n2, 18 + 9, ClientMusic.isDarkModeEnabled ? -3355444 : -16777216, false, 30, 0, this.method_29049() + 4, this.method_29050());
        }
        if (ClientMusic.config.SHOW_ALBUM_NAME) {
            int n3 = this.method_29049() - 4;
            Objects.requireNonNull(font);
            RenderHelper.drawScrollableText(guiGraphics, font, this.albumName, 30, 30, 29, n3, 29 + 9, ClientMusic.isDarkModeEnabled ? -3355444 : -16777216, false, 30, 0, this.method_29049() + 4, this.method_29050());
        }
    }

    public int method_29050() {
        if (ClientMusic.config.SHOW_ALBUM_NAME) {
            return 44;
        }
        return 32;
    }

    @NotNull
    public Type getToken() {
        return this.type;
    }

    public static enum Type {
        DEFAULT;

    }
}

