/*
 * Decompiled with CFR 0.152.
 */
package net.kosmo.music.impl.gui;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import net.kosmo.music.impl.MusicManager;
import net.kosmo.music.impl.gui.JukeboxScreen;
import net.kosmo.music.impl.gui.ListEntry;
import net.kosmo.music.impl.gui.MusicListEntry;
import net.kosmo.music.impl.gui.SoundListEntry;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4265;
import org.jetbrains.annotations.Nullable;

public class PlaySoundListWidget
extends class_4265<ListEntry> {
    public final JukeboxScreen parent;
    private final List<ListEntry> entries = Lists.newArrayList();
    @Nullable
    private String currentSearch;

    public PlaySoundListWidget(JukeboxScreen parent, class_310 client, int width, int height, int y, int itemHeight) {
        super(client, width, height, y, itemHeight);
        this.parent = parent;
    }

    protected void method_57715(class_332 context) {
    }

    protected void method_57713(class_332 context) {
    }

    private void refresh(Collection<ListEntry> values, double scrollAmount) {
        this.entries.clear();
        this.entries.addAll(values);
        this.filterSounds();
        this.method_25314(this.entries);
        this.method_44382(scrollAmount);
    }

    public <T> void update(Collection<T> entries, double scrollAmount) {
        LinkedHashMap<class_2960, ListEntry> map = new LinkedHashMap<class_2960, ListEntry>();
        for (T entry : entries) {
            if (entry instanceof MusicManager.Music) {
                MusicManager.Music music = (MusicManager.Music)entry;
                map.put(music.identifier, new MusicListEntry(this.field_22740, this, music));
                continue;
            }
            if (!(entry instanceof MusicManager.Sound)) continue;
            MusicManager.Sound sound = (MusicManager.Sound)entry;
            map.put(sound.identifier, new SoundListEntry(this.field_22740, this, sound));
        }
        this.refresh(((HashMap)map).values(), scrollAmount);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public void setCurrentSearch(@Nullable String currentSearch) {
        this.currentSearch = currentSearch;
    }

    private void filterSounds() {
        if (this.currentSearch != null) {
            String[] searchTerms = this.currentSearch.toLowerCase(Locale.ROOT).split(" ");
            AtomicReference<Object> matchPredicate = new AtomicReference<Object>(null);
            this.entries.removeIf(entry -> {
                if (entry instanceof MusicListEntry) {
                    MusicListEntry musicEntry = (MusicListEntry)((Object)entry);
                    matchPredicate.set((musicEntry.entry.getTitle() + " " + musicEntry.entry.getAuthor() + " " + musicEntry.entry.getAlbumName()));
                } else if (entry instanceof SoundListEntry) {
                    SoundListEntry soundEntry = (SoundListEntry)((Object)entry);
                    matchPredicate.set(soundEntry.entry.identifier.toString());
                }
                if (matchPredicate.get() == null) {
                    return false;
                }
                return !Arrays.stream(searchTerms).allMatch(term -> ((String)matchPredicate.get()).toLowerCase(Locale.ROOT).contains((CharSequence)term));
            });
            this.method_25314(this.entries);
        }
    }
}

