/*
 * Decompiled with CFR 0.152.
 */
package net.kosmo.music.impl.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.kosmo.music.impl.AlbumCover;
import net.kosmo.music.impl.ClientMusic;
import net.kosmo.music.impl.Helper;
import net.kosmo.music.impl.MusicManager;
import net.kosmo.music.impl.RenderHelper;
import net.kosmo.music.impl.gui.JukeboxScreen;
import net.kosmo.music.impl.gui.ListEntry;
import net.kosmo.music.impl.gui.PlaySoundListWidget;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3419;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_8666;
import net.minecraft.class_9848;

public class MusicListEntry
extends ListEntry {
    public static final int GRAY_COLOR = class_9848.method_61324((int)255, (int)74, (int)74, (int)74);
    private static final class_8666 PLAY_BUTTON_TEXTURE = new class_8666(class_2960.method_60655((String)"musicnotification", (String)"jukebox/play_button"), class_2960.method_60655((String)"musicnotification", (String)"jukebox/play_button_disabled"), class_2960.method_60655((String)"musicnotification", (String)"jukebox/play_button_focused"));
    private static final class_8666 STOP_BUTTON_TEXTURE = new class_8666(class_2960.method_60655((String)"musicnotification", (String)"jukebox/stop_button"), class_2960.method_60655((String)"musicnotification", (String)"jukebox/stop_button_focused"));
    public final ArrayList<class_339> buttons;
    public final MusicManager.Music entry;
    private final class_310 client;
    private final PlaySoundListWidget parent;
    private final class_4185 playButton;
    private final class_4185 stopButton;

    public MusicListEntry(class_310 client, PlaySoundListWidget parent, MusicManager.Music music) {
        this.client = client;
        this.parent = parent;
        this.entry = music;
        this.playButton = new class_344(0, 0, 20, 20, PLAY_BUTTON_TEXTURE, button -> this.onButtonClick(this.entry), (class_2561)class_2561.method_43471((String)"gui.musicnotification.jukebox.play_sound"));
        this.stopButton = new class_344(0, 0, 20, 20, STOP_BUTTON_TEXTURE, button -> this.onButtonClick(this.entry), (class_2561)class_2561.method_43471((String)"gui.musicnotification.jukebox.stop_sound"));
        this.buttons = new ArrayList();
        this.buttons.add((class_339)this.playButton);
        this.buttons.add((class_339)this.stopButton);
    }

    public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        int y1 = y + 4;
        int y2 = y + entryHeight / 2 + 3;
        int xMargeCover = x + 4 + 24 + 4;
        context.method_25294(x, y, x + entryWidth, y + entryHeight, GRAY_COLOR);
        class_5250 text = class_2561.method_43470((String)this.entry.getTitle()).method_27693(" - ").method_54663(-1).method_10852((class_2561)class_2561.method_43470((String)this.entry.getAuthor()).method_54663(-6250336));
        class_327 class_3272 = this.client.field_1772;
        int n = this.playButton.method_46426() - 4;
        Objects.requireNonNull(this.client.field_1772);
        RenderHelper.drawScrollableText(context, class_3272, (class_2561)text, xMargeCover, xMargeCover, y1, n, y1 + 9, -1, true);
        context.method_51433(this.client.field_1772, this.entry.getAlbumName(), xMargeCover, y2, -6250336, false);
        this.entry.albumCover.drawAlbumCover(context, x + 4, y + (entryHeight - AlbumCover.getHeight()) / 2);
        boolean shouldRenderButton = this.parent.parent.currentTab != JukeboxScreen.Tab.HISTORY;
        this.playButton.method_46421(x + (entryWidth - this.playButton.method_25368()) - 8);
        this.playButton.method_46419(y + (entryHeight - this.playButton.method_25364()) / 2);
        boolean bl = this.playButton.field_22763 = Helper.isVolumeZero() && shouldRenderButton && !this.isPlaying();
        if (!this.isPlaying() && shouldRenderButton) {
            this.playButton.method_25394(context, mouseX, mouseY, tickDelta);
        }
        this.stopButton.method_46421(x + (entryWidth - this.stopButton.method_25368()) - 8);
        this.stopButton.method_46419(y + (entryHeight - this.stopButton.method_25364()) / 2);
        boolean bl2 = this.stopButton.field_22763 = this.isPlaying() && shouldRenderButton;
        if (this.isPlaying() && shouldRenderButton) {
            this.stopButton.method_25394(context, mouseX, mouseY, tickDelta);
        }
    }

    private void onButtonClick(MusicManager.Music entry) {
        if (this.isPlaying()) {
            this.client.method_1483().method_4875(null, class_3419.field_15253);
            ClientMusic.currentlyPlaying = null;
        } else {
            Helper.playAndResetTracker(this.client, entry);
        }
    }

    private boolean isPlaying() {
        if (ClientMusic.currentlyPlaying != null) {
            MusicManager.Music e = ClientMusic.musicManager.get(this.entry.identifier);
            if (e == null) {
                return false;
            }
            return e.customId == null ? e.identifier == ClientMusic.currentlyPlaying.method_4775() : e.customId == ClientMusic.currentlyPlaying.method_4775();
        }
        return false;
    }

    public List<? extends class_6379> method_37025() {
        return this.buttons;
    }

    public List<? extends class_364> method_25396() {
        return this.buttons;
    }
}

