/*
 * Decompiled with CFR 0.152.
 */
package net.kosmo.music.impl.gui;

import java.util.Collection;
import java.util.Locale;
import net.kosmo.music.impl.ClientMusic;
import net.kosmo.music.impl.MusicManager;
import net.kosmo.music.impl.gui.PlaySoundListWidget;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_3419;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7923;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public class JukeboxScreen
extends class_437 {
    private static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60655((String)"musicnotification", (String)"jukebox/background");
    private static final class_2960 SEARCH_ICON_TEXTURE = class_2960.method_60655((String)"minecraft", (String)"icon/search");
    private static final class_2561 TITLE = class_2561.method_43471((String)"gui.musicnotification.jukebox.title");
    private static final class_2561 HOME_TAB_TITLE = class_2561.method_43471((String)"gui.musicnotification.jukebox.tab_home");
    private static final class_2561 SOUND_TAB_TITLE = class_2561.method_43471((String)"gui.musicnotification.jukebox.tab_sound");
    private static final class_2561 HISTORY_TAB_TITLE = class_2561.method_43471((String)"gui.musicnotification.jukebox.tab_history");
    private static final class_2561 SELECTED_HOME_TAB_TITLE = HOME_TAB_TITLE.method_27662().method_27692(class_124.field_1073);
    private static final class_2561 SELECTED_SOUND_TAB_TITLE = SOUND_TAB_TITLE.method_27662().method_27692(class_124.field_1073);
    private static final class_2561 SELECTED_HISTORY_TAB_TITLE = HISTORY_TAB_TITLE.method_27662().method_27692(class_124.field_1073);
    private static final class_2561 STOP_SOUND_BUTTON = class_2561.method_43471((String)"gui.musicnotification.jukebox.stop_sound_button");
    private static final class_2561 MASTER_VOLUME_ZERO = class_2561.method_43471((String)"gui.musicnotification.jukebox.master_volume_zero");
    private static final class_2561 MUSIC_VOLUME_ZERO = class_2561.method_43471((String)"gui.musicnotification.jukebox.music_volume_zero");
    private static final class_2561 CLEAR_HISTORY = class_2561.method_43471((String)"gui.musicnotification.jukebox.clear_history");
    private static final class_2561 SEARCH_TEXT = class_2561.method_43471((String)"gui.musicnotification.jukebox.search_hint").method_27692(class_124.field_1056).method_27692(class_124.field_1080);
    private static final class_2561 EMPTY_SEARCH_TEXT = class_2561.method_43471((String)"gui.musicnotification.jukebox.search_empty").method_27692(class_124.field_1080);
    private static final class_2561 EMPTY_HISTORY_TEXT = class_2561.method_43471((String)"gui.musicnotification.jukebox.history_empty").method_27692(class_124.field_1080);
    private final class_5250 header;
    private final class_437 parent;
    public Tab currentTab;
    private class_342 searchBox;
    private PlaySoundListWidget soundList;
    private class_4185 homeTabButton;
    private class_4185 historyTabButton;
    private class_4185 soundTabButton;
    private class_4185 stopSoundButton;
    private class_4185 clearHistoryButton;
    private String currentSearch;
    private boolean initialized;

    public JukeboxScreen(@Nullable class_437 parent) {
        super(TITLE);
        this.parent = parent;
        this.header = this.field_22785.method_27661();
        this.currentTab = Tab.HOME;
        this.currentSearch = "";
    }

    protected void method_25426() {
        if (this.initialized) {
            this.soundList.method_55444(this.field_22789, this.getSoundListBottom() - 88, 0, 88);
        } else {
            this.soundList = new PlaySoundListWidget(this, this.field_22787, this.field_22789, this.getSoundListBottom() - 88, 88, 36);
        }
        int middle = this.soundList.method_25322() / 2;
        int rowLeft = this.soundList.method_25342();
        int rowRigth = this.soundList.method_31383();
        if (ClientMusic.config.DEBUG_MOD) {
            middle = this.soundList.method_25322() / 3;
        }
        this.homeTabButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)HOME_TAB_TITLE, button -> this.setCurrentTab(Tab.HOME)).method_46434(rowLeft, 43, middle, 20).method_46431());
        this.historyTabButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)HISTORY_TAB_TITLE, button -> this.setCurrentTab(Tab.HISTORY)).method_46434(rowLeft + middle + 1, 43, middle, 20).method_46431());
        this.soundTabButton = class_4185.method_46430((class_2561)SOUND_TAB_TITLE, button -> this.setCurrentTab(Tab.SOUND)).method_46434(rowRigth - middle + 1, 43, middle, 20).method_46431();
        if (ClientMusic.config.DEBUG_MOD) {
            this.method_37063((class_364)this.soundTabButton);
        }
        this.stopSoundButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)STOP_SOUND_BUTTON, button -> {
            this.field_22787.method_1483().method_4875(null, class_3419.field_15253);
            ClientMusic.currentlyPlaying = null;
            this.setCurrentTab(this.currentTab);
        }).method_46434(this.soundList.method_25342(), this.getSoundListBottom() + 10, this.soundList.method_31383() - this.soundList.method_25342() - 1 - 50, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24339, button -> this.method_25419()).method_46434(this.soundList.method_31383() - 50, this.getSoundListBottom() + 10, 50, 20).method_46431());
        this.clearHistoryButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)CLEAR_HISTORY, button -> {
            ClientMusic.musicHistory.clear();
            this.setCurrentTab(Tab.HISTORY);
        }).method_46434(10, 10, this.field_22793.method_27525((class_5348)CLEAR_HISTORY) + 8, 20).method_46431());
        this.clearHistoryButton.field_22764 = false;
        String string = this.searchBox != null ? this.searchBox.method_1882() : "";
        this.searchBox = new class_342(this.field_22793, this.getSearchBoxX() + 28, 74, 200, 15, SEARCH_TEXT){

            protected class_5250 method_25360() {
                if (!JukeboxScreen.this.searchBox.method_1882().isEmpty() && JukeboxScreen.this.soundList.isEmpty()) {
                    return super.method_25360().method_27693(", ").method_10852(EMPTY_SEARCH_TEXT);
                }
                return super.method_25360();
            }
        };
        this.searchBox.method_1880(255);
        this.searchBox.method_1862(true);
        this.searchBox.method_1868(-1);
        this.searchBox.method_1852(string);
        this.searchBox.method_47404(SEARCH_TEXT);
        this.searchBox.method_1863(this::onSearchChange);
        this.method_25429((class_364)this.searchBox);
        this.method_25429((class_364)this.soundList);
        this.initialized = true;
        this.setCurrentTab(this.currentTab);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25420(context, mouseX, mouseY, delta);
        int i = this.getSearchBoxX() + 3;
        context.method_52706(class_10799.field_56883, BACKGROUND_TEXTURE, i, 64, 236, this.getScreenHeight() + 16);
        context.method_52706(class_10799.field_56883, SEARCH_ICON_TEXTURE, i + 10, 76, 12, 12);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27535(this.field_22793, (class_2561)this.header, this.getSearchBoxX() + 8, 30, -1);
        if (class_310.method_1551().field_1690.method_1630(class_3419.field_15250) == 0.0f) {
            this.stopSoundButton.method_25355(MASTER_VOLUME_ZERO);
        } else if (class_310.method_1551().field_1690.method_1630(class_3419.field_15253) == 0.0f) {
            this.stopSoundButton.method_25355(MUSIC_VOLUME_ZERO);
        }
        if (!this.soundList.isEmpty()) {
            this.soundList.method_25394(context, mouseX, mouseY, delta);
        } else if (!this.searchBox.method_1882().isEmpty()) {
            context.method_27534(this.field_22787.field_1772, EMPTY_SEARCH_TEXT, this.field_22789 / 2, (72 + this.getSoundListBottom()) / 2, -1);
        } else if (this.currentTab == Tab.HISTORY) {
            context.method_27534(this.field_22787.field_1772, EMPTY_HISTORY_TEXT, this.field_22789 / 2, (72 + this.getSoundListBottom()) / 2, -1);
        }
        this.searchBox.method_25394(context, mouseX, mouseY, delta);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.searchBox.method_1872(false);
        this.searchBox.method_1884(0);
        return super.method_25402(mouseX, mouseY, button);
    }

    private void onSearchChange(String currentSearch) {
        if (!(currentSearch = currentSearch.toLowerCase(Locale.ROOT)).equals(this.currentSearch)) {
            this.soundList.setCurrentSearch(currentSearch);
            this.currentSearch = currentSearch;
            this.setCurrentTab(this.currentTab);
        }
    }

    private void setCurrentTab(Tab currentTab) {
        if (this.currentTab != currentTab) {
            this.searchBox.method_1852("");
        }
        this.currentTab = currentTab;
        this.homeTabButton.method_25355(HOME_TAB_TITLE);
        this.historyTabButton.method_25355(HISTORY_TAB_TITLE);
        this.soundTabButton.method_25355(SOUND_TAB_TITLE);
        this.clearHistoryButton.field_22764 = false;
        boolean listEmpty = false;
        switch (currentTab.ordinal()) {
            case 0: {
                this.homeTabButton.method_25355(SELECTED_HOME_TAB_TITLE);
                this.header.method_27693(" - ").method_10852(HOME_TAB_TITLE);
                Collection<Object> col = ClientMusic.musicManager.musics.values();
                listEmpty = col.isEmpty();
                this.soundList.update(col, this.soundList.method_44387());
                break;
            }
            case 1: {
                this.soundTabButton.method_25355(SELECTED_SOUND_TAB_TITLE);
                this.header.method_27693(" - ").method_10852(SOUND_TAB_TITLE);
                Collection<Object> col = Lists.newArrayList();
                class_7923.field_41172.method_10235().forEach(id -> col.add(new MusicManager.Sound((class_2960)id)));
                listEmpty = col.isEmpty();
                this.soundList.update(col, this.soundList.method_44387());
                break;
            }
            case 2: {
                this.historyTabButton.method_25355(SELECTED_HISTORY_TAB_TITLE);
                this.clearHistoryButton.field_22764 = true;
                this.header.method_27693(" - ").method_10852(HISTORY_TAB_TITLE);
                Collection<Object> col = ClientMusic.musicHistory.getHistory();
                listEmpty = col.isEmpty();
                this.soundList.update(col, this.soundList.method_44387());
            }
        }
        class_333 narratorManager = this.field_22787.method_44713();
        if (!this.searchBox.method_1882().isEmpty() && this.soundList.isEmpty() && !this.searchBox.method_25370()) {
            narratorManager.method_37015(EMPTY_SEARCH_TEXT);
        } else if (listEmpty) {
            if (currentTab == Tab.HOME || currentTab == Tab.SOUND) {
                narratorManager.method_37015(EMPTY_SEARCH_TEXT);
            } else {
                narratorManager.method_37015(EMPTY_HISTORY_TEXT);
            }
        }
    }

    private int getScreenHeight() {
        return Math.max(52, this.field_22790 - 128 - 16);
    }

    private int getSoundListBottom() {
        return 80 + this.getScreenHeight() - 8;
    }

    private int getSearchBoxX() {
        return (this.field_22789 - 238) / 2;
    }

    public static enum Tab {
        HOME,
        SOUND,
        HISTORY;

    }
}

