/*
 * Decompiled with CFR 0.152.
 */
package net.kosmo.music.impl;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.kosmo.music.impl.AlbumCover;
import net.kosmo.music.impl.ClientMusic;
import net.kosmo.music.impl.Helper;
import net.minecraft.class_1144;
import net.minecraft.class_1146;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3414;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import net.minecraft.class_9793;
import org.jetbrains.annotations.Nullable;

public class MusicManager {
    private final class_3300 resourceManager;
    public Map<class_2960, Music> musics = Maps.newHashMap();

    public MusicManager(class_3300 resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void reload() {
        this.musics.clear();
        if (class_310.method_1551().field_1687 != null) {
            class_5455 registryAccess = class_310.method_1551().field_1687.method_30349();
            Optional jukeboxSongRegistry = registryAccess.method_46759(class_7924.field_52176);
            if (jukeboxSongRegistry.isPresent()) {
                for (Object jukeboxSong : ((class_2378)jukeboxSongRegistry.get()).method_29722()) {
                    Music m = Music.parseJukeboxSongRegistry((class_9793)jukeboxSong.getValue());
                    this.musics.put(m.identifier, m);
                }
            } else {
                ClientMusic.LOGGER.error("Failed to load jukebox songs");
            }
        }
        List resources = this.resourceManager.method_14489(ClientMusic.MUSICS_JSON_ID);
        for (class_3298 resource : resources) {
            try {
                for (Map.Entry entry : Helper.parseJSONResource(resource).entrySet()) {
                    Music m = Music.parseJsonObject(entry);
                    AtomicReference<class_1146> wse = new AtomicReference<class_1146>();
                    if (m.customId != null) {
                        wse.set(ClientMusic.soundManager.method_4869(m.customId));
                    } else {
                        wse.set(ClientMusic.soundManager.method_4869(m.identifier));
                    }
                    if (wse.get() != null) {
                        this.musics.put(m.identifier, m);
                        continue;
                    }
                    ClientMusic.LOGGER.warn("Failed to load entry: '{}', sound event '{}' not found", entry.getKey(), (Object)(m.customId != null ? m.customId : m.identifier));
                }
            }
            catch (JsonParseException | IOException e) {
                ClientMusic.LOGGER.error("Error when reading {} in resourcepack: '{}'\nMessage: {}", new Object[]{ClientMusic.MUSICS_JSON_ID, resource.method_14480(), e.getMessage()});
            }
        }
    }

    @Nullable
    public Music get(class_2960 id) {
        Music m = this.musics.get(id);
        if (m == null) {
            m = this.musics.get(class_2960.method_60655((String)id.method_12836(), (String)id.method_12832().replace("records/", "music_disc.")));
        }
        return m;
    }

    public static class Music {
        public final class_2960 identifier;
        @Nullable
        public final class_2960 customId;
        public final String title;
        public final String author;
        @Nullable
        public final String album;
        public final AlbumCover albumCover;
        public final boolean isRandom;

        public Music(class_2960 identifier, @Nullable class_2960 customId, String title, String author, @Nullable String album, AlbumCover albumCover, boolean isRandom) {
            this.identifier = identifier;
            this.customId = customId;
            this.title = title;
            this.author = author;
            this.album = album;
            this.albumCover = albumCover;
            this.isRandom = isRandom;
        }

        public static Music parseJsonObject(Map.Entry<String, JsonElement> json) throws JsonSyntaxException {
            JsonObject jsonObject = json.getValue().getAsJsonObject();
            class_2960 identifier = class_2960.method_60654((String)json.getKey());
            String rawCustomId = class_3518.method_15253((JsonObject)jsonObject, (String)"customId", null);
            class_2960 customId = rawCustomId == null ? null : class_2960.method_60654((String)rawCustomId);
            String title = class_3518.method_15265((JsonObject)jsonObject, (String)"title");
            String author = class_3518.method_15265((JsonObject)jsonObject, (String)"author");
            String album = class_3518.method_15253((JsonObject)jsonObject, (String)"album", null);
            AlbumCover cover = AlbumCover.parseAlbumCover(class_3518.method_15253((JsonObject)jsonObject, (String)"cover", null));
            boolean isRandom = class_3518.method_15258((JsonObject)jsonObject, (String)"isRandom", (boolean)false);
            return new Music(identifier, customId, title, author, album, cover, isRandom);
        }

        public static Music parseJukeboxSongRegistry(class_9793 jukeboxSong) {
            Helper.JukeboxSongParser parsed = new Helper.JukeboxSongParser(jukeboxSong);
            class_2960 location = ((class_3414)jukeboxSong.comp_2835().comp_349()).comp_3319();
            return new Music(location, location, parsed.title, parsed.author, location.toString(), AlbumCover.getDefaultCover(location), false);
        }

        public String toString() {
            return String.format("title: %s, author: %s, album: %s, cover: %s, identifier: %s, customId: %s, isRandom: %s", this.title, this.author, this.album, this.albumCover.textureId, this.identifier, this.customId, this.isRandom);
        }

        public String getTitle() {
            return this.title == null ? "Unknown" : this.title;
        }

        public String getAuthor() {
            return this.author == null ? "Unknown" : this.author;
        }

        public String getAlbumName() {
            return this.album == null ? "Unknown" : this.album;
        }

        @Nullable
        public class_3414 getSoundEvent(class_1144 soundManager) {
            class_2960 id;
            class_2960 class_29602 = id = this.customId == null ? this.identifier : this.customId;
            if (soundManager.method_4869(id) != null) {
                return class_3414.method_47908((class_2960)id);
            }
            return null;
        }
    }

    public static class Sound {
        public final class_2960 identifier;

        public Sound(class_2960 identifier) {
            this.identifier = identifier;
        }

        @Nullable
        public class_3414 getSoundEvent(class_1144 soundManager) {
            if (soundManager.method_4869(this.identifier) != null) {
                return class_3414.method_47908((class_2960)this.identifier);
            }
            return null;
        }
    }
}

