/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen.widget;

import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.screen.widget.AbstractFastChooseWidget;
import io.github.kosmx.emotes.arch.screen.widget.IChooseWheel;
import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.mc.McUtils;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModernChooseWheel
implements IChooseWheel {
    public static int fastMenuPage = 0;
    protected final ArrayList<FastChooseElement> elements = new ArrayList();
    private boolean hovered;
    private final class_2960 TEXTURE;
    private final AbstractFastChooseWidget widget;

    public ModernChooseWheel(AbstractFastChooseWidget widget) {
        this.TEXTURE = PlatformTools.getConfig().dark.get() != false ? McUtils.newIdentifier("textures/gui/fastchoose_dark_new.png") : McUtils.newIdentifier("textures/gui/fastchoose_light_new.png");
        this.widget = widget;
        this.elements.add(new FastChooseElement(0, 0.0f));
        this.elements.add(new FastChooseElement(1, 45.0f));
        this.elements.add(new FastChooseElement(2, 90.0f));
        this.elements.add(new FastChooseElement(3, 135.0f));
        this.elements.add(new FastChooseElement(4, 180.0f));
        this.elements.add(new FastChooseElement(5, 225.0f));
        this.elements.add(new FastChooseElement(6, 270.0f));
        this.elements.add(new FastChooseElement(7, 315.0f));
    }

    @Nullable
    protected FastChooseElement getActivePart(int mouseX, int mouseY) {
        int x = mouseX - this.widget.method_46426() - this.widget.method_25368() / 2;
        int y = mouseY - this.widget.method_46427() - this.widget.method_25364() / 2;
        int i = 0;
        double pi = Math.PI;
        double distanceFromCenter = Math.sqrt(x * x + y * y);
        if (distanceFromCenter < (double)this.widget.method_25368() * 0.17 || distanceFromCenter > (double)this.widget.method_25368() / 2.0) {
            return null;
        }
        float degrees = (float)(Math.abs((Math.atan2(y, x) - pi) / (2.0 * pi) * 360.0 - 270.0) % 360.0);
        if ((double)degrees < 22.5) {
            i = 0;
        } else if ((double)degrees < 67.5) {
            i = 1;
        } else if ((double)degrees < 112.5) {
            i = 2;
        } else if ((double)degrees < 157.5) {
            i = 3;
        } else if ((double)degrees < 202.5) {
            i = 4;
        } else if ((double)degrees < 247.5) {
            i = 5;
        } else if ((double)degrees < 292.5) {
            i = 6;
        } else if ((double)degrees < 337.5) {
            i = 7;
        }
        return this.elements.get(i);
    }

    private int getPageButton(int mouseX, int mouseY) {
        int y;
        int x = mouseX - this.widget.method_46426() - this.widget.method_25368() / 2;
        double distanceFromCenter = Math.sqrt(x * x + (y = mouseY - this.widget.method_46427() - this.widget.method_25364() / 2) * y);
        if (distanceFromCenter < (double)this.widget.method_25368() * 0.17 || distanceFromCenter > (double)this.widget.method_25368() / 2.0) {
            if (x > 1) {
                return 1;
            }
            if (x < 1) {
                return 0;
            }
        }
        return -1;
    }

    public void method_25394(@NotNull class_332 matrices, int mouseX, int mouseY, float delta) {
        Object part;
        this.checkHovered(mouseX, mouseY);
        this.drawTexture(matrices, this.TEXTURE, 0, 0, 0, 0, 2);
        if (this.hovered && (part = this.getActivePart(mouseX, mouseY)) != null && this.widget.doHoverPart((IChooseWheel.IChooseElement)part)) {
            ((FastChooseElement)part).renderHover(matrices, this.TEXTURE);
        }
        for (FastChooseElement f : this.elements) {
            if (!f.hasEmote()) continue;
            f.render(matrices);
        }
        class_5250 text = class_2561.method_43470((String)String.valueOf(fastMenuPage + 1));
        matrices.method_27535(class_310.method_1551().field_1772, (class_2561)text, (int)((float)this.widget.method_46426() + (float)this.widget.method_25368() / 2.0f - 2.0f), (int)((float)this.widget.method_46427() + (float)this.widget.method_25364() / 2.0f - 3.0f), -1);
    }

    private void drawTexture(class_332 matrices, class_2960 t, int x, int y, int u, int v, int s) {
        matrices.method_25302(class_10799.field_56883, t, this.widget.method_46426() + x * this.widget.method_25368() / 256, this.widget.method_46427() + y * this.widget.method_25364() / 256, (float)u, (float)v, s * this.widget.method_25368() / 2, s * this.widget.method_25364() / 2, s * 128, s * 128, 512, 512);
    }

    private void drawTexture_select(class_332 matrices, class_2960 t, int x, int y, int u, int v, int w, int h) {
        matrices.method_25302(class_10799.field_56883, t, this.widget.method_46426() + x * this.widget.method_25368() / 512, this.widget.method_46427() + y * this.widget.method_25364() / 512, (float)u, (float)v, w * this.widget.method_25368() / 2, h * this.widget.method_25364() / 2, w * 128, h * 128, 512, 512);
    }

    private void checkHovered(int mouseX, int mouseY) {
        this.hovered = mouseX >= this.widget.method_46426() && mouseY >= this.widget.method_46427() && mouseX <= this.widget.method_46426() + this.widget.method_25368() && mouseY <= this.widget.method_46427() + this.widget.method_25364();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.checkHovered((int)mouseX, (int)mouseY);
        if (this.hovered && this.widget.method_25351(button)) {
            FastChooseElement element = this.getActivePart((int)mouseX, (int)mouseY);
            if (element != null) {
                return this.widget.onClick(element, button);
            }
            int selectedPageButton = this.getPageButton((int)mouseX, (int)mouseY);
            if (selectedPageButton == 0) {
                fastMenuPage = fastMenuPage > 0 ? --fastMenuPage : PlatformTools.getConfig().fastMenuEmotes.length - 1;
            } else if (selectedPageButton == 1) {
                fastMenuPage = fastMenuPage < PlatformTools.getConfig().fastMenuEmotes.length - 1 ? ++fastMenuPage : 0;
            }
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        this.checkHovered((int)mouseX, (int)mouseY);
        if (verticalAmount < 0.0) {
            if (fastMenuPage < PlatformTools.getConfig().fastMenuEmotes.length - 1) {
                ++fastMenuPage;
                return true;
            }
        } else if (fastMenuPage > 0) {
            --fastMenuPage;
            return true;
        }
        return false;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        this.checkHovered((int)mouseX, (int)mouseY);
        return this.hovered;
    }

    protected class FastChooseElement
    implements IChooseWheel.IChooseElement {
        private final float angle;
        private final int id;

        protected FastChooseElement(int num, float angle) {
            this.angle = angle;
            this.id = num;
        }

        @Override
        public boolean hasEmote() {
            return PlatformTools.getConfig().fastMenuEmotes[fastMenuPage][this.id] != null;
        }

        @Override
        public void setEmote(@Nullable EmoteHolder emote) {
            PlatformTools.getConfig().fastMenuEmotes[ModernChooseWheel.fastMenuPage][this.id] = emote == null ? null : emote.getUuid();
        }

        @Override
        @Nullable
        public EmoteHolder getEmote() {
            UUID uuid = PlatformTools.getConfig().fastMenuEmotes[fastMenuPage][this.id];
            if (uuid != null) {
                EmoteHolder emote = (EmoteHolder)EmoteHolder.list.get(uuid);
                if (emote == null && ModernChooseWheel.this.widget.doesShowInvalid()) {
                    emote = new EmoteHolder.Empty(uuid);
                }
                return emote;
            }
            return null;
        }

        @Override
        public void clearEmote() {
            this.setEmote(null);
        }

        public void render(class_332 matrices) {
            class_2960 identifier;
            UUID emoteID = PlatformTools.getConfig().fastMenuEmotes[fastMenuPage][this.id] != null ? PlatformTools.getConfig().fastMenuEmotes[fastMenuPage][this.id] : null;
            class_2960 class_29602 = identifier = emoteID != null && EmoteHolder.list.get(emoteID) != null ? ((EmoteHolder)EmoteHolder.list.get(emoteID)).getIconIdentifier() : null;
            if (identifier != null && PlatformTools.getConfig().showIcons.get().booleanValue()) {
                int s = ModernChooseWheel.this.widget.method_25368() / 10;
                int iconX = (int)((double)(ModernChooseWheel.this.widget.method_46426() + ModernChooseWheel.this.widget.method_25368() / 2) + (double)ModernChooseWheel.this.widget.method_25368() * 0.36 * Math.sin((double)this.angle * 0.0174533)) - s;
                int iconY = (int)((double)(ModernChooseWheel.this.widget.method_46427() + ModernChooseWheel.this.widget.method_25364() / 2) + (double)ModernChooseWheel.this.widget.method_25364() * 0.36 * Math.cos((double)this.angle * 0.0174533)) - s;
                matrices.method_25302(class_10799.field_56883, identifier, iconX, iconY, 0.0f, 0.0f, s * 2, s * 2, 256, 256, 256, 256);
            } else if (PlatformTools.getConfig().fastMenuEmotes[fastMenuPage][this.id] != null) {
                this.drawCenteredText(matrices, EmoteHolder.getNonNull((UUID)PlatformTools.getConfig().fastMenuEmotes[ModernChooseWheel.fastMenuPage][this.id]).name, this.angle);
            } else {
                CommonData.LOGGER.warn("Tried to render non-existing name");
            }
        }

        public void drawCenteredText(class_332 matrixStack, class_2561 stringRenderable, float deg) {
            this.drawCenteredText(matrixStack, stringRenderable, (float)((double)(ModernChooseWheel.this.widget.method_46426() + ModernChooseWheel.this.widget.method_25368() / 2) + (double)ModernChooseWheel.this.widget.method_25368() * 0.4 * Math.sin((double)deg * 0.0174533)), (float)((double)(ModernChooseWheel.this.widget.method_46427() + ModernChooseWheel.this.widget.method_25364() / 2) + (double)ModernChooseWheel.this.widget.method_25364() * 0.4 * Math.cos((double)deg * 0.0174533)));
        }

        public void drawCenteredText(class_332 matrices, class_2561 stringRenderable, float x, float y) {
            int c = PlatformTools.getConfig().dark.get() != false ? 255 : 0;
            float x1 = x - (float)class_310.method_1551().field_1772.method_27525((class_5348)stringRenderable) / 2.0f;
            matrices.method_27535(class_310.method_1551().field_1772, stringRenderable, (int)x1, (int)(y - 2.0f), class_9848.method_61324((int)255, (int)c, (int)c, (int)c));
        }

        public void renderHover(class_332 matrices, class_2960 t) {
            switch (this.id) {
                case 0: {
                    ModernChooseWheel.this.drawTexture_select(matrices, t, 0, 256, 0, 384, 2, 1);
                    break;
                }
                case 1: {
                    ModernChooseWheel.this.drawTexture_select(matrices, t, 256, 256, 384, 384, 1, 1);
                    break;
                }
                case 2: {
                    ModernChooseWheel.this.drawTexture_select(matrices, t, 256, 0, 384, 0, 1, 2);
                    break;
                }
                case 3: {
                    ModernChooseWheel.this.drawTexture_select(matrices, t, 256, 0, 384, 256, 1, 1);
                    break;
                }
                case 4: {
                    ModernChooseWheel.this.drawTexture_select(matrices, t, 0, 0, 0, 256, 2, 1);
                    break;
                }
                case 5: {
                    ModernChooseWheel.this.drawTexture_select(matrices, t, 0, 0, 256, 256, 1, 1);
                    break;
                }
                case 6: {
                    ModernChooseWheel.this.drawTexture_select(matrices, t, 0, 0, 256, 0, 1, 2);
                    break;
                }
                case 7: {
                    ModernChooseWheel.this.drawTexture_select(matrices, t, 0, 256, 256, 384, 1, 1);
                }
            }
        }
    }
}

