/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen.widget;

import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.screen.widget.AbstractFastChooseWidget;
import io.github.kosmx.emotes.arch.screen.widget.IChooseWheel;
import io.github.kosmx.emotes.arch.screen.widget.ModernChooseWheel;
import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.mc.McUtils;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public class LegacyChooseWidget
implements IChooseWheel {
    protected final ArrayList<FastChooseElement> elements = new ArrayList();
    private boolean hovered;
    private final class_2960 TEXTURE;
    private final AbstractFastChooseWidget widget;

    public LegacyChooseWidget(AbstractFastChooseWidget widget) {
        this.TEXTURE = PlatformTools.getConfig().dark.get() != false ? McUtils.newIdentifier("textures/gui/fastchoose_dark.png") : McUtils.newIdentifier("textures/gui/fastchoose_light.png");
        this.widget = widget;
        this.elements.add(new FastChooseElement(0, 22.5f));
        this.elements.add(new FastChooseElement(1, 67.5f));
        this.elements.add(new FastChooseElement(2, 157.5f));
        this.elements.add(new FastChooseElement(3, 112.5f));
        this.elements.add(new FastChooseElement(4, 337.5f));
        this.elements.add(new FastChooseElement(5, 292.5f));
        this.elements.add(new FastChooseElement(6, 202.5f));
        this.elements.add(new FastChooseElement(7, 247.5f));
    }

    public void drawCenteredText(class_332 matrixStack, class_2561 stringRenderable, float deg) {
        this.drawCenteredText(matrixStack, stringRenderable, (float)((double)(this.widget.method_46426() + this.widget.method_25368() / 2) + (double)this.widget.method_25368() * 0.4 * Math.sin((double)deg * 0.0174533)), (float)((double)(this.widget.method_46427() + this.widget.method_25364() / 2) + (double)this.widget.method_25364() * 0.4 * Math.cos((double)deg * 0.0174533)));
    }

    public void drawCenteredText(class_332 matrices, class_2561 stringRenderable, float x, float y) {
        int c = PlatformTools.getConfig().dark.get() != false ? 255 : 0;
        float x1 = x - (float)class_310.method_1551().field_1772.method_27525((class_5348)stringRenderable) / 2.0f;
        matrices.method_27535(class_310.method_1551().field_1772, stringRenderable, (int)x1, (int)(y - 2.0f), class_9848.method_61324((int)255, (int)c, (int)c, (int)c));
    }

    @Nullable
    protected FastChooseElement getActivePart(int mouseX, int mouseY) {
        int x = mouseX - this.widget.method_46426() - this.widget.method_25368() / 2;
        int y = mouseY - this.widget.method_46427() - this.widget.method_25364() / 2;
        int i = 0;
        if (x == 0) {
            return null;
        }
        if (x < 0) {
            i += 4;
        }
        if (y == 0) {
            return null;
        }
        if (y < 0) {
            i += 2;
        }
        if (Math.abs(x) == Math.abs(y)) {
            return null;
        }
        if (Math.abs(x) > Math.abs(y)) {
            ++i;
        }
        return this.elements.get(i);
    }

    public void method_25394(class_332 matrices, int mouseX, int mouseY, float delta) {
        FastChooseElement part;
        this.checkHovered(mouseX, mouseY);
        this.drawTexture(matrices, this.TEXTURE, 0, 0, 0, 0, 2);
        if (this.hovered && (part = this.getActivePart(mouseX, mouseY)) != null && this.widget.doHoverPart(part)) {
            part.renderHover(matrices, this.TEXTURE);
        }
        for (FastChooseElement f : this.elements) {
            if (!f.hasEmote()) continue;
            f.render(matrices);
        }
    }

    private void drawTexture(class_332 matrices, class_2960 texture, int x, int y, int u, int v, int s) {
        matrices.method_25302(class_10799.field_56883, texture, this.widget.method_46426() + x * this.widget.method_25368() / 256, this.widget.method_46427() + y * this.widget.method_25364() / 256, (float)u, (float)v, s * this.widget.method_25368() / 2, s * this.widget.method_25364() / 2, s * 128, s * 128, 512, 512);
    }

    private void checkHovered(int mouseX, int mouseY) {
        this.hovered = mouseX >= this.widget.method_46426() && mouseY >= this.widget.method_46427() && mouseX <= this.widget.method_46426() + this.widget.method_25368() && mouseY <= this.widget.method_46427() + this.widget.method_25364();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        FastChooseElement element;
        this.checkHovered((int)mouseX, (int)mouseY);
        if (this.hovered && this.widget.method_25351(button) && (element = this.getActivePart((int)mouseX, (int)mouseY)) != null) {
            return this.widget.onClick(element, button);
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return false;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        this.checkHovered((int)mouseX, (int)mouseY);
        return this.hovered;
    }

    protected class FastChooseElement
    implements IChooseWheel.IChooseElement {
        private final float angle;
        private final int id;

        protected FastChooseElement(int num, float angle) {
            this.angle = angle;
            this.id = num;
        }

        @Override
        public boolean hasEmote() {
            int fastMenuPage = ModernChooseWheel.fastMenuPage;
            return PlatformTools.getConfig().fastMenuEmotes[fastMenuPage][this.id] != null;
        }

        @Override
        public void setEmote(@Nullable EmoteHolder emote) {
            int fastMenuPage = ModernChooseWheel.fastMenuPage;
            PlatformTools.getConfig().fastMenuEmotes[fastMenuPage][this.id] = emote == null ? null : emote.getUuid();
        }

        @Override
        @Nullable
        public EmoteHolder getEmote() {
            int fastMenuPage = ModernChooseWheel.fastMenuPage;
            UUID uuid = PlatformTools.getConfig().fastMenuEmotes[fastMenuPage][this.id];
            if (uuid != null) {
                EmoteHolder emote = (EmoteHolder)EmoteHolder.list.get(uuid);
                if (emote == null && LegacyChooseWidget.this.widget.doesShowInvalid()) {
                    emote = new EmoteHolder.Empty(uuid);
                }
                return emote;
            }
            return null;
        }

        @Override
        public void clearEmote() {
            this.setEmote(null);
        }

        public void render(class_332 matrices) {
            class_2960 identifier;
            int fastMenuPage = ModernChooseWheel.fastMenuPage;
            UUID emoteID = PlatformTools.getConfig().fastMenuEmotes[fastMenuPage][this.id] != null ? PlatformTools.getConfig().fastMenuEmotes[fastMenuPage][this.id] : null;
            class_2960 class_29602 = identifier = emoteID != null && EmoteHolder.list.get(emoteID) != null ? ((EmoteHolder)EmoteHolder.list.get(emoteID)).getIconIdentifier() : null;
            if (identifier != null && PlatformTools.getConfig().showIcons.get().booleanValue()) {
                int s = LegacyChooseWidget.this.widget.method_25368() / 10;
                int iconX = (int)((double)(LegacyChooseWidget.this.widget.method_46426() + LegacyChooseWidget.this.widget.method_25368() / 2) + (double)LegacyChooseWidget.this.widget.method_25368() * 0.4 * Math.sin((double)this.angle * 0.0174533)) - s;
                int iconY = (int)((double)(LegacyChooseWidget.this.widget.method_46427() + LegacyChooseWidget.this.widget.method_25364() / 2) + (double)LegacyChooseWidget.this.widget.method_25364() * 0.4 * Math.cos((double)this.angle * 0.0174533)) - s;
                matrices.method_25302(class_10799.field_56883, identifier, iconX, iconY, 0.0f, 0.0f, s * 2, s * 2, 256, 256, 256, 256);
            } else if (PlatformTools.getConfig().fastMenuEmotes[fastMenuPage][this.id] != null) {
                LegacyChooseWidget.this.drawCenteredText(matrices, EmoteHolder.getNonNull((UUID)PlatformTools.getConfig().fastMenuEmotes[fastMenuPage][this.id]).name, this.angle);
            } else {
                CommonData.LOGGER.warn("Tried to render non-existing name");
            }
        }

        public void renderHover(class_332 matrices, class_2960 texture) {
            int textX = 0;
            int textY = 0;
            int x = 0;
            int y = 0;
            if ((this.id & 1) == 0) {
                textY = 256;
            } else {
                textX = 256;
            }
            if ((this.id & 2) == 0) {
                y = 128;
            }
            if ((this.id & 4) == 0) {
                x = 128;
            }
            LegacyChooseWidget.this.drawTexture(matrices, texture, x, y, textX + x, textY + y, 1);
        }
    }
}

