/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen;

import com.zigythebird.playeranimcore.animation.Animation;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.api.proxy.AbstractNetworkInstance;
import io.github.kosmx.emotes.arch.screen.EmoteMenu;
import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import io.github.kosmx.emotes.server.serializer.type.ISerializer;
import io.github.kosmx.emotes.server.services.InstanceService;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7845;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import net.raphimc.noteblocklib.NoteBlockLib;
import net.raphimc.noteblocklib.model.Song;
import org.apache.commons.io.FilenameUtils;

public class ExportMenu
extends class_437 {
    private static final class_2561 TITLE = class_2561.method_43471((String)"emotecraft.options.export");
    private final class_8132 layout = new class_8132((class_437)this);
    protected final class_437 parent;

    public ExportMenu(class_437 parent) {
        super(TITLE);
        this.parent = parent;
    }

    public void method_25426() {
        this.layout.method_57726(this.method_25440(), this.field_22793);
        class_7845 gridLayout = new class_7845();
        gridLayout.method_46458().method_46477(8).method_46475(4).method_46467();
        class_7845.class_7939 rowHelper = gridLayout.method_47610(2);
        for (ISerializer serializer : UniversalEmoteSerializer.getSerializers().toList()) {
            rowHelper.method_47612((class_8021)class_4185.method_46430((class_2561)class_2561.method_43469((String)"emotecraft.export", (Object[])new Object[]{serializer.getExtension()}), button -> this.exportEmotesInFormat(serializer)).method_46432(200).method_46431());
        }
        this.layout.method_48999((class_8021)gridLayout);
        class_8667 footer = (class_8667)this.layout.method_48996((class_8021)class_8667.method_52742().method_52735(8));
        footer.method_52736((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46431());
        footer.method_52736((class_8021)class_4185.method_46430((class_2561)EmoteMenu.OPEN_FOLDER, button -> PlatformTools.openExternalEmotesDir()).method_46431());
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.method_48640();
    }

    private void exportEmotesInFormat(ISerializer format) {
        for (EmoteHolder emoteHolder : EmoteHolder.list) {
            Animation emote = emoteHolder.getEmote();
            if (emote.data().has("isBuiltin") && !PlatformTools.getConfig().exportBuiltin.get().booleanValue()) continue;
            CommonData.LOGGER.debug("Saving {} into {}", (Object)emoteHolder.name.getString(), (Object)format.getExtension());
            try {
                Path exportDir = InstanceService.INSTANCE.getExternalEmoteDir().resolve(format.getExtension() + "_export");
                if (!exportDir.toFile().isDirectory()) {
                    Files.createDirectories(exportDir, new FileAttribute[0]);
                }
                Path file = ExportMenu.createFileName(emoteHolder, exportDir, format.getExtension());
                try (OutputStream stream = Files.newOutputStream(file, new OpenOption[0]);){
                    UniversalEmoteSerializer.writeKeyframeAnimation(stream, emote, "emote." + format.getExtension());
                }
                if (!format.onlyEmoteFile()) continue;
                String fileName = FilenameUtils.removeExtension((String)file.getFileName().toString());
                if (emote.data().has("iconData")) {
                    Path iconPath = exportDir.resolve(fileName + ".png");
                    if (Files.exists(iconPath, new LinkOption[0])) {
                        throw new IOException("File already exists: " + String.valueOf(iconPath));
                    }
                    try (OutputStream iconStream = Files.newOutputStream(iconPath, new OpenOption[0]);){
                        iconStream.write(AbstractNetworkInstance.safeGetBytesFromBuffer((ByteBuffer)emote.data().getRaw("iconData")));
                        iconStream.flush();
                    }
                }
                if (!emote.data().has("song")) continue;
                Path songPath = exportDir.resolve(fileName + ".nbs");
                if (Files.exists(songPath, new LinkOption[0])) {
                    throw new IOException("File already exists: " + String.valueOf(songPath));
                }
                NoteBlockLib.writeSong((Song)((Song)emote.data().getRaw("song")), (Path)songPath);
            }
            catch (Exception e) {
                CommonData.LOGGER.warn("Failed to export!", (Throwable)e);
                PlatformTools.addToast((class_2561)class_2561.method_43469((String)"emotecraft.export.error", (Object[])new Object[]{format.getExtension()}), emoteHolder.name);
            }
        }
        PlatformTools.addToast((class_2561)class_2561.method_43469((String)"emotecraft.export.done", (Object[])new Object[]{format.getExtension()}), (class_2561)class_2561.method_43470((String)("emotes/" + format.getExtension() + "_export/")));
        CommonData.LOGGER.info("All emotes are saved in {} format!", (Object)format.getExtension());
    }

    private static Path createFileName(EmoteHolder emote, Path originPath, String format) {
        Object name = emote.name.getString().replaceAll("[\\\\/]", "#");
        String finalName = null;
        while (finalName == null) {
            try {
                originPath.resolve((String)name);
                finalName = name;
            }
            catch (InvalidPathException e) {
                int i = e.getIndex();
                name = ((String)name).substring(0, i) + "#" + ((String)name).substring(i + 1);
            }
        }
        int i = 2;
        Path file = originPath.resolve(finalName + "." + format);
        if (!file.getParent().equals(originPath)) {
            finalName = Integer.toString(emote.hashCode());
            file = originPath.resolve(finalName + "." + format);
        }
        while (file.toFile().isFile()) {
            file = originPath.resolve(finalName + "_" + i++ + "." + format);
        }
        return file;
    }

    protected void method_48640() {
        this.layout.method_48222();
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }
}

