/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.api.events.client;

import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.event.Event;
import com.zigythebird.playeranimcore.event.EventResult;
import java.util.UUID;

public final class ClientEmoteEvents {
    public static final Event<EmoteVerifier> EMOTE_VERIFICATION = new Event(listeners -> (emote, userID) -> {
        for (EmoteVerifier listener : listeners) {
            EventResult result = listener.verify(emote, userID);
            if (result != EventResult.FAIL && result != EventResult.SUCCESS) continue;
            return result;
        }
        return EventResult.PASS;
    });
    public static final Event<EmotePlayEvent> EMOTE_PLAY = new Event(listeners -> (emote, tick, userID) -> {
        for (EmotePlayEvent listener : listeners) {
            listener.onEmotePlay(emote, tick, userID);
        }
    });
    public static final Event<EmoteStopEvent> EMOTE_STOP = new Event(listeners -> (emote, userID) -> {
        for (EmoteStopEvent listener : listeners) {
            listener.onEmoteStop(emote, userID);
        }
    });
    public static final Event<LocalEmoteStopEvent> LOCAL_EMOTE_STOP = new Event(listeners -> () -> {
        for (LocalEmoteStopEvent listener : listeners) {
            listener.onEmoteStop();
        }
    });

    @FunctionalInterface
    public static interface LocalEmoteStopEvent {
        public void onEmoteStop();
    }

    @FunctionalInterface
    public static interface EmoteStopEvent {
        public void onEmoteStop(UUID var1, UUID var2);
    }

    @FunctionalInterface
    public static interface EmotePlayEvent {
        public void onEmotePlay(Animation var1, float var2, UUID var3);
    }

    @FunctionalInterface
    public static interface EmoteVerifier {
        public EventResult verify(Animation var1, UUID var2);
    }
}

