/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.motschen.rocks.datagen;

import eu.midnightdust.motschen.rocks.RocksMain;
import eu.midnightdust.motschen.rocks.blockstates.StarfishVariation;
import eu.midnightdust.motschen.rocks.util.RockType;
import eu.midnightdust.motschen.rocks.util.StickType;
import java.util.HashMap;
import java.util.Optional;
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_10410;
import net.minecraft.class_10439;
import net.minecraft.class_10821;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_6012;
import net.minecraft.class_7923;
import net.minecraft.class_807;
import net.minecraft.class_813;

public class Models
extends FabricModelProvider {
    public static final class_4945 ZERO_TEXTURE_KEY = class_4945.method_27043((String)"0");

    public Models(FabricDataOutput output) {
        super(output);
    }

    public static class_2960 getBlockId(String s) {
        return RocksMain.id("block/" + s);
    }

    public static class_2960 getItemId(String s) {
        return RocksMain.id("item/" + s);
    }

    public static class_4942 getSimpleParentModel(class_2960 parentId, String variant) {
        return new class_4942(Optional.of(parentId), Optional.of(variant), new class_4945[]{ZERO_TEXTURE_KEY});
    }

    public void generateBlockStateModels(class_4910 bsModelGenerator) {
        class_2248 block;
        for (RockType rockType : RockType.values()) {
            block = (class_2248)class_7923.field_41175.method_63535(RocksMain.id(rockType.getName()));
            RockModel.registerBlockModel(bsModelGenerator, block, rockType.getStoneBlock());
        }
        for (Enum enum_ : StickType.values()) {
            block = (class_2248)class_7923.field_41175.method_63535(RocksMain.id(((StickType)enum_).getName() + "_stick"));
            StickModel.registerBlockModel(bsModelGenerator, block, ((StickType)enum_).getBaseBlock());
        }
    }

    public void generateItemModels(class_4915 itemModelGenerator) {
        class_1792 item;
        for (RockType rockType : RockType.values()) {
            item = (class_1792)class_7923.field_41178.method_63535(RocksMain.id(rockType.getName()));
            Models.registerParentedItemModel(itemModelGenerator, item, Models.getItemId("rock_base"), rockType.getStoneBlock());
            if (rockType == RockType.GRAVEL) continue;
            class_1792 splitter = (class_1792)class_7923.field_41178.method_63535(RocksMain.id(rockType.getFragment().getName()));
            Models.registerParentedItemModel(itemModelGenerator, splitter, Models.getItemId("splitter_base"), rockType.getFragment().getStoneBlock());
        }
        for (Enum enum_ : StickType.values()) {
            item = (class_1792)class_7923.field_41178.method_63535(RocksMain.id(((StickType)enum_).getName() + "_stick"));
            Models.registerParentedItemModel(itemModelGenerator, item, Models.getItemId("stick_base"), ((StickType)enum_).getBaseBlock());
        }
        itemModelGenerator.method_65426(RocksMain.Geyser.method_8389());
        itemModelGenerator.method_65426(RocksMain.NetherGeyser.method_8389());
        this.registerStarfishItemVariations(itemModelGenerator, RocksMain.Starfish);
        itemModelGenerator.method_65426(RocksMain.Seashell.method_8389());
        itemModelGenerator.method_65426(RocksMain.Pinecone.method_8389());
    }

    public static void registerParentedItemModel(class_4915 modelGenerator, class_1792 item, class_2960 parentId, class_2248 textureSource) {
        class_4944 textureMap = class_4944.method_25883((class_4945)ZERO_TEXTURE_KEY, (class_2960)class_4944.method_25860((class_2248)textureSource));
        class_2960 itemModel = Models.getSimpleParentModel(parentId, "").method_48525(item, textureMap, modelGenerator.field_55246);
        modelGenerator.field_55245.method_65460(item, class_10410.method_65481((class_2960)itemModel));
    }

    public final void registerStarfishItemVariations(class_4915 modelGenerator, class_2248 starfish) {
        HashMap<StarfishVariation, class_10439.class_10441> variantMap = new HashMap<StarfishVariation, class_10439.class_10441>();
        for (StarfishVariation variation : StarfishVariation.values()) {
            variantMap.put(variation, class_10410.method_65481((class_2960)class_4941.method_25841((class_1792)starfish.method_8389(), (String)("_" + variation.toString()))));
        }
        modelGenerator.field_55245.method_65460(starfish.method_8389(), class_10410.method_65484(RocksMain.STARFISH_VARIATION, (class_10439.class_10441)class_10410.method_65481((class_2960)class_4941.method_25840((class_1792)starfish.method_8389())), variantMap));
    }

    public static class_807 getRandomRotationWeightedVariant(class_2960 modelId) {
        class_6012.class_6006 list = class_6012.method_66215();
        for (class_10821 rotation : class_10821.values()) {
            class_813 rotatedVariant = new class_813(modelId, class_813.class_10803.field_56935.method_67947(rotation));
            list.method_54453((Object)rotatedVariant);
        }
        return new class_807(list.method_34974());
    }

    private static class RockModel {
        private RockModel() {
        }

        public static void registerBlockModel(class_4910 modelGenerator, class_2248 rockBlock, class_2248 textureSource) {
            class_4944 textureMap = class_4944.method_25883((class_4945)ZERO_TEXTURE_KEY, (class_2960)class_4944.method_25860((class_2248)textureSource));
            class_2960 largeRock = Models.getSimpleParentModel(Models.getBlockId("large_rock"), "_large").method_25846(rockBlock, textureMap, modelGenerator.field_22831);
            class_2960 mediumRock = Models.getSimpleParentModel(Models.getBlockId("medium_rock"), "_medium").method_25846(rockBlock, textureMap, modelGenerator.field_22831);
            class_2960 smallRock = Models.getSimpleParentModel(Models.getBlockId("small_rock"), "_small").method_25846(rockBlock, textureMap, modelGenerator.field_22831);
            class_2960 tinyRock = Models.getSimpleParentModel(Models.getBlockId("tiny_rock"), "_tiny").method_25846(rockBlock, textureMap, modelGenerator.field_22831);
            modelGenerator.field_22830.accept(RockModel.createBlockState(rockBlock, new class_2960[]{largeRock, mediumRock, smallRock, tinyRock}));
        }

        private static class_4917 createBlockState(class_2248 rockBlock, class_2960[] modelIds) {
            return class_4925.method_67852((class_2248)rockBlock).method_67859(class_4926.method_67864(RocksMain.ROCK_VARIATION).method_25795(variation -> Models.getRandomRotationWeightedVariant(modelIds[3 - variation.ordinal()])));
        }
    }

    private static class StickModel {
        private StickModel() {
        }

        public static void registerBlockModel(class_4910 modelGenerator, class_2248 stickBlock, class_2248 textureSource) {
            class_4944 textureMap = class_4944.method_25883((class_4945)ZERO_TEXTURE_KEY, (class_2960)class_4944.method_25860((class_2248)textureSource));
            class_2960 largeRock = Models.getSimpleParentModel(Models.getBlockId("large_stick"), "_large").method_25846(stickBlock, textureMap, modelGenerator.field_22831);
            class_2960 mediumRock = Models.getSimpleParentModel(Models.getBlockId("medium_stick"), "_medium").method_25846(stickBlock, textureMap, modelGenerator.field_22831);
            class_2960 smallRock = Models.getSimpleParentModel(Models.getBlockId("small_stick"), "_small").method_25846(stickBlock, textureMap, modelGenerator.field_22831);
            modelGenerator.field_22830.accept(StickModel.createBlockState(stickBlock, new class_2960[]{largeRock, mediumRock, smallRock}));
        }

        private static class_4917 createBlockState(class_2248 stickBlock, class_2960[] modelIds) {
            return class_4925.method_67852((class_2248)stickBlock).method_67859(class_4926.method_67864(RocksMain.STICK_VARIATION).method_25795(variation -> Models.getRandomRotationWeightedVariant(modelIds[2 - variation.ordinal()])));
        }
    }
}

