/*
 * Decompiled with CFR 0.152.
 */
package me.contaria.fastquit;

import java.util.HashSet;
import java.util.Set;
import me.contaria.fastquit.TextHelper;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.SelectionListEntry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

@Config(name="fastquit")
public class FastQuitConfig
implements ConfigData {
    @ConfigEntry.Gui.Tooltip
    public boolean renderSavingScreen = false;
    @ConfigEntry.Gui.Tooltip
    public boolean showToasts = true;
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public ShowSavingTime showSavingTime = ShowSavingTime.TRUE;
    @ConfigEntry.Category(value="performance")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.BoundedDiscrete(max=10L)
    public int backgroundPriority = 2;
    @ConfigEntry.Category(value="compat")
    @ConfigEntry.Gui.Tooltip
    private boolean allowMultipleServers = true;
    @ConfigEntry.Gui.Excluded
    private static final Set<String> MODS_THAT_CONFLICT_WITH_MULTIPLE_SERVERS = new HashSet<String>();

    public boolean allowMultipleServers() {
        if (!MODS_THAT_CONFLICT_WITH_MULTIPLE_SERVERS.isEmpty()) {
            return false;
        }
        return this.allowMultipleServers;
    }

    public class_437 createConfigScreen(class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)TextHelper.translatable("text.autoconfig.fastquit.title", new Object[0])).setSavingRunnable(() -> AutoConfig.getConfigHolder(FastQuitConfig.class).save());
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory generalCategory = builder.getOrCreateCategory((class_2561)TextHelper.translatable("text.autoconfig.fastquit.category.default", new Object[0]));
        generalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)TextHelper.translatable("text.autoconfig.fastquit.option.renderSavingScreen", new Object[0]), this.renderSavingScreen).setTooltip(new class_2561[]{TextHelper.translatable("text.autoconfig.fastquit.option.renderSavingScreen.@Tooltip", new Object[0])}).setDefaultValue(false).setSaveConsumer(renderSavingScreen -> {
            this.renderSavingScreen = renderSavingScreen;
        }).build());
        generalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)TextHelper.translatable("text.autoconfig.fastquit.option.showToasts", new Object[0]), this.showToasts).setTooltip(new class_2561[]{TextHelper.translatable("text.autoconfig.fastquit.option.showToasts.@Tooltip", new Object[0])}).setDefaultValue(true).setSaveConsumer(showToasts -> {
            this.showToasts = showToasts;
        }).build());
        generalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector((class_2561)TextHelper.translatable("text.autoconfig.fastquit.option.showSavingTime", new Object[0]), ShowSavingTime.class, (Enum)this.showSavingTime).setTooltip(new class_2561[]{TextHelper.translatable("text.autoconfig.fastquit.option.showSavingTime.@Tooltip", new Object[0])}).setDefaultValue((Enum)ShowSavingTime.TRUE).setSaveConsumer(showSavingTime -> {
            this.showSavingTime = showSavingTime;
        }).build());
        ConfigCategory performanceCategory = builder.getOrCreateCategory((class_2561)TextHelper.translatable("text.autoconfig.fastquit.category.performance", new Object[0]));
        performanceCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)TextHelper.translatable("text.autoconfig.fastquit.option.backgroundPriority", new Object[0]), this.backgroundPriority, 0, 10).setTooltip(new class_2561[]{TextHelper.translatable("text.autoconfig.fastquit.option.backgroundPriority.@Tooltip", new Object[0])}).setTextGetter(backgroundPriority -> switch (backgroundPriority) {
            case 0 -> TextHelper.OFF;
            case 1, 2, 5, 10 -> TextHelper.translatable("fastquit.config.performance.backgroundPriority." + backgroundPriority, new Object[0]);
            default -> TextHelper.literal(backgroundPriority.toString());
        }).setDefaultValue(2).setSaveConsumer(backgroundPriority -> {
            this.backgroundPriority = backgroundPriority;
        }).build());
        ConfigCategory modCompatCategory = builder.getOrCreateCategory((class_2561)TextHelper.translatable("text.autoconfig.fastquit.category.compat", new Object[0]));
        if (MODS_THAT_CONFLICT_WITH_MULTIPLE_SERVERS.isEmpty()) {
            modCompatCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)TextHelper.translatable("text.autoconfig.fastquit.option.allowMultipleServers", new Object[0]), this.allowMultipleServers).setTooltip(new class_2561[]{TextHelper.translatable("text.autoconfig.fastquit.option.allowMultipleServers.@Tooltip", new Object[0])}).setDefaultValue(true).setSaveConsumer(allowMultipleServers -> {
                this.allowMultipleServers = allowMultipleServers;
            }).build());
        } else {
            modCompatCategory.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector((class_2561)TextHelper.translatable("text.autoconfig.fastquit.option.allowMultipleServers", new Object[0]), ModCompat.class, (Enum)ModCompat.DISABLED).setTooltip(new class_2561[]{TextHelper.translatable("text.autoconfig.fastquit.option.allowMultipleServers.@Tooltip", new Object[0]).method_27693("\n\n").method_10852((class_2561)TextHelper.translatable("fastquit.config.compat.allowMultipleServers.disabledForCompat", String.join((CharSequence)", ", MODS_THAT_CONFLICT_WITH_MULTIPLE_SERVERS)))}).setEnumNameProvider(disabled -> TextHelper.translatable("addServer.resourcePack.disabled", new Object[0]).method_27694(style -> style.method_10977(class_124.field_1061))).build());
        }
        return builder.build();
    }

    static {
        Set<String> incompatibleModIDs = Set.of("quilt_biome", "fastback");
        for (String modID : incompatibleModIDs) {
            FabricLoader.getInstance().getModContainer(modID).ifPresent(modContainer -> MODS_THAT_CONFLICT_WITH_MULTIPLE_SERVERS.add(modContainer.getMetadata().getName()));
        }
    }

    public static enum ShowSavingTime implements SelectionListEntry.Translatable
    {
        FALSE,
        TOAST_ONLY,
        TRUE;


        @NotNull
        public String getKey() {
            if (this == TOAST_ONLY) {
                return "fastquit.config.general.showSavingTime.toastsOnly";
            }
            return "text.cloth-config.boolean.value." + (this == TRUE);
        }
    }

    private static enum ModCompat {
        DISABLED;

    }
}

