/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.async;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongSupplier;
import me.lucko.spark.common.tick.TickReporter;

class ExceedingTicksFilter
implements TickReporter.Callback {
    private final Queue<ExceededTick> ticksOver = new ConcurrentLinkedQueue<ExceededTick>();
    private final AtomicInteger tickCounter = new AtomicInteger();
    private final int tickLengthThreshold;
    private final LongSupplier nanoTimeSource;

    ExceedingTicksFilter(int tickLengthThreshold, LongSupplier nanoTimeSource) {
        this.tickLengthThreshold = tickLengthThreshold;
        this.nanoTimeSource = nanoTimeSource;
    }

    public ExceedingTicksFilter(int tickLengthThreshold) {
        this(tickLengthThreshold, System::nanoTime);
    }

    @Override
    public void onTick(double duration) {
        if (duration > (double)this.tickLengthThreshold) {
            long end = this.nanoTimeSource.getAsLong();
            long start = (long)((double)end - duration * 1000000.0);
            this.ticksOver.add(new ExceededTick(start, end));
            this.tickCounter.getAndIncrement();
        }
    }

    public int exceedingTicksCount() {
        return this.tickCounter.get();
    }

    public boolean duringExceedingTick(long time) {
        while (true) {
            ExceededTick earliestExceeding;
            if ((earliestExceeding = this.ticksOver.peek()) == null) {
                return false;
            }
            if (time - earliestExceeding.start < 0L) {
                return false;
            }
            if (earliestExceeding.end - time >= 0L) break;
            this.ticksOver.remove();
        }
        return true;
    }

    private static final class ExceededTick {
        private final long start;
        private final long end;

        ExceededTick(long start, long end) {
            this.start = start;
            this.end = end;
        }
    }
}

