/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.emi;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.BackpackSettingsScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.init.ModScreenHandlerTypes;
import com.tiviacz.travelersbackpack.inventory.menu.AbstractBackpackMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.DisabledSlot;
import com.tiviacz.travelersbackpack.inventory.upgrades.crafting.CraftingUpgrade;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.widget.Bounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1735;
import org.jetbrains.annotations.Nullable;

@EmiEntrypoint
public class EmiCompat
implements EmiPlugin {
    public void register(EmiRegistry emiRegistry) {
        emiRegistry.addExclusionArea(BackpackSettingsScreen.class, (screen, consumer) -> screen.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(widget -> {
            int[] size = ((WidgetBase)widget).getWidgetSizeAndPos();
            consumer.accept(new Bounds(size[0], size[1], size[2], size[3]));
        }));
        emiRegistry.addExclusionArea(BackpackScreen.class, (screen, consumer) -> {
            int[] s = screen.settingsWidget.getWidgetSizeAndPos();
            consumer.accept(new Bounds(s[0], s[1], s[2], s[3]));
            screen.method_25396().stream().filter(w -> w instanceof UpgradeWidgetBase).forEach(widget -> {
                int[] size = ((UpgradeWidgetBase)widget).getWidgetSizeAndPos();
                consumer.accept(new Bounds(size[0], size[1], size[2], size[3]));
            });
            screen.upgradeSlots.forEach(slot -> {
                if (!slot.isHidden()) {
                    int[] size = slot.getUpgradeSlotSizeAndPos();
                    consumer.accept(new Bounds(size[0], size[1], size[2], size[3]));
                }
            });
        });
        emiRegistry.addRecipeHandler(ModScreenHandlerTypes.BACKPACK_BLOCK_MENU, new GridMenuInfo());
        emiRegistry.addRecipeHandler(ModScreenHandlerTypes.BACKPACK_MENU, new GridMenuInfo());
    }

    private static class GridMenuInfo<T extends BackpackBaseMenu>
    implements StandardRecipeHandler<T> {
        private GridMenuInfo() {
        }

        @Nullable
        public class_1735 getOutputSlot(T handler) {
            return handler.method_7611(((BackpackBaseMenu)((Object)handler)).CRAFTING_RESULT);
        }

        public List<class_1735> getInputSources(T handler) {
            int i;
            ArrayList<class_1735> list = new ArrayList<class_1735>();
            for (i = 0; i < ((BackpackBaseMenu)((Object)handler)).BACKPACK_INV_END; ++i) {
                list.add(handler.method_7611(i));
            }
            for (i = ((BackpackBaseMenu)((Object)handler)).PLAYER_INV_START; i < ((BackpackBaseMenu)((Object)handler)).PLAYER_HOT_END; ++i) {
                if (((AbstractBackpackMenu)((Object)handler)).getWrapper().getScreenID() == 1 && handler.method_7611(i) instanceof DisabledSlot) continue;
                list.add(handler.method_7611(i));
            }
            return list;
        }

        public List<class_1735> getCraftingSlots(T handler) {
            ArrayList<class_1735> list = new ArrayList<class_1735>();
            CraftingUpgrade upgrade = ((AbstractBackpackMenu)((Object)handler)).getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class).get();
            if (upgrade.isTabOpened()) {
                int firstCraftSlot = ((BackpackBaseMenu)((Object)handler)).CRAFTING_GRID_START;
                for (int i = 0; i < 9; ++i) {
                    list.add(handler.method_7611(firstCraftSlot + i));
                }
            }
            return list;
        }

        public boolean craft(EmiRecipe recipe, EmiCraftContext<T> context) {
            CraftingUpgrade upgrade = ((BackpackBaseMenu)context.getScreenHandler()).getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class).get();
            if (!upgrade.isTabOpened()) {
                ServerboundActionTagPacket.create(0, upgrade.getDataHolderSlot(), true, 0);
                return false;
            }
            return super.craft(recipe, context);
        }

        public boolean canCraft(EmiRecipe recipe, EmiCraftContext<T> context) {
            return super.canCraft(recipe, context) && ((BackpackBaseMenu)context.getScreenHandler()).getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class).isPresent();
        }

        public boolean supportsRecipe(EmiRecipe recipe) {
            return VanillaEmiRecipeCategories.CRAFTING == recipe.getCategory() && recipe.supportsRecipeTree();
        }
    }
}

