/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common;

import com.aizistral.nochatreports.common.NCRCore;
import com.aizistral.nochatreports.common.config.NCRConfig;
import com.aizistral.nochatreports.common.core.ServerDataExtension;
import com.aizistral.nochatreports.common.core.ServerSafetyLevel;
import com.aizistral.nochatreports.common.core.ServerSafetyState;
import com.aizistral.nochatreports.common.core.SigningMode;
import com.aizistral.nochatreports.common.platform.events.ClientEvents;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_642;

@Environment(value=EnvType.CLIENT)
public class NCRClient {
    private static boolean signingKeysPresent = false;

    private NCRClient() {
        throw new IllegalStateException("Can't touch this");
    }

    static void setup() {
        NCRCore.LOGGER.debug("Client initialization...");
        ClientEvents.DISCONNECT.register(NCRClient::onDisconnect);
        ClientEvents.PLAY_READY.register(NCRClient::onPlayReady);
    }

    private static void onDisconnect(class_310 client) {
        if (!NCRConfig.getClient().enableMod()) {
            return;
        }
        if (NCRConfig.getCommon().enableDebugLog()) {
            NCRCore.LOGGER.info("Disconnected from server, resetting safety state!");
        }
        ServerSafetyState.reset();
    }

    private static void onPlayReady(class_634 handler, class_310 client) {
        if (!NCRConfig.getClient().enableMod()) {
            return;
        }
        client.execute(() -> {
            if (!client.method_1542()) {
                if (!ServerSafetyState.isOnRealms()) {
                    if (!handler.method_48296().method_10771()) {
                        ServerSafetyState.updateCurrent(ServerSafetyLevel.SECURE);
                    } else {
                        ServerDataExtension ext;
                        class_642 patt0$temp = client.method_1558();
                        if (patt0$temp instanceof ServerDataExtension && (ext = (ServerDataExtension)patt0$temp).preventsChatReports()) {
                            ServerSafetyState.updateCurrent(ServerSafetyLevel.SECURE);
                        } else if (NCRConfig.getServerPreferences().hasMode(ServerSafetyState.getLastServer(), SigningMode.ALWAYS)) {
                            ServerSafetyState.updateCurrent(ServerSafetyLevel.INSECURE);
                            ServerSafetyState.setAllowChatSigning(true);
                        } else {
                            ServerSafetyState.updateCurrent(ServerSafetyLevel.UNKNOWN);
                        }
                    }
                }
            } else {
                ServerSafetyState.updateCurrent(ServerSafetyLevel.SINGLEPLAYER);
            }
            if (NCRConfig.getCommon().enableDebugLog()) {
                NCRCore.LOGGER.info("Successfully connected to server, safety state: {}", (Object)ServerSafetyState.getCurrent());
            }
            if (NCRConfig.getClient().demandOnServer() && !ServerSafetyState.getCurrent().isSecure()) {
                handler.method_48296().method_10747((class_2561)class_2561.method_43471((String)"disconnect.nochatreports.client"));
            }
        });
    }

    public static boolean areSigningKeysPresent() {
        return signingKeysPresent;
    }

    public static void setSigningKeysPresent(boolean present) {
        signingKeysPresent = present;
    }

    public static void resendLastChatMessage() {
        class_408 chat;
        class_408 chatScr;
        class_310 mc = class_310.method_1551();
        class_437 class_4372 = mc.field_1755;
        class_408 class_4082 = chatScr = class_4372 instanceof class_408 ? (chat = (class_408)class_4372) : null;
        if (chatScr == null) {
            chatScr = new class_408("");
            chatScr.method_25423(mc, mc.method_22683().method_4486(), mc.method_22683().method_4502());
        }
        chatScr.method_44056(ServerSafetyState.getLastMessage(), false);
    }
}

