/*
 * Decompiled with CFR 0.152.
 */
package xyz.nikitacartes.glowingtorchflower.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;

public abstract class ConfigTemplate {
    private final transient Pattern pattern = Pattern.compile("^[^$\"{}\\[\\]:=,+#`^?!@*&\\\\\\s/]+");
    final transient String configFilePath;
    final transient String configResourcePath = "xyz/nikitacartes/glowingtorchflower/config/";
    public static Path gameDirectory = FabricLoader.getInstance().getGameDir();
    private static String modName = "GlowingTorchflower";

    ConfigTemplate(String configFilePath) {
        this.configFilePath = configFilePath;
    }

    public static <Config extends ConfigTemplate> Config loadConfig(Class<Config> configClass, String configPath) {
        Path path = gameDirectory.resolve("config/" + modName).resolve(configPath);
        if (Files.exists(path, new LinkOption[0])) {
            HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(path)).build();
            try {
                return (Config)((ConfigTemplate)((CommentedConfigurationNode)loader.load()).get(configClass));
            }
            catch (ConfigurateException e) {
                System.err.println("[" + modName + "] Failed to load config file" + String.valueOf((Object)e));
                return null;
            }
        }
        return null;
    }

    public void save() {
        Path configDirectory = gameDirectory.resolve("config/" + modName);
        if (!Files.exists(configDirectory, new LinkOption[0])) {
            try {
                Files.createDirectories(configDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                System.err.println("Failed to create config directory" + String.valueOf(e));
            }
        }
        Path path = gameDirectory.resolve("config/" + modName + "/" + this.configFilePath);
        try {
            Files.writeString(path, (CharSequence)this.handleTemplate(), new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to save config file" + String.valueOf(e));
        }
    }

    private String escapeString(String string) {
        return string.replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t").replace("\b", "\\b").replace("\f", "\\f").replace("\"", "\\\"").replace("'", "\\'");
    }

    protected <T> String wrapIfNecessary(T string) {
        String escapeString = this.escapeString(String.valueOf(string));
        if (!this.pattern.matcher(escapeString).matches()) {
            return "\"" + escapeString + "\"";
        }
        return escapeString;
    }

    protected String wrapIfNecessary(double string) {
        return String.format(Locale.US, "%.4f", string);
    }

    protected String wrapIfNecessary(long string) {
        return String.valueOf(string);
    }

    protected <T extends List<String>> String wrapIfNecessary(T strings) {
        return "[" + strings.stream().map(this::wrapIfNecessary).collect(Collectors.joining(",\n  ")) + "]";
    }

    protected abstract String handleTemplate() throws IOException;
}

