/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.network.handler.validate;

import dev.terminalmc.clientsort.exception.PayloadHandlerException;
import dev.terminalmc.clientsort.util.inject.ISlot;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3222;

public class SchemaValidator {
    private SchemaValidator() {
    }

    public static void validateSlotId(class_1703 menu, int slotId) throws PayloadHandlerException {
        if (slotId < 0 || slotId >= menu.field_7761.size()) {
            throw new PayloadHandlerException(String.format("Payload contains invalid slot ID %d out of range for menu with size %d!", slotId, menu.field_7761.size()));
        }
        int realId = ((ISlot)menu.field_7761.get(slotId)).clientsort$getIdInContainer();
        if (slotId != realId) {
            throw new PayloadHandlerException(String.format("Payload contains invalid slot ID %d which does not match the known ID of that slot (%d)!", slotId, realId));
        }
    }

    public static void validateContainerSlot(class_1703 menu, int slotId, class_1263 container) throws PayloadHandlerException {
        SchemaValidator.validateSlotId(menu, slotId);
        class_1735 slot = (class_1735)menu.field_7761.get(slotId);
        if (container != slot.field_7871) {
            throw new PayloadHandlerException(String.format("Payload contains slots from different containers, first: '%s', now: '%s'!", container, slot.field_7871));
        }
    }

    public static void validateSlotArray(class_3222 player, class_1703 menu, int[] slotIds) throws PayloadHandlerException {
        int minSlots = 1;
        if (slotIds.length < minSlots) {
            throw new PayloadHandlerException(String.format("Slot array contains too few slots! Expected at least %d, got %d!", minSlots, slotIds.length));
        }
        SchemaValidator.validateSlotId(menu, slotIds[0]);
        class_1263 container = ((class_1735)menu.field_7761.get((int)slotIds[0])).field_7871;
        IntAVLTreeSet checkedSlots = new IntAVLTreeSet();
        class_1799 testItem = class_1802.field_30904.method_7854();
        for (int slotId : slotIds) {
            SchemaValidator.validateContainerSlot(menu, slotId, container);
            if (!checkedSlots.add(slotId)) {
                throw new PayloadHandlerException(String.format("Slot array contains duplicate slot %d!", slotId));
            }
            class_1735 slot = (class_1735)menu.field_7761.get(slotId);
            boolean accessible = true;
            if (slot.method_7681()) {
                if (!slot.method_7674((class_1657)player)) {
                    accessible = false;
                }
            } else if (!slot.field_7871.method_5437(slotId, testItem) || !slot.method_7680(testItem)) {
                accessible = false;
            }
            if (accessible) continue;
            throw new PayloadHandlerException(String.format("Slot array contains inaccessible slot %d with item '%s'!", slotId, slot.method_7677()));
        }
    }

    public static void validateSlotMapping(class_3222 player, class_1703 menu, int[] slotMapping) throws PayloadHandlerException {
        int i;
        int minSlots = 2;
        if (slotMapping.length < minSlots) {
            throw new PayloadHandlerException(String.format("Slot mapping contains too few slots! Expected at least %d, got %d!", minSlots, slotMapping.length));
        }
        if (slotMapping.length % 2 != 0) {
            throw new PayloadHandlerException(String.format("Slot mapping contains an uneven number of slots (%d)!", slotMapping.length));
        }
        SchemaValidator.validateSlotId(menu, slotMapping[0]);
        class_1263 container = ((class_1735)menu.field_7761.get((int)slotMapping[0])).field_7871;
        IntAVLTreeSet checkedSlots = new IntAVLTreeSet();
        for (i = 0; i < slotMapping.length; i += 2) {
            class_1735 srcSlot;
            int srcId = slotMapping[i];
            int dstId = slotMapping[i + 1];
            SchemaValidator.validateContainerSlot(menu, srcId, container);
            if (!checkedSlots.add(srcId)) {
                throw new PayloadHandlerException(String.format("Slot mapping contains duplicate source slot %d!", srcId));
            }
            SchemaValidator.validateContainerSlot(menu, dstId, container);
            if (srcId == dstId || !(srcSlot = (class_1735)menu.field_7761.get(srcId)).method_7681() || srcSlot.method_7674((class_1657)player)) continue;
            throw new PayloadHandlerException(String.format("Slot mapping contains inaccessible slot %d with item '%s'!", srcId, srcSlot.method_7677()));
        }
        for (i = 1; i < slotMapping.length; i += 2) {
            int dstId = slotMapping[i];
            if (checkedSlots.remove(dstId)) continue;
            throw new PayloadHandlerException(String.format("Slot mapping contains duplicate destination slot or destination slot that does not appear as source slot (%d)!", dstId));
        }
        if (!checkedSlots.isEmpty()) {
            throw new PayloadHandlerException(String.format("Slot mapping contains %d source slots that do not appear as destination slots.", checkedSlots.size()));
        }
    }
}

