/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.network.handler;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.exception.PayloadHandlerException;
import dev.terminalmc.clientsort.platform.Services;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public abstract class PayloadHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processPayload(MinecraftServer server, class_3222 player, int containerId, ThrowingConsumer<class_1703> contextValidator, ThrowingConsumer<class_1703> schemaValidator, ThrowingConsumer<class_1703> operator, class_8710.class_9154<?> responseType, Function<String, class_8710> responseGenerator) {
        class_1703 menu = null;
        String error = null;
        try {
            menu = PayloadHandler.getMenu(player, containerId);
            menu.method_34256();
            contextValidator.accept(menu);
            schemaValidator.accept(menu);
            operator.accept(menu);
        }
        catch (Exception e) {
            if (e instanceof PayloadHandlerException) {
                PayloadHandlerException se = (PayloadHandlerException)e;
                error = se.getMessage();
            } else {
                error = PayloadHandlerException.GENERIC_MESSAGE;
                ClientSort.LOG.error("Encountered an exception while handling '{}' payload from player '{}'", responseType.comp_2242(), player, e);
            }
        }
        finally {
            if (menu != null) {
                menu.method_34257();
                menu.method_7623();
            }
            if (Services.PLATFORM.canSendToPlayer(player, responseType)) {
                Services.PLATFORM.sendToPlayer(player, responseGenerator.apply(error));
            }
        }
    }

    @NotNull
    private static class_1703 getMenu(class_3222 player, int containerId) throws PayloadHandlerException {
        class_1723 menu;
        if (containerId == player.field_7498.field_7763) {
            menu = player.field_7498;
        } else if (containerId == player.field_7512.field_7763) {
            menu = player.field_7512;
        } else {
            throw new PayloadHandlerException(String.format("Container ID '%d' does not match player inventory or container!", containerId));
        }
        if (!menu.method_7597((class_1657)player)) {
            throw new PayloadHandlerException(String.format("Container ID '%d' is not valid for the player!", containerId));
        }
        return menu;
    }

    public static boolean notEqual(class_1799 a, class_1799 b) {
        return !class_1799.method_31577((class_1799)a, (class_1799)b) || a.method_7947() != b.method_7947();
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T> {
        public void accept(T var1) throws Exception;
    }
}

