/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.inventory.control.server;

import dev.terminalmc.clientsort.client.inventory.control.SingleUseController;
import dev.terminalmc.clientsort.client.inventory.screen.ContainerScreenHelper;
import dev.terminalmc.clientsort.client.network.InteractionManager;
import dev.terminalmc.clientsort.client.network.handler.CollectResultHandler;
import dev.terminalmc.clientsort.client.order.SortContext;
import dev.terminalmc.clientsort.client.order.SortOrder;
import dev.terminalmc.clientsort.client.platform.ClientServices;
import dev.terminalmc.clientsort.network.payload.CollectPayload;
import dev.terminalmc.clientsort.network.payload.SortPayload;
import dev.terminalmc.clientsort.network.payload.StackFillPayload;
import dev.terminalmc.clientsort.network.payload.TransferPayload;
import dev.terminalmc.clientsort.util.inject.ISlot;
import net.minecraft.class_1735;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_465;

public class ServerController
extends SingleUseController {
    public ServerController(class_465<?> screen, ContainerScreenHelper<? extends class_465<?>> screenHelper, class_1735 originSlot) {
        super(screen, screenHelper, originSlot);
    }

    @Override
    protected void sort(SortOrder sortOrder) {
        if (!this.canOperate()) {
            return;
        }
        CollectResultHandler.onSuccess = () -> {
            ServerController sorter = new ServerController(this.screen, this.screenHelper, this.originSlot);
            int[] slotMapping = sorter.createSlotMapping(sortOrder);
            InteractionManager.now(() -> {
                ClientServices.PLATFORM.sendToServer(new SortPayload(this.screen.method_17577().field_7763, slotMapping));
                return InteractionManager.TICK_WAITER;
            });
        };
        int[] scopeArray = this.createSlotIdArray(this.originScopeSlots);
        this.sendCollectPayload(scopeArray);
    }

    @Override
    protected void fillStacks() {
        if (!this.canOperate()) {
            return;
        }
        if (this.originScopeSlots.length == 0) {
            return;
        }
        if (this.otherScopeSlots.length == 0) {
            return;
        }
        int[] srcSlotIds = this.createSlotIdArray(this.originScopeSlots);
        int[] dstSlotIds = this.createSlotIdArray(this.otherScopeSlots);
        InteractionManager.now(() -> {
            ClientServices.PLATFORM.sendToServer(new StackFillPayload(this.screen.method_17577().field_7763, srcSlotIds, dstSlotIds));
            return InteractionManager.TICK_WAITER;
        });
    }

    @Override
    protected void transfer() {
        if (!this.canOperate()) {
            return;
        }
        if (this.originScopeSlots.length == 0) {
            return;
        }
        if (this.otherScopeSlots.length == 0) {
            return;
        }
        int[] srcSlotIds = this.createSlotIdArray(this.originScopeSlots);
        int[] dstSlotIds = this.createSlotIdArray(this.otherScopeSlots);
        InteractionManager.now(() -> {
            ClientServices.PLATFORM.sendToServer(new TransferPayload(this.screen.method_17577().field_7763, srcSlotIds, dstSlotIds));
            return InteractionManager.TICK_WAITER;
        });
    }

    private int[] createSlotIdArray(class_1735[] slots) {
        int[] slotIds = new int[slots.length];
        for (int i = 0; i < slots.length; ++i) {
            slotIds[i] = ((ISlot)slots[i]).clientsort$getIdInContainer();
        }
        this.screenHelper.translateSlotIds(slotIds);
        return slotIds;
    }

    private void sendCollectPayload(int[] scopeArray) {
        InteractionManager.now(() -> {
            ClientServices.PLATFORM.sendToServer(new CollectPayload(this.screen.method_17577().field_7763, scopeArray));
            return InteractionManager.TICK_WAITER;
        });
    }

    private int[] createSlotMapping(SortOrder sortOrder) {
        int[] sortedIds = new int[this.originScopeStacks.length];
        for (int i = 0; i < sortedIds.length; ++i) {
            sortedIds[i] = i;
        }
        sortedIds = sortOrder.sort(sortedIds, this.originScopeStacks, new SortContext((class_1937)class_310.method_1551().field_1687));
        int[] slotMapping = new int[sortedIds.length * 2];
        for (int i = 0; i < sortedIds.length; ++i) {
            class_1735 from = this.originScopeSlots[sortedIds[i]];
            class_1735 to = this.originScopeSlots[i];
            slotMapping[i * 2] = ((ISlot)from).clientsort$getIdInContainer();
            slotMapping[i * 2 + 1] = ((ISlot)to).clientsort$getIdInContainer();
        }
        this.screenHelper.translateSlotIds(slotMapping);
        return slotMapping;
    }
}

