/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.inventory.control;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.compat.itemlocks.ItemLocksWrapper;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.gui.ControlButtonManager;
import dev.terminalmc.clientsort.client.inventory.control.client.ClientCreativeController;
import dev.terminalmc.clientsort.client.inventory.control.client.ClientSurvivalController;
import dev.terminalmc.clientsort.client.inventory.control.server.ServerController;
import dev.terminalmc.clientsort.client.inventory.screen.ContainerScreenHelper;
import dev.terminalmc.clientsort.client.inventory.util.Scope;
import dev.terminalmc.clientsort.client.order.SortOrder;
import dev.terminalmc.clientsort.client.platform.ClientServices;
import dev.terminalmc.clientsort.config.ClassPolicy;
import dev.terminalmc.clientsort.network.payload.CollectPayload;
import dev.terminalmc.clientsort.network.payload.SortPayload;
import dev.terminalmc.clientsort.network.payload.StackFillPayload;
import dev.terminalmc.clientsort.network.payload.TransferPayload;
import dev.terminalmc.clientsort.util.SlotLogUtil;
import dev.terminalmc.clientsort.util.inject.ISlot;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public abstract class SingleUseController {
    protected boolean hasOperated = false;
    protected final class_465<?> screen;
    protected final ContainerScreenHelper<? extends class_465<?>> screenHelper;
    protected final class_1735 originSlot;
    protected final class_1735[] originScopeSlots;
    protected final class_1799[] originScopeStacks;
    protected final class_1735[] otherScopeSlots;
    protected final class_1799[] otherScopeStacks;

    public SingleUseController(class_465<?> screen, ContainerScreenHelper<? extends class_465<?>> screenHelper, class_1735 originSlot) {
        this.screen = screen;
        this.screenHelper = screenHelper;
        this.originSlot = originSlot;
        Scope originScope = screenHelper.getScope(originSlot);
        this.originScopeSlots = this.collectSlots(originScope);
        if (ClientSort.debug) {
            ClientSort.LOG.warn("Origin Scope Slot IDs ({})", this.originScopeSlots.length);
            SlotLogUtil.logSlotIds(List.of(this.originScopeSlots));
        }
        this.originScopeStacks = new class_1799[this.originScopeSlots.length];
        for (int i = 0; i < this.originScopeSlots.length; ++i) {
            this.originScopeStacks[i] = this.originScopeSlots[i].method_7677();
        }
        Scope otherScope = switch (originScope) {
            case Scope.PLAYER_INV -> Scope.CONTAINER_INV;
            case Scope.CONTAINER_INV -> Scope.PLAYER_INV;
            default -> Scope.INVALID;
        };
        this.otherScopeSlots = this.collectSlots(otherScope);
        if (ClientSort.debug) {
            ClientSort.LOG.warn("Other Scope Slot IDs ({})", this.otherScopeSlots.length);
            SlotLogUtil.logSlotIds(List.of(this.otherScopeSlots));
        }
        this.otherScopeStacks = new class_1799[this.otherScopeSlots.length];
        for (int i = 0; i < this.otherScopeSlots.length; ++i) {
            this.otherScopeStacks[i] = this.otherScopeSlots[i].method_7677();
        }
    }

    private class_1735[] collectSlots(Scope scope) {
        class_746 player = class_310.method_1551().field_1724;
        if (scope == Scope.INVALID) {
            return new class_1735[0];
        }
        class_1799 testItem = class_1802.field_30904.method_7854();
        ArrayList<class_1735> collectedSlots = new ArrayList<class_1735>();
        for (class_1735 slot : this.screen.method_17577().field_7761) {
            int slotId = ((ISlot)slot).clientsort$getIdInContainer();
            if (this.screenHelper.getScope(slot) != scope || (!slot.method_7681() ? !slot.field_7871.method_5437(slotId, testItem) || !slot.method_7680(testItem) : player != null && !slot.method_7674((class_1657)player))) continue;
            if (ItemLocksWrapper.isLocked(slot)) continue;
            collectedSlots.add(slot);
        }
        return collectedSlots.toArray(new class_1735[0]);
    }

    protected boolean canOperate() {
        if (this.hasOperated) {
            ClientSort.LOG.warn("{} can only be used once!", this.getClass().getSimpleName());
            return false;
        }
        this.hasOperated = true;
        return true;
    }

    @Nullable
    public static SingleUseController getController(class_465<?> screen, ContainerScreenHelper<? extends class_465<?>> screenHelper, class_1735 originSlot, class_8710.class_9154<?> payloadType) {
        class_1703 object;
        ClassPolicy policy;
        if (Config.options().applyPolicies && (policy = ControlButtonManager.getPolicy((object = originSlot.field_7871 instanceof class_1277 ? screen.method_17577() : originSlot.field_7871).getClass())) != null && SingleUseController.policyDisablesType(policy, payloadType)) {
            return null;
        }
        if (Config.options().useServerAcceleration && ClientServices.PLATFORM.canSendToServer(payloadType)) {
            return new ServerController(screen, screenHelper, originSlot);
        }
        if (class_310.method_1551().field_1724.method_68878() && screen instanceof class_481) {
            return new ClientCreativeController(screen, screenHelper, originSlot);
        }
        return new ClientSurvivalController(screen, screenHelper, originSlot);
    }

    public static boolean policyDisablesType(ClassPolicy policy, class_8710.class_9154<?> payloadType) {
        if (payloadType.equals(SortPayload.TYPE) || payloadType.equals(CollectPayload.TYPE)) {
            return !policy.sortEnabled;
        }
        if (payloadType.equals(StackFillPayload.TYPE)) {
            return !policy.stackFillEnabled;
        }
        if (payloadType.equals(TransferPayload.TYPE)) {
            return !policy.transferEnabled;
        }
        throw new IllegalArgumentException("Invalid payload type '%s'".formatted(payloadType));
    }

    public void trySort(SortOrder sortOrder) {
        if (!this.policyAllowsOp(this.originScopeSlots, p -> p.sortEnabled)) {
            return;
        }
        this.sort(sortOrder);
    }

    public void tryFillStacks() {
        if (!this.policyAllowsOp(this.originScopeSlots, p -> p.stackFillEnabled)) {
            return;
        }
        if (!this.policyAllowsOp(this.otherScopeSlots, p -> p.stackFillEnabled)) {
            return;
        }
        this.fillStacks();
    }

    public void tryTransfer() {
        if (!this.policyAllowsOp(this.originScopeSlots, p -> p.transferEnabled)) {
            return;
        }
        if (!this.policyAllowsOp(this.otherScopeSlots, p -> p.transferEnabled)) {
            return;
        }
        this.transfer();
    }

    private boolean policyAllowsOp(class_1735[] slots, Function<ClassPolicy, Boolean> check) {
        if (slots.length == 0) {
            return false;
        }
        if (Config.options().applyPolicies) {
            class_1703 object = slots[0].field_7871 instanceof class_1277 ? this.screen.method_17577() : slots[0].field_7871;
            ClassPolicy policy = ControlButtonManager.getPolicy(object.getClass());
            return policy == null || check.apply(policy) != false;
        }
        return false;
    }

    protected abstract void sort(SortOrder var1);

    protected abstract void fillStacks();

    protected abstract void transfer();
}

