/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.gui.screen.edit;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.config.ButtonLayout;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.config.Vec2i;
import dev.terminalmc.clientsort.client.gui.screen.edit.GroupSelectorScreen;
import dev.terminalmc.clientsort.client.gui.widget.ControlButton;
import dev.terminalmc.clientsort.util.Localization;
import java.util.LinkedList;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1277;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public abstract class PositionEditScreen
extends class_437 {
    private final class_437 lastScreen;
    private final class_465<?> underlay;
    private final LinkedList<ControlButton> buttons = new LinkedList();
    private ControlButton rep;
    private String lowestLayoutKey;
    private boolean dragging;

    public PositionEditScreen(class_465<?> underlay, ControlButton button) {
        this(underlay, button, (class_437)underlay);
    }

    public PositionEditScreen(class_465<?> underlay, ControlButton button, class_437 lastScreen) {
        super((class_2561)Localization.localized("title", "positionEditor", new Object[0]));
        this.field_22793 = class_310.method_1551().field_1772;
        this.lastScreen = lastScreen;
        this.underlay = underlay;
        this.rep = button;
        this.buttons.add(button);
    }

    public void method_25426() {
        super.method_25426();
        this.underlay.method_25423(class_310.method_1551(), this.field_22789, this.field_22790);
        if (!this.reloadButtons()) {
            this.method_37067();
            return;
        }
        this.rebuildGui();
    }

    private boolean reloadButtons() {
        this.buttons.clear();
        this.buttons.addAll(this.getButtons());
        if (this.buttons.size() != 3) {
            if (ClientSort.debug) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.error("Failed to reload buttons on PositionEditScreen: Button list is too small (expected: {}, actual: {})", 3, this.buttons.size());
            }
            return false;
        }
        this.rep = this.buttons.getFirst();
        ButtonLayout layout = Config.options().buttonLayouts.get(this.rep.layoutKey);
        if (layout != null) {
            this.buttons.forEach(button -> {
                button.field_22763 = button.getLayoutStatus(layout);
            });
        }
        class_1703 keyObject = this.rep.container instanceof class_1277 ? this.underlay.method_17577() : this.rep.container;
        this.lowestLayoutKey = keyObject.getClass().getName();
        return true;
    }

    protected abstract LinkedList<ControlButton> getButtons();

    private void rebuildGui() {
        this.method_37067();
        Objects.requireNonNull(this.field_22793);
        class_7842 titleWidget = new class_7842(0, 2, this.field_22789, 9, this.field_22785, this.field_22793);
        this.method_37063((class_364)titleWidget);
        int numButtons = 9;
        int x = 2;
        int movingY = this.field_22790 - 21 * numButtons;
        int width = 100;
        int height = 20;
        class_4185 instructionsButton = class_4185.method_46430((class_2561)Localization.localized("button", "instructions", new Object[0]), button -> {}).method_46436(class_7919.method_47407((class_2561)Localization.localized("button", "instructions.tooltip.1", new Object[0]).method_27693("\n\n").method_10852((class_2561)Localization.localized("button", "instructions.tooltip.2", new Object[0])).method_27693("\n\n").method_10852((class_2561)Localization.localized("button", "instructions.tooltip.3", new Object[0])).method_27693("\n\n").method_10852((class_2561)Localization.localized("button", "instructions.tooltip.4", new Object[0])))).method_46433(x, movingY).method_46437(width, height).method_46431();
        instructionsButton.field_22763 = false;
        this.method_37063((class_364)instructionsButton);
        class_4185 toggleAllButton = class_4185.method_46430((class_2561)Localization.localized("button", "toggleAll", new Object[0]), button -> {
            boolean status = this.buttons.stream().noneMatch(b -> b.field_22763);
            this.buttons.forEach(b -> {
                b.field_22763 = status;
            });
        }).method_46436(class_7919.method_47407((class_2561)Localization.localized("button", "toggleAll.tooltip", new Object[0]))).method_46433(x, movingY += 21).method_46437(width, height).method_46431();
        this.method_37063((class_364)toggleAllButton);
        class_4185 moveToDefaultButton = class_4185.method_46430((class_2561)Localization.localized("button", "moveToDefault", new Object[0]), button -> {
            Vec2i before = this.buttons.getFirst().offset;
            this.buttons.getFirst().offset = Config.options().layoutOffset;
            this.repositionButtons(this.buttons.getFirst(), before);
        }).method_46436(class_7919.method_47407((class_2561)Localization.localized("button", "moveToDefault.tooltip", new Object[0]))).method_46433(x, movingY += 21).method_46437(width, height).method_46431();
        this.method_37063((class_364)moveToDefaultButton);
        class_4185 splitConfigButton = class_4185.method_46430((class_2561)Localization.localized("button", "splitConfig", new Object[0]), button -> class_310.method_1551().method_1507((class_437)new class_410(confirm -> {
            if (confirm) {
                Config.options().buttonLayouts.put(this.lowestLayoutKey, new ButtonLayout(this.lowestLayoutKey, this.buttons.getFirst().offset, this.buttons.getFirst().field_22763, this.buttons.get((int)1).field_22763, this.buttons.get((int)2).field_22763));
                Config.save();
                this.method_25426();
            }
            class_310.method_1551().method_1507((class_437)this);
        }, (class_2561)Localization.localized("title", "confirm.splitConfig", new Object[0]), (class_2561)Localization.localized("message", "confirm.splitConfig", class_2561.method_43470((String)(this.rep.layoutKey == null ? this.lowestLayoutKey : this.rep.layoutKey)).method_27692(class_124.field_1065), class_2561.method_43470((String)this.lowestLayoutKey).method_27692(class_124.field_1065))))).method_46436(class_7919.method_47407((class_2561)Localization.localized("button", "splitConfig.tooltip", new Object[0]))).method_46433(x, movingY += 21).method_46437(width, height).method_46431();
        splitConfigButton.field_22763 = this.rep.layoutKey != null && !this.rep.layoutKey.equals(this.lowestLayoutKey);
        this.method_37063((class_364)splitConfigButton);
        class_4185 saveAsDefaultButton = class_4185.method_46430((class_2561)Localization.localized("button", "saveAsDefault", new Object[0]), button -> class_310.method_1551().method_1507((class_437)new class_410(confirm -> {
            if (confirm) {
                Config.options().layoutOffset = this.buttons.getFirst().offset;
                Config.save();
                this.method_25426();
            }
            class_310.method_1551().method_1507((class_437)this);
        }, (class_2561)Localization.localized("title", "confirm.saveAsDefault", new Object[0]), (class_2561)Localization.localized("message", "confirm.saveAsDefault", new Object[0])))).method_46436(class_7919.method_47407((class_2561)Localization.localized("button", "saveAsDefault.tooltip", new Object[0]))).method_46433(x, movingY += 21).method_46437(width, height).method_46431();
        this.method_37063((class_364)saveAsDefaultButton);
        class_4185 undoChangesButton = class_4185.method_46430((class_2561)Localization.localized("button", "undoChanges", new Object[0]), button -> this.method_25426()).method_46436(class_7919.method_47407((class_2561)Localization.localized("button", "undoChanges.tooltip", new Object[0]))).method_46433(x, movingY += 21).method_46437(width, height).method_46431();
        this.method_37063((class_364)undoChangesButton);
        class_4185 reselectButton = class_4185.method_46430((class_2561)Localization.localized("button", "reselect", new Object[0]), button -> {
            this.method_25419();
            class_310.method_1551().method_1507((class_437)new GroupSelectorScreen(this.underlay, this));
        }).method_46436(class_7919.method_47407((class_2561)Localization.localized("button", "reselect.tooltip", new Object[0]))).method_46433(x, movingY += 21).method_46437(width, height).method_46431();
        this.method_37063((class_364)reselectButton);
        class_4185 cancelButton = class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.method_25419()).method_46433(x, movingY += 21).method_46437(width, height).method_46431();
        this.method_37063((class_364)cancelButton);
        class_4185 doneButton = class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.saveAndClose()).method_46433(x, movingY += 21).method_46437(width, height).method_46431();
        this.method_37063((class_364)doneButton);
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.underlay.method_25394(graphics, mouseX, mouseY, partialTick);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        if (this.buttons.isEmpty()) {
            return;
        }
        this.drawLineFor(graphics, this.buttons.getFirst());
        Vec2i offset = this.buttons.getFirst().offset;
        String string = Localization.localized("info", "offset", offset.x(), offset.y()).getString();
        Objects.requireNonNull(this.field_22793);
        graphics.method_25303(this.field_22793, string, 105, this.field_22790 - (9 + 1) * 3, -1);
        class_5250 class_52502 = Localization.localized("info", "layoutKey.current", this.rep.layoutKey == null ? Localization.localized("info", "layoutKey.unset", new Object[0]) : this.rep.layoutKey);
        Objects.requireNonNull(this.field_22793);
        graphics.method_27535(this.field_22793, (class_2561)class_52502, 105, this.field_22790 - (9 + 1) * 2, -1);
        class_5250 class_52503 = Localization.localized("info", "layoutKey.menu", this.lowestLayoutKey);
        Objects.requireNonNull(this.field_22793);
        graphics.method_27535(this.field_22793, (class_2561)class_52503, 105, this.field_22790 - (9 + 1), -1);
        for (ControlButton cb : this.buttons) {
            cb.method_48579(graphics, mouseX, mouseY, partialTick);
        }
    }

    protected void method_57734(@NotNull class_332 graphics) {
        int original = (Integer)class_310.method_1551().field_1690.method_57702().method_41753();
        class_310.method_1551().field_1690.method_57702().method_41748((Object)1);
        super.method_57734(graphics);
        class_310.method_1551().field_1690.method_57702().method_41748((Object)original);
    }

    private void drawLineFor(class_332 graphics, ControlButton button) {
        graphics.method_51738(button.method_46426() - button.offset.x(), button.method_46426(), button.method_46427(), -4473925);
        graphics.method_51742(button.method_46426() - button.offset.x(), button.method_46427() - button.offset.y(), button.method_46427(), -4473925);
    }

    public void method_25419() {
        super.method_25419();
        this.lastScreen.method_25423(class_310.method_1551(), this.field_22789, this.field_22790);
        class_310.method_1551().method_1507(this.lastScreen);
    }

    public void saveAndClose() {
        String layoutKey = this.rep.layoutKey == null ? this.lowestLayoutKey : this.rep.layoutKey;
        boolean anyActive = false;
        for (ControlButton button : this.buttons) {
            button.savePolicyState();
            if (!button.field_22763) continue;
            anyActive = true;
        }
        if (anyActive || Config.options().buttonLayouts.containsKey(layoutKey)) {
            Config.options().buttonLayouts.put(layoutKey, new ButtonLayout(layoutKey, this.buttons.getFirst().offset, this.buttons.getFirst().field_22763, this.buttons.get((int)1).field_22763, this.buttons.get((int)2).field_22763));
        }
        Config.save();
        this.method_25419();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        Vec2i movement;
        int distance = class_437.method_25442() ? 6 : 1;
        switch (keyCode) {
            case 263: {
                Vec2i vec2i = new Vec2i(-distance, 0);
                break;
            }
            case 262: {
                Vec2i vec2i = new Vec2i(distance, 0);
                break;
            }
            case 265: {
                Vec2i vec2i = new Vec2i(0, -distance);
                break;
            }
            case 264: {
                Vec2i vec2i = new Vec2i(0, distance);
                break;
            }
            default: {
                Vec2i vec2i = movement = null;
            }
        }
        if (movement != null) {
            Vec2i before = this.rep.offset;
            this.rep.offset = this.rep.offset.add(movement);
            this.repositionButtons(this.rep, before);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (super.method_25402(mouseX, mouseY, mouseButton)) {
            this.dragging = false;
            return true;
        }
        for (ControlButton cb : this.buttons) {
            if (!cb.method_25405(mouseX, mouseY)) continue;
            cb.method_25402(mouseX, mouseY, mouseButton);
            this.rep = cb;
            this.dragging = true;
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragging) {
            Vec2i before = this.rep.offset;
            if (this.rep.method_25403(mouseX, mouseY, button, dragX, dragY)) {
                this.repositionButtons(this.rep, before);
                return true;
            }
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        this.dragging = false;
        return super.method_25406(mouseX, mouseY, mouseButton);
    }

    private void repositionButtons(ControlButton button, Vec2i before) {
        if (!button.offset.equals(before)) {
            Vec2i diff = button.offset.subtract(before);
            for (ControlButton cb : this.buttons) {
                if (cb == button) continue;
                cb.offset = cb.offset.add(diff);
            }
        }
    }
}

