/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.gui.screen.config;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.config.ButtonLayout;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.config.Vec2i;
import dev.terminalmc.clientsort.client.order.CreativeSearchOrder;
import dev.terminalmc.clientsort.client.order.SortOrder;
import dev.terminalmc.clientsort.config.ClassPolicy;
import dev.terminalmc.clientsort.util.Localization;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;

public class ClothScreenProvider {
    private static EnumListEntry<?> firstSelector = null;
    private static EnumListEntry<?> secondSelector = null;
    private static EnumListEntry<?> thirdSelector = null;

    static class_437 getConfigScreen(class_437 parent) {
        Config.Options options = Config.options();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)Localization.localized("name", new Object[0])).setSavingRunnable(Config::getAndSave);
        ConfigEntryBuilder eb = builder.entryBuilder();
        ConfigCategory general = builder.getOrCreateCategory((class_2561)Localization.localized("option", "general", new Object[0]));
        general.addEntry((AbstractConfigListEntry)eb.startIntField((class_2561)Localization.localized("option", "interactionInterval", new Object[0]), options.interactionInterval).setTooltip(new class_2561[]{Localization.localized("option", "interactionInterval.tooltip", new Object[0])}).setErrorSupplier(val -> {
            if (val < 1) {
                return Optional.of(Localization.localized("error", "low", new Object[0]));
            }
            if (val > 100) {
                return Optional.of(Localization.localized("error", "high", new Object[0]));
            }
            return Optional.empty();
        }).setDefaultValue(10).setSaveConsumer(val -> {
            options.interactionInterval = val;
        }).build());
        general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((class_2561)Localization.localized("option", "useServerAcceleration", new Object[0]), options.useServerAcceleration).setTooltip(new class_2561[]{Localization.localized("option", "useServerAcceleration.tooltip", new Object[0])}).setDefaultValue(true).setSaveConsumer(val -> {
            options.useServerAcceleration = val;
        }).build());
        general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((class_2561)Localization.localized("option", "optimizeCreativeSorting", new Object[0]), options.optimizeCreativeSorting).setTooltip(new class_2561[]{Localization.localized("option", "optimizeCreativeSorting.tooltip", new Object[0])}).setDefaultValue(true).setSaveConsumer(val -> {
            options.optimizeCreativeSorting = val;
            if (val.booleanValue()) {
                CreativeSearchOrder.tryRefreshStackPositionMap();
            }
        }).build());
        general.addEntry((AbstractConfigListEntry)eb.startEnumSelector((class_2561)Localization.localized("option", "hotbarScope", new Object[0]), Config.Options.HotbarScope.class, (Enum)options.hotbarScope).setEnumNameProvider(val -> Localization.localized("hotbarScope", val.name(), new Object[0])).setTooltipSupplier(val -> Optional.of(new class_2561[]{Localization.localized("hotbarScope", String.valueOf(val) + ".tooltip", new Object[0])})).setDefaultValue((Enum)Config.Options.hotbarScopeDefault).setSaveConsumer(val -> {
            options.hotbarScope = val;
        }).build());
        general.addEntry((AbstractConfigListEntry)eb.startEnumSelector((class_2561)Localization.localized("option", "extraSlotScope", new Object[0]), Config.Options.ExtraSlotScope.class, (Enum)options.extraSlotScope).setEnumNameProvider(val -> Localization.localized("extraSlotScope", val.name(), new Object[0])).setTooltipSupplier(val -> Optional.of(new class_2561[]{Localization.localized("extraSlotScope", String.valueOf(val) + ".tooltip", new Object[0])})).setDefaultValue((Enum)Config.Options.extraSlotScopeDefault).setSaveConsumer(val -> {
            options.extraSlotScope = val;
        }).build());
        general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((class_2561)Localization.localized("option", "bundlesUseRightClick", new Object[0]), options.bundlesUseRightClick).setTooltip(new class_2561[]{Localization.localized("option", "bundlesUseRightClick.tooltip", new Object[0])}).setDefaultValue(false).setSaveConsumer(val -> {
            options.bundlesUseRightClick = val;
            if (val.booleanValue()) {
                CreativeSearchOrder.tryRefreshStackPositionMap();
            }
        }).build());
        general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((class_2561)Localization.localized("option", "showDebugInfo", new Object[0]), ClientSort.debug).setTooltip(new class_2561[]{Localization.localized("option", "showDebugInfo.tooltip", new Object[0])}).setDefaultValue(false).setSaveConsumer(val -> {
            ClientSort.debug = val;
        }).build());
        ConfigCategory sort = builder.getOrCreateCategory((class_2561)Localization.localized("option", "sorting", new Object[0]));
        sort.addEntry((AbstractConfigListEntry)eb.startSelector((class_2561)Localization.localized("option", "sortOrder", new Object[0]), SortOrder.SORT_MODES.keySet().toArray(), (Object)options.sortOrderStr).setNameProvider(val -> Localization.localized("sortOrder", (String)val, new Object[0])).setDefaultValue((Object)Config.Options.sortOrderDefault).setSaveConsumer(val -> {
            options.sortOrderStr = (String)val;
        }).build());
        sort.addEntry((AbstractConfigListEntry)eb.startSelector((class_2561)Localization.localized("option", "shiftSortOrder", new Object[0]), SortOrder.SORT_MODES.keySet().toArray(), (Object)options.shiftSortOrderStr).setNameProvider(val -> Localization.localized("sortOrder", (String)val, new Object[0])).setDefaultValue((Object)Config.Options.shiftSortOrderDefault).setSaveConsumer(val -> {
            options.shiftSortOrderStr = (String)val;
        }).build());
        sort.addEntry((AbstractConfigListEntry)eb.startSelector((class_2561)Localization.localized("option", "ctrlSortOrder", new Object[0]), SortOrder.SORT_MODES.keySet().toArray(), (Object)options.ctrlSortOrderStr).setNameProvider(val -> Localization.localized("sortOrder", (String)val, new Object[0])).setDefaultValue((Object)Config.Options.ctrlSortOrderDefault).setSaveConsumer(val -> {
            options.ctrlSortOrderStr = (String)val;
        }).build());
        sort.addEntry((AbstractConfigListEntry)eb.startSelector((class_2561)Localization.localized("option", "altSortOrder", new Object[0]), SortOrder.SORT_MODES.keySet().toArray(), (Object)options.altSortOrderStr).setNameProvider(val -> Localization.localized("sortOrder", (String)val, new Object[0])).setDefaultValue((Object)Config.Options.altSortOrderDefault).setSaveConsumer(val -> {
            options.altSortOrderStr = (String)val;
        }).build());
        ConfigCategory sound = builder.getOrCreateCategory((class_2561)Localization.localized("option", "sound", new Object[0]));
        sound.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((class_2561)Localization.localized("option", "playSoundSort", new Object[0]), options.playSoundSort).setTooltip(new class_2561[]{Localization.localized("option", "playSoundSort.tooltip", new Object[0])}).setDefaultValue(false).setSaveConsumer(val -> {
            options.playSoundSort = val;
        }).build());
        sound.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((class_2561)Localization.localized("option", "playSoundOther", new Object[0]), options.playSoundOther).setTooltip(new class_2561[]{Localization.localized("option", "playSoundOther.tooltip", new Object[0])}).setDefaultValue(false).setSaveConsumer(val -> {
            options.playSoundOther = val;
        }).build());
        sound.addEntry((AbstractConfigListEntry)eb.startStrField((class_2561)Localization.localized("option", "interactionSound", new Object[0]), options.interactionSound).setDefaultValue("minecraft:block.note_block.xylophone").setSaveConsumer(val -> {
            options.interactionSound = val;
        }).setErrorSupplier(val -> {
            if (class_2960.method_12829((String)val) == null) {
                return Optional.of(Localization.localized("error", "resourceLocation.parse", new Object[0]));
            }
            return Optional.empty();
        }).build());
        sound.addEntry((AbstractConfigListEntry)eb.startIntField((class_2561)Localization.localized("option", "soundInterval", new Object[0]), options.soundInterval).setTooltip(new class_2561[]{Localization.localized("option", "soundInterval.tooltip", new Object[0])}).setErrorSupplier(val -> {
            if (val < 1) {
                return Optional.of(Localization.localized("error", "low", new Object[0]));
            }
            if (val > 100) {
                return Optional.of(Localization.localized("error", "high", new Object[0]));
            }
            return Optional.empty();
        }).setDefaultValue(1).setSaveConsumer(val -> {
            options.soundInterval = val;
        }).build());
        sound.addEntry((AbstractConfigListEntry)eb.startFloatField((class_2561)Localization.localized("option", "soundPitchMin", new Object[0]), options.soundPitchMin).setTooltip(new class_2561[]{Localization.localized("option", "soundPitchMin.tooltip", new Object[0])}).setErrorSupplier(val -> {
            if (val.floatValue() < 0.5f) {
                return Optional.of(Localization.localized("error", "low", new Object[0]));
            }
            if (val.floatValue() > options.soundPitchMax) {
                return Optional.of(Localization.localized("error", "high", new Object[0]));
            }
            return Optional.empty();
        }).setDefaultValue(0.5f).setSaveConsumer(val -> {
            options.soundPitchMin = val.floatValue();
        }).build());
        sound.addEntry((AbstractConfigListEntry)eb.startFloatField((class_2561)Localization.localized("option", "soundPitchMax", new Object[0]), options.soundPitchMax).setTooltip(new class_2561[]{Localization.localized("option", "soundPitchMax.tooltip", new Object[0])}).setErrorSupplier(val -> {
            if (val.floatValue() < options.soundPitchMin) {
                return Optional.of(Localization.localized("error", "low", new Object[0]));
            }
            if (val.floatValue() > 2.0f) {
                return Optional.of(Localization.localized("error", "high", new Object[0]));
            }
            return Optional.empty();
        }).setDefaultValue(2.0f).setSaveConsumer(val -> {
            options.soundPitchMax = val.floatValue();
        }).build());
        sound.addEntry((AbstractConfigListEntry)eb.startFloatField((class_2561)Localization.localized("option", "soundVolume", new Object[0]), options.soundVolume).setErrorSupplier(val -> {
            if (val.floatValue() < 0.0f) {
                return Optional.of(Localization.localized("error", "low", new Object[0]));
            }
            if (val.floatValue() > 1.0f) {
                return Optional.of(Localization.localized("error", "high", new Object[0]));
            }
            return Optional.empty();
        }).setDefaultValue(0.2f).setSaveConsumer(val -> {
            options.soundVolume = val.floatValue();
        }).build());
        sound.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((class_2561)Localization.localized("option", "allowSoundOverlap", new Object[0]), options.allowSoundOverlap).setTooltip(new class_2561[]{Localization.localized("option", "allowSoundOverlap.tooltip", new Object[0])}).setDefaultValue(true).setSaveConsumer(val -> {
            options.allowSoundOverlap = val;
        }).build());
        ConfigCategory gui = builder.getOrCreateCategory((class_2561)Localization.localized("option", "gui", new Object[0]));
        gui.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((class_2561)Localization.localized("option", "showButtons", new Object[0]), options.showButtons).setTooltip(new class_2561[]{Localization.localized("option", "showButtons.tooltip", new Object[0])}).setDefaultValue(false).setSaveConsumer(val -> {
            options.showButtons = val;
        }).build());
        firstSelector = eb.startEnumSelector((class_2561)Localization.localized("option", "firstButton", new Object[0]), Config.Options.ControlButtonType.class, (Enum)options.firstButton).setErrorSupplier(val -> val.equals((Object)ClothScreenProvider.getSecondSelector()) || val.equals((Object)ClothScreenProvider.getThirdSelector()) ? Optional.of(Localization.localized("error", "controlButton.duplicate", new Object[0])) : Optional.empty()).setEnumNameProvider(val -> Localization.localized("controlButton", val.name(), new Object[0])).setDefaultValue((Enum)Config.Options.firstButtonDefault).setSaveConsumer(val -> {
            options.firstButton = val;
        }).build();
        gui.addEntry(firstSelector);
        secondSelector = eb.startEnumSelector((class_2561)Localization.localized("option", "secondButton", new Object[0]), Config.Options.ControlButtonType.class, (Enum)options.secondButton).setEnumNameProvider(val -> Localization.localized("controlButton", val.name(), new Object[0])).setErrorSupplier(val -> val.equals((Object)ClothScreenProvider.getFirstSelector()) || val.equals((Object)ClothScreenProvider.getThirdSelector()) ? Optional.of(Localization.localized("error", "controlButton.duplicate", new Object[0])) : Optional.empty()).setDefaultValue((Enum)Config.Options.secondButtonDefault).setSaveConsumer(val -> {
            options.secondButton = val;
        }).build();
        gui.addEntry(secondSelector);
        thirdSelector = eb.startEnumSelector((class_2561)Localization.localized("option", "thirdButton", new Object[0]), Config.Options.ControlButtonType.class, (Enum)options.thirdButton).setEnumNameProvider(val -> Localization.localized("controlButton", val.name(), new Object[0])).setErrorSupplier(val -> val.equals((Object)ClothScreenProvider.getFirstSelector()) || val.equals((Object)ClothScreenProvider.getSecondSelector()) ? Optional.of(Localization.localized("error", "controlButton.duplicate", new Object[0])) : Optional.empty()).setDefaultValue((Enum)Config.Options.thirdButtonDefault).setSaveConsumer(val -> {
            options.thirdButton = val;
        }).build();
        gui.addEntry(thirdSelector);
        SubCategoryBuilder layoutDefaults = eb.startSubCategory((class_2561)Localization.localized("option", "layoutDefaults", new Object[0])).setTooltip(new class_2561[]{Localization.localized("option", "layoutDefaults.tooltip", new Object[0])}).setExpanded(true);
        layoutDefaults.add((AbstractConfigListEntry)eb.startIntField((class_2561)Localization.localized("option", "layoutOffset.x", new Object[0]), options.layoutOffset.x()).setDefaultValue(Config.Options.layoutOffsetDefault.x()).setSaveConsumer(val -> {
            options.layoutOffset = new Vec2i((int)val, options.layoutOffset.y());
        }).build());
        layoutDefaults.add((AbstractConfigListEntry)eb.startIntField((class_2561)Localization.localized("option", "layoutOffset.y", new Object[0]), options.layoutOffset.y()).setDefaultValue(Config.Options.layoutOffsetDefault.y()).setSaveConsumer(val -> {
            options.layoutOffset = new Vec2i(options.layoutOffset.x(), (int)val);
        }).build());
        layoutDefaults.add((AbstractConfigListEntry)eb.startBooleanToggle((class_2561)Localization.localized("option", "sortEnabled", new Object[0]), options.sortEnabled).setDefaultValue(true).setSaveConsumer(val -> {
            options.sortEnabled = val;
        }).build());
        layoutDefaults.add((AbstractConfigListEntry)eb.startBooleanToggle((class_2561)Localization.localized("option", "stackFillEnabled", new Object[0]), options.stackFillEnabled).setDefaultValue(true).setSaveConsumer(val -> {
            options.stackFillEnabled = val;
        }).build());
        layoutDefaults.add((AbstractConfigListEntry)eb.startBooleanToggle((class_2561)Localization.localized("option", "transferEnabled", new Object[0]), options.transferEnabled).setDefaultValue(true).setSaveConsumer(val -> {
            options.transferEnabled = val;
        }).build());
        gui.addEntry((AbstractConfigListEntry)layoutDefaults.build());
        gui.addEntry((AbstractConfigListEntry)eb.startStrList((class_2561)Localization.localized("option", "buttonLayouts", new Object[0]), ClothScreenProvider.getLayoutStrings(options.buttonLayouts.values())).setTooltip(new class_2561[]{Localization.localized("option", "buttonLayouts.tooltip.1", new Object[0]).method_27693("\n").method_10852((class_2561)Localization.localized("option", "buttonLayouts.tooltip.2", new Object[0])).method_27693("\n  ").method_10852((class_2561)Localization.localized("option", "buttonLayouts.tooltip.3", new Object[0])).method_27693("\n  ").method_10852((class_2561)Localization.localized("option", "buttonLayouts.tooltip.4", new Object[0])).method_27693("\n  ").method_10852((class_2561)Localization.localized("option", "buttonLayouts.tooltip.5", new Object[0])).method_27693("\n").method_10852((class_2561)Localization.localized("option", "buttonLayouts.tooltip.6", new Object[0]))}).setExpanded(true).setErrorSupplier(list -> {
            int i = 0;
            for (String string : list) {
                try {
                    ButtonLayout.fromDataString(string, options.buttonLayouts.keySet());
                }
                catch (ParseException ex) {
                    return Optional.of(Localization.localized("error", "buttonLayout.parse", i + 1, ex.getMessage()));
                }
                ++i;
            }
            return Optional.empty();
        }).setDefaultValue(ClothScreenProvider.getLayoutStrings((Collection<ButtonLayout>)Config.Options.buttonLayoutsDefaultList.get())).setSaveConsumer(list -> {
            HashSet<ButtonLayout> layouts = new HashSet<ButtonLayout>();
            for (String string : list) {
                try {
                    ButtonLayout layout2 = ButtonLayout.fromDataString(string, options.buttonLayouts.keySet());
                    layouts.add(layout2);
                }
                catch (ParseException ex) {
                    ClientSort.LOG.error("Encountered a button layout parsing error on string '{}' not caught by error checker: {}", string, ex.getMessage());
                }
            }
            options.buttonLayouts.clear();
            layouts.forEach(layout -> options.buttonLayouts.put(layout.className(), (ButtonLayout)layout));
        }).build());
        ConfigCategory policies = builder.getOrCreateCategory((class_2561)Localization.localized("option", "policies", new Object[0]));
        policies.addEntry((AbstractConfigListEntry)eb.startTextDescription((class_2561)Localization.localized("option", "policies.description", new Object[0])).build());
        policies.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((class_2561)Localization.localized("option", "applyPolicies", new Object[0]), options.applyPolicies).setTooltip(new class_2561[]{Localization.localized("option", "applyPolicies.tooltip", new Object[0])}).setDefaultValue(true).setSaveConsumer(val -> {
            options.applyPolicies = val;
        }).build());
        policies.addEntry((AbstractConfigListEntry)eb.startStrList((class_2561)Localization.localized("option", "classPolicies", new Object[0]), ClothScreenProvider.getPolicyStrings(options.classPolicies.values())).setTooltip(new class_2561[]{Localization.localized("option", "classPolicies.tooltip.1", new Object[0]).method_27693("\n").method_10852((class_2561)Localization.localized("option", "classPolicies.tooltip.2", new Object[0])).method_27693("\n  ").method_10852((class_2561)Localization.localized("option", "classPolicies.tooltip.3", new Object[0])).method_27693("\n  ").method_10852((class_2561)Localization.localized("option", "classPolicies.tooltip.4", new Object[0])).method_27693("\n").method_10852((class_2561)Localization.localized("option", "classPolicies.tooltip.5", new Object[0]))}).setExpanded(true).setErrorSupplier(list -> {
            int i = 0;
            for (String string : list) {
                try {
                    ClassPolicy.fromDataString(string, options.classPolicies.keySet());
                }
                catch (ParseException ex) {
                    return Optional.of(Localization.localized("error", "classPolicy.parse", i + 1, ex.getMessage()));
                }
                ++i;
            }
            return Optional.empty();
        }).setDefaultValue(ClothScreenProvider.getPolicyStrings((Collection<ClassPolicy>)Config.Options.classPoliciesDefaultList.get())).setSaveConsumer(list -> {
            HashSet<ClassPolicy> classPolicies = new HashSet<ClassPolicy>();
            for (String string : list) {
                try {
                    ClassPolicy policy2 = ClassPolicy.fromDataString(string, options.classPolicies.keySet());
                    classPolicies.add(policy2);
                }
                catch (ParseException ex) {
                    ClientSort.LOG.error("Encountered a class policy parsing error on string '{}' not caught by error checker: {}", string, ex.getMessage());
                }
            }
            options.classPolicies.clear();
            classPolicies.forEach(policy -> options.classPolicies.put(policy.className, (ClassPolicy)policy));
        }).build());
        return builder.build();
    }

    private static List<String> getLayoutStrings(Collection<ButtonLayout> layouts) {
        ArrayList<String> strings = new ArrayList<String>();
        for (ButtonLayout layout : layouts) {
            strings.add(layout.toDataString());
        }
        return strings;
    }

    private static List<String> getPolicyStrings(Collection<ClassPolicy> policies) {
        ArrayList<String> strings = new ArrayList<String>();
        for (ClassPolicy policy : policies) {
            strings.add(policy.toDataString());
        }
        return strings;
    }

    private static Config.Options.ControlButtonType getFirstSelector() {
        return firstSelector == null ? null : (Config.Options.ControlButtonType)((Object)firstSelector.getValue());
    }

    private static Config.Options.ControlButtonType getSecondSelector() {
        return secondSelector == null ? null : (Config.Options.ControlButtonType)((Object)secondSelector.getValue());
    }

    private static Config.Options.ControlButtonType getThirdSelector() {
        return thirdSelector == null ? null : (Config.Options.ControlButtonType)((Object)thirdSelector.getValue());
    }
}

