/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.gui;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.config.ButtonLayout;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.config.Vec2i;
import dev.terminalmc.clientsort.client.gui.screen.edit.ContainerPositionEditScreen;
import dev.terminalmc.clientsort.client.gui.screen.edit.GroupSelectorScreen;
import dev.terminalmc.clientsort.client.gui.screen.edit.PlayerPositionEditScreen;
import dev.terminalmc.clientsort.client.gui.widget.ControlButton;
import dev.terminalmc.clientsort.client.gui.widget.SortButton;
import dev.terminalmc.clientsort.client.gui.widget.StackFillButton;
import dev.terminalmc.clientsort.client.gui.widget.TransferButton;
import dev.terminalmc.clientsort.client.inventory.screen.ContainerScreenHelper;
import dev.terminalmc.clientsort.client.inventory.util.Scope;
import dev.terminalmc.clientsort.config.ClassPolicy;
import dev.terminalmc.clientsort.mixin.client.accessor.ScreenAccessor;
import dev.terminalmc.clientsort.util.inject.ISlot;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1724;
import net.minecraft.class_1735;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class ControlButtonManager {
    private static final int BUTTON_SPACING = 1;
    private static final int BUTTON_SHIFT_X = 0;
    private static final int BUTTON_SHIFT_Y = 1;
    private static final Set<Class<?>> layoutClasses = new LinkedHashSet();
    private static final Set<Class<?>> policyClasses = new LinkedHashSet();
    private static final LinkedHashSet<ControlButton> containerButtons = new LinkedHashSet();
    private static final LinkedHashSet<ControlButton> playerButtons = new LinkedHashSet();

    private ControlButtonManager() {
    }

    public static LinkedList<ControlButton> getContainerButtons() {
        return new LinkedList<ControlButton>(containerButtons);
    }

    public static LinkedList<ControlButton> getPlayerButtons() {
        return new LinkedList<ControlButton>(playerButtons);
    }

    public static void afterScreenInit(class_437 screen) {
        class_1735 playerRefSlot;
        if (!(screen instanceof class_465)) {
            return;
        }
        class_465 acs = (class_465)screen;
        containerButtons.clear();
        playerButtons.clear();
        if (!Config.options().showButtons) {
            return;
        }
        boolean forceShowContainer = false;
        boolean forceShowPlayer = false;
        class_437 currentScreen = class_310.method_1551().field_1755;
        if (currentScreen instanceof GroupSelectorScreen) {
            forceShowContainer = true;
            forceShowPlayer = true;
        } else if (currentScreen instanceof ContainerPositionEditScreen) {
            forceShowContainer = true;
        } else if (currentScreen instanceof PlayerPositionEditScreen) {
            forceShowPlayer = true;
        }
        class_1735 containerRefSlot = ControlButtonManager.getReferenceSlot(acs, false);
        if (containerRefSlot != null) {
            ControlButtonManager.generate(acs, containerRefSlot, false, forceShowContainer, Config.options().firstButton);
            ControlButtonManager.generate(acs, containerRefSlot, false, forceShowContainer, Config.options().secondButton);
            ControlButtonManager.generate(acs, containerRefSlot, false, forceShowContainer, Config.options().thirdButton);
        }
        if ((playerRefSlot = ControlButtonManager.getReferenceSlot(acs, true)) != null) {
            ControlButtonManager.generate(acs, playerRefSlot, true, forceShowPlayer, Config.options().firstButton);
            ControlButtonManager.generate(acs, playerRefSlot, true, forceShowPlayer, Config.options().secondButton);
            ControlButtonManager.generate(acs, playerRefSlot, true, forceShowPlayer, Config.options().thirdButton);
        }
    }

    private static void generate(class_465<?> screen, class_1735 refSlot, boolean isPlayerInv, boolean forceShow, Config.Options.ControlButtonType type) {
        switch (type) {
            case SORT: {
                ControlButtonManager.generateSortButton(screen, refSlot, isPlayerInv, forceShow);
                break;
            }
            case STACK_FILL: {
                ControlButtonManager.generateStackFillButton(screen, refSlot, isPlayerInv, forceShow);
                break;
            }
            case TRANSFER: {
                ControlButtonManager.generateTransferButton(screen, refSlot, isPlayerInv, forceShow);
            }
        }
    }

    private static void generateSortButton(class_465<?> screen, class_1735 referenceSlot, boolean isPlayerInv, boolean forceShow) {
        boolean active;
        boolean enabled;
        boolean disabledByPolicy;
        class_1661 container;
        @Nullable class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (screen instanceof class_490 && !isPlayerInv) {
            return;
        }
        if (ControlButtonManager.getNumberOfBulkInventorySlots(screen, isPlayerInv) < 3) {
            return;
        }
        Object object = container = isPlayerInv ? player.method_31548() : ControlButtonManager.getContainer((class_1657)player);
        if (container == null) {
            return;
        }
        class_1661 object2 = container instanceof class_1277 ? screen.method_17577() : container;
        @Nullable ClassPolicy policy = ControlButtonManager.getPolicy(object2.getClass());
        boolean bl = disabledByPolicy = policy != null && !policy.sortEnabled;
        if (disabledByPolicy && !forceShow) {
            return;
        }
        @Nullable ButtonLayout layout = ControlButtonManager.getLayout(object2.getClass());
        Vec2i offset = layout != null ? layout.offset() : Config.options().layoutOffset;
        boolean bl2 = enabled = layout != null ? layout.sortEnabled() : Config.options().sortEnabled;
        if (layout != null && enabled) {
            active = true;
        } else if (forceShow) {
            active = false;
        } else {
            return;
        }
        String layoutKey = layout != null ? layout.className() : null;
        String lowestLayoutKey = object2.getClass().getName();
        String policyKey = policy != null ? policy.className : lowestLayoutKey;
        SortButton button = new SortButton(screen, (class_1263)container, layoutKey, lowestLayoutKey, policyKey, disabledByPolicy, isPlayerInv, referenceSlot, ControlButtonManager.getShiftedOffset(offset, isPlayerInv), active);
        ControlButtonManager.addButton(screen, button, isPlayerInv);
    }

    private static void generateStackFillButton(class_465<?> screen, class_1735 referenceSlot, boolean isPlayerInv, boolean forceShow) {
        boolean active;
        boolean dstEnabled;
        boolean disabledByPolicy;
        class_1661 container;
        @Nullable class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (screen instanceof class_490 && !isPlayerInv) {
            return;
        }
        if (ControlButtonManager.getNumberOfBulkInventorySlots(screen, isPlayerInv) < 3) {
            return;
        }
        Object object = container = isPlayerInv ? player.method_31548() : ControlButtonManager.getContainer((class_1657)player);
        if (container == null) {
            return;
        }
        class_1661 object2 = container instanceof class_1277 ? screen.method_17577() : container;
        @Nullable ClassPolicy policy = ControlButtonManager.getPolicy(object2.getClass());
        boolean bl = disabledByPolicy = policy != null && !policy.stackFillEnabled;
        if (disabledByPolicy && !forceShow) {
            return;
        }
        @Nullable ButtonLayout layout = ControlButtonManager.getLayout(object2.getClass());
        Vec2i offset = layout != null ? layout.offset() : Config.options().layoutOffset;
        boolean enabled = layout != null ? layout.stackFillEnabled() : Config.options().stackFillEnabled;
        @Nullable class_1263 dstContainer = isPlayerInv ? ControlButtonManager.getContainer((class_1657)player) : player.method_31548();
        ButtonLayout dstLayout = null;
        if (dstContainer != null) {
            Object dstObject = dstContainer instanceof class_1277 ? screen.method_17577() : dstContainer;
            @Nullable ClassPolicy dstPolicy = ControlButtonManager.getPolicy(dstObject.getClass());
            if (dstPolicy != null && !dstPolicy.stackFillEnabled && !forceShow) {
                return;
            }
            dstLayout = ControlButtonManager.getLayout(dstObject.getClass());
        }
        boolean bl2 = dstEnabled = dstLayout != null ? dstLayout.stackFillEnabled() : Config.options().stackFillEnabled;
        if (layout != null && enabled && dstLayout != null && dstEnabled) {
            active = true;
        } else if (forceShow) {
            active = false;
        } else {
            return;
        }
        String layoutKey = layout != null ? layout.className() : null;
        String lowestLayoutKey = object2.getClass().getName();
        String policyKey = policy != null ? policy.className : lowestLayoutKey;
        StackFillButton button = new StackFillButton(screen, (class_1263)container, layoutKey, lowestLayoutKey, policyKey, disabledByPolicy, isPlayerInv, referenceSlot, ControlButtonManager.getShiftedOffset(offset, isPlayerInv), active);
        ControlButtonManager.addButton(screen, button, isPlayerInv);
    }

    private static void generateTransferButton(class_465<?> screen, class_1735 referenceSlot, boolean isPlayerInv, boolean forceShow) {
        boolean active;
        boolean dstEnabled;
        boolean disabledByPolicy;
        class_1661 container;
        @Nullable class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (screen instanceof class_490 && !isPlayerInv) {
            return;
        }
        if (ControlButtonManager.getNumberOfBulkInventorySlots(screen, isPlayerInv) < 3) {
            return;
        }
        Object object = container = isPlayerInv ? player.method_31548() : ControlButtonManager.getContainer((class_1657)player);
        if (container == null) {
            return;
        }
        class_1661 object2 = container instanceof class_1277 ? screen.method_17577() : container;
        @Nullable ClassPolicy policy = ControlButtonManager.getPolicy(object2.getClass());
        boolean bl = disabledByPolicy = policy != null && !policy.transferEnabled;
        if (disabledByPolicy && !forceShow) {
            return;
        }
        @Nullable ButtonLayout layout = ControlButtonManager.getLayout(object2.getClass());
        Vec2i offset = layout != null ? layout.offset() : Config.options().layoutOffset;
        boolean enabled = layout != null ? layout.transferEnabled() : Config.options().transferEnabled;
        @Nullable class_1263 dstContainer = isPlayerInv ? ControlButtonManager.getContainer((class_1657)player) : player.method_31548();
        ButtonLayout dstLayout = null;
        if (dstContainer != null) {
            Object dstObject = dstContainer instanceof class_1277 ? screen.method_17577() : dstContainer;
            @Nullable ClassPolicy dstPolicy = ControlButtonManager.getPolicy(dstObject.getClass());
            if (dstPolicy != null && !dstPolicy.transferEnabled && !forceShow) {
                return;
            }
            dstLayout = ControlButtonManager.getLayout(dstObject.getClass());
        }
        boolean bl2 = dstEnabled = dstLayout != null ? dstLayout.transferEnabled() : Config.options().transferEnabled;
        if (layout != null && enabled && dstLayout != null && dstEnabled) {
            active = true;
        } else if (forceShow) {
            active = false;
        } else {
            return;
        }
        String layoutKey = layout != null ? layout.className() : null;
        String lowestLayoutKey = object2.getClass().getName();
        String policyKey = policy != null ? policy.className : lowestLayoutKey;
        TransferButton button = new TransferButton(screen, (class_1263)container, layoutKey, lowestLayoutKey, policyKey, disabledByPolicy, isPlayerInv, referenceSlot, ControlButtonManager.getShiftedOffset(offset, isPlayerInv), active);
        ControlButtonManager.addButton(screen, button, isPlayerInv);
    }

    public static void reloadLayoutClasses(Set<String> classNames) {
        layoutClasses.clear();
        for (String className : classNames) {
            try {
                layoutClasses.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                if (!ClientSort.debug) continue;
                ClientSort.LOG.warn("Unable to load layout class '{}': Class not found.", className);
            }
        }
    }

    public static void reloadPolicyClasses(Set<String> classNames) {
        policyClasses.clear();
        for (String className : classNames) {
            try {
                policyClasses.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                if (!ClientSort.debug) continue;
                ClientSort.LOG.warn("Unable to load policy class '{}': Class not found.", className);
            }
        }
    }

    @Nullable
    public static ButtonLayout getLayout(Class<?> cls) {
        ButtonLayout layout = Config.options().buttonLayouts.get(cls.getName());
        if (layout != null) {
            return layout;
        }
        Set matches = layoutClasses.stream().filter(c -> c.isAssignableFrom(cls)).collect(Collectors.toSet());
        for (Class c1 : matches) {
            boolean hasSubclass = false;
            for (Class c2 : matches) {
                if (c1.equals(c2) || !c1.isAssignableFrom(c2)) continue;
                hasSubclass = true;
                break;
            }
            if (hasSubclass) continue;
            return Config.options().buttonLayouts.get(c1.getName());
        }
        return null;
    }

    @Nullable
    public static ClassPolicy getPolicy(Class<?> cls) {
        if (!Config.options().applyPolicies) {
            return null;
        }
        ClassPolicy policy = Config.options().classPolicies.get(cls.getName());
        if (policy != null) {
            return policy;
        }
        Set matches = policyClasses.stream().filter(c -> c.isAssignableFrom(cls)).collect(Collectors.toSet());
        for (Class c1 : matches) {
            boolean hasSubclass = false;
            for (Class c2 : matches) {
                if (c1.equals(c2) || !c1.isAssignableFrom(c2)) continue;
                hasSubclass = true;
                break;
            }
            if (hasSubclass) continue;
            return Config.options().classPolicies.get(c1.getName());
        }
        return null;
    }

    @Nullable
    public static class_1263 getContainer(class_1657 player) {
        try {
            return player.field_7512.method_7611((int)0).field_7871;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private static void addButton(class_465<?> screen, ControlButton button, boolean isPlayerInv) {
        ((ScreenAccessor)screen).clientsort$addRenderableWidget(button);
        (isPlayerInv ? playerButtons : containerButtons).add(button);
    }

    @Nullable
    private static class_1735 getReferenceSlot(class_465<?> screen, boolean isPlayerInv) {
        ContainerScreenHelper<class_465<?>> helper = ContainerScreenHelper.of(screen);
        return screen.method_17577().field_7761.stream().filter(slot -> isPlayerInv ? slot.field_7871 instanceof class_1661 && helper.getScope((class_1735)slot).equals((Object)Scope.PLAYER_INV) : !(slot.field_7871 instanceof class_1661) && helper.getScope((class_1735)slot).equals((Object)Scope.CONTAINER_INV)).max(Comparator.comparingInt(slot -> slot.field_7873 * 9999 - slot.field_7872)).orElse(null);
    }

    private static int getNumberOfBulkInventorySlots(class_465<?> screen, boolean isPlayerInv) {
        return screen.method_17577().field_7761.stream().filter(slot -> isPlayerInv == slot.field_7871 instanceof class_1661).filter(slot -> !(screen.method_17577() instanceof class_1724) || ((ISlot)slot).clientsort$getIndexInInv() >= 2).mapToInt(slot -> 1).sum();
    }

    public static Vec2i getShiftedOffset(Vec2i offset, boolean isPlayerInv) {
        int index = (isPlayerInv ? playerButtons : containerButtons).size();
        int x = offset.x() + 0 * index;
        int y = offset.y() + 14 * index;
        return new Vec2i(x, y);
    }
}

