/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.terminalmc.clientsort.client.ClientSort;
import dev.terminalmc.clientsort.client.config.ButtonLayout;
import dev.terminalmc.clientsort.client.config.Vec2i;
import dev.terminalmc.clientsort.client.order.SortOrder;
import dev.terminalmc.clientsort.config.ClassPolicy;
import dev.terminalmc.clientsort.platform.Services;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1661;
import net.minecraft.class_1707;
import net.minecraft.class_1722;
import net.minecraft.class_1724;
import net.minecraft.class_1730;
import net.minecraft.class_1733;
import net.minecraft.class_2621;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Config {
    private static final Path CONFIG_DIR = Services.PLATFORM.getConfigDir();
    private static final String FILE_NAME = "clientsort.json";
    private static final String BACKUP_FILE_NAME = "clientsort.unreadable.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public final Options options = new Options();
    private static Config instance = null;

    public static Options options() {
        return Config.get().options;
    }

    private void validate() {
        this.options.interactionInterval = Math.clamp((long)this.options.interactionInterval, 1, 100);
        this.options.soundInterval = Math.clamp((long)this.options.soundInterval, 1, 100);
        this.options.soundPitchMin = Math.clamp(this.options.soundPitchMin, 0.5f, 2.0f);
        this.options.soundPitchMax = Math.clamp(this.options.soundPitchMax, this.options.soundPitchMin, 2.0f);
        this.options.soundVolume = Math.clamp(this.options.soundVolume, 0.0f, 1.0f);
        if (this.options.firstButton == null || this.options.firstButton.equals((Object)this.options.secondButton) || this.options.firstButton.equals((Object)this.options.thirdButton) || !Arrays.stream(Options.ControlButtonType.values()).toList().contains((Object)this.options.firstButton)) {
            this.options.firstButton = Options.firstButtonDefault;
        }
        if (this.options.secondButton == null || this.options.secondButton.equals((Object)this.options.firstButton) || this.options.secondButton.equals((Object)this.options.thirdButton) || !Arrays.stream(Options.ControlButtonType.values()).toList().contains((Object)this.options.secondButton)) {
            this.options.secondButton = Options.secondButtonDefault;
        }
        if (this.options.thirdButton == null || this.options.thirdButton.equals((Object)this.options.firstButton) || this.options.thirdButton.equals((Object)this.options.secondButton) || !Arrays.stream(Options.ControlButtonType.values()).toList().contains((Object)this.options.thirdButton)) {
            this.options.thirdButton = Options.thirdButtonDefault;
        }
        LinkedHashMap<String, ButtonLayout> sortedLayouts = new LinkedHashMap<String, ButtonLayout>();
        this.options.buttonLayouts.keySet().stream().sorted().forEach(k -> sortedLayouts.put((String)k, this.options.buttonLayouts.get(k)));
        this.options.buttonLayouts = sortedLayouts;
    }

    public static Config get() {
        if (instance == null) {
            instance = Config.load();
        }
        return instance;
    }

    public static Config getAndSave() {
        Config.get();
        Config.save();
        return instance;
    }

    public static Config resetAndSave() {
        instance = new Config();
        Config.save();
        return instance;
    }

    @NotNull
    public static Config load() {
        Path file = CONFIG_DIR.resolve(FILE_NAME);
        Config config = null;
        if (Files.exists(file, new LinkOption[0]) && (config = Config.load(file, GSON)) == null) {
            Config.backup();
            ClientSort.LOG.warn("Resetting config", new Object[0]);
        }
        return config != null ? config : new Config();
    }

    @Nullable
    private static Config load(Path file, Gson gson) {
        Config config;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file.toFile()), StandardCharsets.UTF_8);
        try {
            config = (Config)gson.fromJson((Reader)reader, Config.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                ClientSort.LOG.error("Unable to load config", e);
                return null;
            }
        }
        reader.close();
        return config;
    }

    private static void backup() {
        try {
            ClientSort.LOG.warn("Copying {} to {}", FILE_NAME, BACKUP_FILE_NAME);
            if (!Files.isDirectory(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            Path file = CONFIG_DIR.resolve(FILE_NAME);
            Path backupFile = file.resolveSibling(BACKUP_FILE_NAME);
            Files.move(file, backupFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            ClientSort.LOG.error("Unable to copy config file", e);
        }
    }

    public static void save() {
        if (instance == null) {
            return;
        }
        instance.validate();
        try {
            if (!Files.isDirectory(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            Path file = CONFIG_DIR.resolve(FILE_NAME);
            Path tempFile = file.resolveSibling(String.valueOf(file.getFileName()) + ".tmp");
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile.toFile()), StandardCharsets.UTF_8);){
                writer.write(GSON.toJson((Object)instance));
            }
            catch (IOException e) {
                throw new IOException(e);
            }
            Files.move(tempFile, file, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            ClientSort.onConfigSaved(instance);
        }
        catch (IOException e) {
            ClientSort.LOG.error("Unable to save config", e);
        }
    }

    public static class Options {
        public static final int INTERACTION_INTERVAL_MIN = 1;
        public static final int INTERACTION_INTERVAL_MAX = 100;
        public static final int interactionIntervalDefault = 10;
        public int interactionInterval = 10;
        public static final boolean useServerAccelerationDefault = true;
        public boolean useServerAcceleration = true;
        public static final boolean optimizeCreativeSortingDefault = true;
        public boolean optimizeCreativeSorting = true;
        public static final HotbarScope hotbarScopeDefault = HotbarScope.HOTBAR;
        public HotbarScope hotbarScope = hotbarScopeDefault;
        public static final ExtraSlotScope extraSlotScopeDefault = ExtraSlotScope.EXTRA;
        public ExtraSlotScope extraSlotScope = extraSlotScopeDefault;
        public static final boolean bundlesUseRightClickDefault = false;
        public boolean bundlesUseRightClick = false;
        public static final String sortOrderDefault = SortOrder.CREATIVE.name;
        public String sortOrderStr = sortOrderDefault;
        public transient SortOrder sortOrder;
        public static final String shiftSortOrderDefault = SortOrder.QUANTITY.name;
        public String shiftSortOrderStr = shiftSortOrderDefault;
        public transient SortOrder shiftSortOrder;
        public static final String ctrlSortOrderDefault = SortOrder.ALPHABET.name;
        public String ctrlSortOrderStr = ctrlSortOrderDefault;
        public transient SortOrder ctrlSortOrder;
        public static final String altSortOrderDefault = SortOrder.RAW_ID.name;
        public String altSortOrderStr = altSortOrderDefault;
        public transient SortOrder altSortOrder;
        public static final boolean playSoundSortDefault = false;
        public boolean playSoundSort = false;
        public static final boolean playSoundOtherDefault = false;
        public boolean playSoundOther = false;
        public static final String interactionSoundDefault = "minecraft:block.note_block.xylophone";
        public String interactionSound = "minecraft:block.note_block.xylophone";
        @Nullable
        public transient class_2960 sortSoundLoc = null;
        public static final int SOUND_INTERVAL_MIN = 1;
        public static final int SOUND_INTERVAL_MAX = 100;
        public static final int soundIntervalDefault = 1;
        public int soundInterval = 1;
        public static final float SOUND_PITCH_MIN = 0.5f;
        public static final float SOUND_PITCH_MAX = 2.0f;
        public static final float soundPitchMinDefault = 0.5f;
        public float soundPitchMin = 0.5f;
        public static final float soundPitchMaxDefault = 2.0f;
        public float soundPitchMax = 2.0f;
        public static final float SOUND_VOLUME_MIN = 0.0f;
        public static final float SOUND_VOLUME_MAX = 1.0f;
        public static final float soundVolumeDefault = 0.2f;
        public float soundVolume = 0.2f;
        public static final boolean allowSoundOverlapDefault = true;
        public boolean allowSoundOverlap = true;
        public static final boolean showButtonsDefault = false;
        public boolean showButtons = false;
        public static final ControlButtonType firstButtonDefault = ControlButtonType.SORT;
        public ControlButtonType firstButton = firstButtonDefault;
        public static final ControlButtonType secondButtonDefault = ControlButtonType.STACK_FILL;
        public ControlButtonType secondButton = secondButtonDefault;
        public static final ControlButtonType thirdButtonDefault = ControlButtonType.TRANSFER;
        public ControlButtonType thirdButton = thirdButtonDefault;
        public static final Vec2i layoutOffsetDefault = new Vec2i(-4, 0);
        public Vec2i layoutOffset = layoutOffsetDefault;
        public static final boolean sortEnabledDefault = true;
        public boolean sortEnabled = true;
        public static final boolean stackFillEnabledDefault = true;
        public boolean stackFillEnabled = true;
        public static final boolean transferEnabledDefault = true;
        public boolean transferEnabled = true;
        public static final Supplier<List<ButtonLayout>> buttonLayoutsDefaultList = () -> List.of(new ButtonLayout(class_1661.class.getName(), null, true, true, true), new ButtonLayout(class_1707.class.getName(), null, null, null, null), new ButtonLayout(class_1722.class.getName(), null, false, false, null), new ButtonLayout(class_1724.class.getName(), null, null, null, null), new ButtonLayout(class_1730.class.getName(), null, null, null, null), new ButtonLayout(class_1733.class.getName(), null, null, null, null), new ButtonLayout(class_2621.class.getName(), null, null, null, null));
        public static final Supplier<Map<String, ButtonLayout>> buttonLayoutsDefault = () -> {
            LinkedHashMap map = new LinkedHashMap();
            buttonLayoutsDefaultList.get().forEach(layout -> map.put(layout.className(), layout));
            return map;
        };
        public Map<String, ButtonLayout> buttonLayouts = buttonLayoutsDefault.get();
        public static final boolean applyPoliciesDefault = true;
        public boolean applyPolicies = true;
        public static final Supplier<List<ClassPolicy>> classPoliciesDefaultList = () -> List.of(new ClassPolicy("com.simibubi.create.content.equipment.toolbox.ToolboxMenu", false, false, false));
        public static final Supplier<Map<String, ClassPolicy>> classPoliciesDefault = () -> {
            LinkedHashMap map = new LinkedHashMap();
            classPoliciesDefaultList.get().forEach(policy -> map.put(policy.className, policy));
            return map;
        };
        public Map<String, ClassPolicy> classPolicies = classPoliciesDefault.get();

        public static enum HotbarScope {
            HOTBAR,
            INVENTORY,
            NONE;

        }

        public static enum ExtraSlotScope {
            EXTRA,
            HOTBAR,
            INVENTORY,
            NONE;

        }

        public static enum ControlButtonType {
            SORT,
            STACK_FILL,
            TRANSFER;

        }
    }
}

