/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.config;

import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.config.Vec2i;
import dev.terminalmc.clientsort.util.Localization;
import java.text.ParseException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ButtonLayout(String className, @Nullable Vec2i offset, @Nullable Boolean sortEnabled, @Nullable Boolean stackFillEnabled, @Nullable Boolean transferEnabled) {
    @Nullable
    private final Vec2i offset;
    @Nullable
    private final Boolean sortEnabled;
    @Nullable
    private final Boolean stackFillEnabled;
    @Nullable
    private final Boolean transferEnabled;
    public static final String DATA_FORMAT = "%s,%s,%s,%s,%s";
    public static final String DATA_POS_FORMAT = "(%d,%d)";
    public static final String DATA_PATTERN_STRING = "^(.+),(?:-|\\((-?\\d+),(-?\\d+)\\)),(?:-|([01])),(?:-|([01])),(?:-|([01]))$";
    public static final Pattern DATA_PATTERN = Pattern.compile("^(.+),(?:-|\\((-?\\d+),(-?\\d+)\\)),(?:-|([01])),(?:-|([01])),(?:-|([01]))$");

    public String toDataString() {
        Object[] objectArray = new Object[5];
        objectArray[0] = this.className;
        Object object = objectArray[1] = this.offset == null ? "-" : String.format(DATA_POS_FORMAT, this.offset.x(), this.offset.y());
        Object object2 = this.sortEnabled == null ? "-" : (objectArray[2] = Integer.valueOf(this.sortEnabled != false ? 1 : 0));
        Object object3 = this.stackFillEnabled == null ? "-" : (objectArray[3] = Integer.valueOf(this.stackFillEnabled != false ? 1 : 0));
        objectArray[4] = this.transferEnabled == null ? "-" : Integer.valueOf(this.transferEnabled != false ? 1 : 0);
        return String.format(DATA_FORMAT, objectArray);
    }

    public static ButtonLayout fromDataString(String dataString, Set<String> originalClassNames) throws ParseException {
        Matcher matcher = DATA_PATTERN.matcher(dataString = dataString.strip());
        if (!matcher.matches()) {
            throw new ParseException(Localization.localized("error", "buttonLayout.pattern", DATA_PATTERN_STRING).getString(), 0);
        }
        String className = matcher.group(1);
        if (!originalClassNames.contains(className)) {
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new ParseException(Localization.localized("error", "buttonLayout.classNotFound", className).getString(), 0);
            }
        }
        return new ButtonLayout(className, matcher.group(2) == null ? null : new Vec2i(Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3))), matcher.group(4) == null ? null : Boolean.valueOf(matcher.group(4).equals("1")), matcher.group(5) == null ? null : Boolean.valueOf(matcher.group(5).equals("1")), matcher.group(6) == null ? null : Boolean.valueOf(matcher.group(6).equals("1")));
    }

    @NotNull
    public Vec2i offset() {
        return this.offset == null ? Config.options().layoutOffset : this.offset;
    }

    @NotNull
    public Boolean sortEnabled() {
        return this.sortEnabled == null ? Config.options().sortEnabled : this.sortEnabled;
    }

    @NotNull
    public Boolean stackFillEnabled() {
        return this.stackFillEnabled == null ? Config.options().stackFillEnabled : this.stackFillEnabled;
    }

    @NotNull
    public Boolean transferEnabled() {
        return this.transferEnabled == null ? Config.options().transferEnabled : this.transferEnabled;
    }
}

