/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.type.map;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;
import net.minecraft.class_11515;
import team.creative.creativecore.common.util.type.itr.ComputeNextIterator;
import team.creative.creativecore.common.util.type.itr.FunctionIterator;
import team.creative.creativecore.common.util.type.list.Tuple;

public class ChunkLayerMap<T>
implements Iterable<T> {
    private static final int LAYERS_COUNT = class_11515.values().length;
    private static final Object2IntMap<RenderPipeline> LAYERS_INDEX_MAP = new Object2IntArrayMap();
    private final T[] content;

    public ChunkLayerMap(ChunkLayerMap<T> map) {
        this.content = Arrays.copyOf(map.content, LAYERS_COUNT);
    }

    public ChunkLayerMap(Function<RenderPipeline, T> factory) {
        this.content = new Object[LAYERS_COUNT];
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = factory.apply(class_11515.values()[i].method_72020());
        }
    }

    public ChunkLayerMap() {
        this.content = new Object[LAYERS_COUNT];
    }

    private int index(RenderPipeline layer) {
        return LAYERS_INDEX_MAP.getInt((Object)layer);
    }

    public T get(RenderPipeline layer) {
        return this.content[this.index(layer)];
    }

    public T put(RenderPipeline layer, T element) {
        int index = this.index(layer);
        T result = this.content[index];
        this.content[index] = element;
        return result;
    }

    public T remove(RenderPipeline layer) {
        int index = this.index(layer);
        T result = this.content[index];
        this.content[index] = null;
        return result;
    }

    public void clear() {
        Arrays.fill(this.content, null);
    }

    public Iterable<Tuple<RenderPipeline, T>> tuples() {
        return new ComputeNextIterator<Tuple<RenderPipeline, T>>(){
            private int index;
            private final Tuple<RenderPipeline, T> pair = new Tuple<Object, Object>(null, null);

            @Override
            protected Tuple<RenderPipeline, T> computeNext() {
                while (this.index < ChunkLayerMap.this.content.length && ChunkLayerMap.this.content[this.index] == null) {
                    ++this.index;
                }
                if (this.index >= ChunkLayerMap.this.content.length) {
                    return (Tuple)this.end();
                }
                this.pair.key = class_11515.values()[this.index].method_72020();
                this.pair.value = ChunkLayerMap.this.content[this.index];
                ++this.index;
                return this.pair;
            }
        };
    }

    public boolean containsKey(RenderPipeline layer) {
        return this.get(layer) != null;
    }

    @Override
    public Iterator<T> iterator() {
        return new ComputeNextIterator<T>(){
            private int index;

            @Override
            protected T computeNext() {
                while (this.index < ChunkLayerMap.this.content.length && ChunkLayerMap.this.content[this.index] == null) {
                    ++this.index;
                }
                if (this.index >= ChunkLayerMap.this.content.length) {
                    return this.end();
                }
                Object result = ChunkLayerMap.this.content[this.index];
                ++this.index;
                return result;
            }
        };
    }

    public int size() {
        int size = 0;
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content[i] == null) continue;
            ++size;
        }
        return size;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content[i] == null) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "[" + String.join((CharSequence)",", () -> new FunctionIterator<CharSequence>(this, Object::toString)) + "]";
    }

    static {
        int i = 0;
        for (class_11515 layer : class_11515.values()) {
            LAYERS_INDEX_MAP.put((Object)layer.method_72020(), i);
            ++i;
        }
    }
}

