/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.ingredient;

import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2189;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.collection.GuiCheckList;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.control.collection.GuiStackSelector;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlock;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlockTag;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientFuel;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItem;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemStack;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemTag;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.text.TextMapBuilder;

@Environment(value=EnvType.CLIENT)
public abstract class GuiCreativeIngredientHandler {
    public static final NamedHandlerRegistry<GuiCreativeIngredientHandler> REGISTRY = new NamedHandlerRegistry<Object>(null);

    public static GuiCreativeIngredientHandler find(CreativeIngredient info) {
        if (info != null) {
            for (GuiCreativeIngredientHandler handler : REGISTRY.values()) {
                if (!handler.canHandle(info)) continue;
                return handler;
            }
        }
        return REGISTRY.getDefault();
    }

    public abstract boolean canHandle(CreativeIngredient var1);

    public abstract void createControls(GuiParent var1, CreativeIngredient var2);

    public abstract CreativeIngredient parseControls(GuiParent var1);

    public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
    }

    static {
        REGISTRY.registerDefault("Default", new GuiCreativeIngredientHandler(){

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                List<class_2960> list;
                GuiStackSelector selector = (GuiStackSelector)new GuiStackSelector("inv", gui.getPlayer(), new GuiStackSelector.CreativeCollector(new GuiStackSelector.SearchSelector())).setExpandableX();
                gui.add((GuiControl)selector);
                if (info instanceof CreativeIngredientItemStack) {
                    CreativeIngredientItemStack s = (CreativeIngredientItemStack)info;
                    list = s.getIncluded();
                } else {
                    list = new ArrayList<class_2960>();
                }
                gui.add((GuiControl)new GuiDataCheckList("list", false, null, list).setExpandable());
                if (info instanceof CreativeIngredientBlock || info instanceof CreativeIngredientItem || info instanceof CreativeIngredientItemStack) {
                    selector.setSelectedForce(info.getExample().method_7972());
                }
                this.onChanged(gui, new GuiControlChangedEvent<GuiStackSelector>(selector));
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientBlock || info instanceof CreativeIngredientItem || info instanceof CreativeIngredientItemStack;
            }

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                class_1799 stack = gui.get("inv", GuiStackSelector.class).getSelected();
                if (stack != null) {
                    GuiDataCheckList list = (GuiDataCheckList)gui.get("list");
                    List<class_2960> included = list.getConfiguredIncluded();
                    if (included.isEmpty()) {
                        if (!(class_2248.method_9503((class_1792)stack.method_7909()) instanceof class_2189)) {
                            return new CreativeIngredientBlock(class_2248.method_9503((class_1792)stack.method_7909()));
                        }
                        return new CreativeIngredientItem(stack.method_7909());
                    }
                    return new CreativeIngredientItemStack(stack, included);
                }
                return null;
            }

            @Override
            public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
                GuiControl guiControl;
                if (event.control.is("inv") && (guiControl = event.control) instanceof GuiStackSelector) {
                    GuiStackSelector selector = (GuiStackSelector)guiControl;
                    GuiDataCheckList list = (GuiDataCheckList)gui.get("list");
                    class_1799 stack = selector.getSelected();
                    TextMapBuilder<class_9331> map = new TextMapBuilder<class_9331>();
                    Object2BooleanArrayMap selected = new Object2BooleanArrayMap();
                    class_2487 nbt = (class_2487)class_1799.field_24671.encodeStart((DynamicOps)class_2509.field_11560, (Object)stack).getOrThrow();
                    if (!(nbt = nbt.method_68568("components")).method_33133()) {
                        for (String component : nbt.method_10541()) {
                            class_2960 location = class_2960.method_60654((String)component);
                            class_9331 type = (class_9331)class_7923.field_49658.method_63535(location);
                            map.addComponent(type, (class_2561)class_2561.method_43470((String)component).method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)((String)nbt.method_10580(component).method_68658().get())).method_27692(class_124.field_1080)));
                            if (!list.includes(type)) continue;
                            selected.put((Object)type, true);
                        }
                    }
                    list.set(map, selected);
                    gui.reflow();
                }
            }
        });
        REGISTRY.register("Blocktag", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                GuiComboBox box = (GuiComboBox)gui.get("tag");
                class_6862 tag = (class_6862)box.selected();
                if (tag != null) {
                    return new CreativeIngredientBlockTag((class_6862<class_2248>)tag);
                }
                return null;
            }

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                gui.flow = GuiFlow.STACK_Y;
                gui.align = Align.STRETCH;
                GuiComboBox<class_6862> box = new GuiComboBox<class_6862>("tag", new TextMapBuilder<class_6862>().addComponents(class_7923.field_41175.method_40272().map(x -> (class_6862)x.method_45925().get()).toList(), x -> {
                    TextBuilder builder = new TextBuilder();
                    Iterator itr = class_7923.field_41175.method_40286(x).iterator();
                    if (itr.hasNext()) {
                        builder.stack(new class_1799((class_1935)((class_6880)itr.next()).comp_349()));
                    }
                    return builder.text(x.comp_327().toString()).build();
                }));
                gui.add((GuiControl)box);
                gui.add((GuiControl)new GuiTextfield("search"));
                if (info instanceof CreativeIngredientBlockTag) {
                    box.select(((CreativeIngredientBlockTag)info).tag);
                }
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientBlockTag;
            }

            @Override
            public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
                if (event.control.is("search")) {
                    GuiComboBox box = (GuiComboBox)gui.get("tag");
                    box.set(new TextMapBuilder().setFilter(x -> x.toLowerCase().contains(((GuiTextfield)event.control).getText())).addComponents(class_7923.field_41175.method_40272().map(x -> (class_6862)x.method_45925().get()).toList(), x -> {
                        TextBuilder builder = new TextBuilder();
                        Iterator itr = class_7923.field_41175.method_40286(x).iterator();
                        if (itr.hasNext()) {
                            builder.stack(new class_1799((class_1935)((class_6880)itr.next()).comp_349()));
                        }
                        return builder.text(x.comp_327().toString()).build();
                    }));
                }
            }
        });
        REGISTRY.register("Itemtag", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                GuiComboBox box = (GuiComboBox)gui.get("tag");
                class_6862 tag = (class_6862)box.selected();
                if (tag != null) {
                    return new CreativeIngredientItemTag((class_6862<class_1792>)tag);
                }
                return null;
            }

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                gui.flow = GuiFlow.STACK_Y;
                gui.align = Align.STRETCH;
                GuiComboBox<class_6862> box = new GuiComboBox<class_6862>("tag", new TextMapBuilder<class_6862>().addComponents(class_7923.field_41178.method_40272().map(x -> (class_6862)x.method_45925().get()).toList(), x -> {
                    TextBuilder builder = new TextBuilder();
                    Iterator itr = class_7923.field_41178.method_40286(x).iterator();
                    if (itr.hasNext()) {
                        builder.stack(new class_1799((class_1935)((class_6880)itr.next()).comp_349()));
                    }
                    return builder.text(x.comp_327().toString()).build();
                }));
                gui.add((GuiControl)box);
                gui.add((GuiControl)new GuiTextfield("search"));
                if (info instanceof CreativeIngredientItemTag) {
                    box.select(((CreativeIngredientItemTag)info).tag);
                }
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientItemTag;
            }

            @Override
            public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
                if (event.control.is("search")) {
                    GuiComboBox box = (GuiComboBox)gui.get("tag");
                    box.set(new TextMapBuilder().setFilter(x -> x.toLowerCase().contains(((GuiTextfield)event.control).getText())).addComponents(class_7923.field_41178.method_40272().map(x -> (class_6862)x.method_45925().get()).toList(), x -> {
                        TextBuilder builder = new TextBuilder();
                        Iterator itr = class_7923.field_41178.method_40286(x).iterator();
                        if (itr.hasNext()) {
                            builder.stack(new class_1799((class_1935)((class_6880)itr.next()).comp_349()));
                        }
                        return builder.text(x.comp_327().toString()).build();
                    }));
                }
            }
        });
        REGISTRY.register("Fuel", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                return new CreativeIngredientFuel();
            }

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                gui.add((GuiControl)new GuiLabel("info").setTitle((class_2561)class_2561.method_43470((String)"Nothing to select")));
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientFuel;
            }
        });
    }

    public static class GuiDataCheckList
    extends GuiCheckList<class_9331<?>> {
        public List<class_2960> included;

        public GuiDataCheckList(String name, boolean modifiable, TextMapBuilder<class_9331<?>> map, List<class_2960> included) {
            super(name, modifiable, map, null);
            this.included = included;
        }

        public boolean includes(class_9331<?> type) {
            return this.included.contains(class_7923.field_49658.method_10221(type));
        }

        public List<class_2960> getConfiguredIncluded() {
            ArrayList<class_2960> included = new ArrayList<class_2960>();
            for (GuiCheckList.GuiCheckListRow row : this.rows) {
                if (!row.checkBox.value) continue;
                included.add(class_7923.field_49658.method_10221((Object)((class_9331)row.value)));
            }
            return included;
        }
    }
}

