/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.integration;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3999;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_7225;
import net.minecraft.class_8001;
import org.joml.Matrix3x2fStack;
import team.creative.creativecore.client.render.gui.CreativeGuiGraphics;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.event.GuiTooltipEvent;
import team.creative.creativecore.common.gui.integration.ScreenEventListener;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.geo.Rect;

public interface IGuiIntegratedParent
extends IGuiParent {
    public static final GuiLayer EMPTY = new GuiLayer("empty"){

        @Override
        public void create() {
        }
    };

    public class_7225.class_7874 provider();

    public List<GuiLayer> getLayers();

    public GuiLayer getTopLayer();

    default public boolean isOpen(Class<? extends GuiLayer> clazz) {
        for (GuiLayer layer : this.getLayers()) {
            if (!clazz.isInstance(layer)) continue;
            return true;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    default public void render(class_332 graphics, class_437 screen, ScreenEventListener listener, int mouseX, int mouseY) {
        Matrix3x2fStack pose = graphics.method_51448();
        int width = screen.field_22789;
        int height = screen.field_22790;
        listener.tick();
        Rect screenRect = Rect.getScreenRect();
        List<GuiLayer> layers = this.getLayers();
        for (int i = 0; i < layers.size(); ++i) {
            GuiLayer layer = layers.get(i);
            if (i == layers.size() - 1 && layer.hasGrayBackground()) {
                ((CreativeGuiGraphics)graphics).verticalGradientRect(0, 0, width, height, -1072689136, -804253680);
            }
            pose.pushMatrix();
            int offX = (width - layer.getWidth()) / 2;
            int offY = (height - layer.getHeight()) / 2;
            pose.translate((float)offX, (float)offY);
            Rect controlRect = new Rect(offX, offY, offX + layer.getWidth(), offY + layer.getHeight());
            layer.render(graphics, controlRect, screenRect.intersection(controlRect), 1.0, mouseX, mouseY);
            pose.popMatrix();
            RenderSystem.disableScissorForRenderTypeDraws();
        }
        if (layers.isEmpty()) {
            return;
        }
        GuiLayer layer = this.getTopLayer();
        GuiTooltipEvent event = layer.getTooltipEvent(mouseX - listener.getOffsetX(), mouseY - listener.getOffsetY());
        if (event != null) {
            layer.raiseEvent(event);
            if (!event.isCanceled()) {
                class_327 font = class_310.method_1551().field_1772;
                List<class_5684> list = IGuiIntegratedParent.gatherTooltipComponents(null, event.tooltip, Optional.empty(), mouseX, graphics.method_51421(), graphics.method_51443(), font);
                graphics.method_51435(font, list, mouseX, mouseY, class_8001.field_41687, null);
            }
        }
    }

    public static List<class_5684> gatherTooltipComponents(class_1799 stack, List<? extends class_5348> textElements, Optional<class_5632> itemComponent, int mouseX, int screenWidth, int screenHeight, class_327 fallbackFont) {
        List elements = textElements.stream().map(Either::left).collect(Collectors.toCollection(ArrayList::new));
        itemComponent.ifPresent(c -> elements.add(1, Either.right((Object)c)));
        return IGuiIntegratedParent.gatherTooltipComponentsFromElements(stack, elements, mouseX, screenWidth, screenHeight, fallbackFont);
    }

    public static List<class_5684> gatherTooltipComponentsFromElements(class_1799 stack, List<Either<class_5348, class_5632>> elements, int mouseX, int screenWidth, int screenHeight, class_327 fallbackFont) {
        class_327 font = fallbackFont;
        int tooltipTextWidth = elements.stream().mapToInt(either -> (Integer)either.map(arg_0 -> ((class_327)font).method_27525(arg_0), component -> 0)).max().orElse(0);
        boolean needsWrap = false;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        int tooltipTextWidthF = tooltipTextWidth;
        if (needsWrap) {
            return elements.stream().flatMap(either -> (Stream)either.map(text -> IGuiIntegratedParent.splitLine(text, font, tooltipTextWidthF), component -> Stream.of(class_5684.method_32663((class_5632)component)))).toList();
        }
        return elements.stream().map(either -> (class_5684)either.map(text -> {
            class_5481 class_54812;
            if (text instanceof class_2561) {
                class_2561 c = (class_2561)text;
                class_54812 = c.method_30937();
            } else {
                class_54812 = class_2477.method_10517().method_30934(text);
            }
            return class_5684.method_32662((class_5481)class_54812);
        }, class_5684::method_32663)).toList();
    }

    private static Stream<class_5684> splitLine(class_5348 text, class_327 font, int maxWidth) {
        class_2561 component;
        if (text instanceof class_2561 && (component = (class_2561)text).getString().isEmpty()) {
            return Stream.of(component.method_30937()).map(class_5684::method_32662);
        }
        return font.method_1728(text, maxWidth).stream().map(class_5684::method_32662);
    }

    public static Comparator<class_3999> makeParticleRenderTypeComparator(List<class_3999> renderOrder) {
        Comparator<class_3999> vanillaComparator = Comparator.comparingInt(renderOrder::indexOf);
        return (typeOne, typeTwo) -> {
            boolean vanillaOne = renderOrder.contains(typeOne);
            boolean vanillaTwo = renderOrder.contains(typeTwo);
            if (vanillaOne && vanillaTwo) {
                return vanillaComparator.compare((class_3999)typeOne, (class_3999)typeTwo);
            }
            if (!vanillaOne && !vanillaTwo) {
                return Integer.compare(System.identityHashCode(typeOne), System.identityHashCode(typeTwo));
            }
            return vanillaOne ? -1 : 1;
        };
    }

    @Override
    default public void raiseEvent(GuiEvent event) {
    }

    @Override
    default public void reflow() {
    }

    public void openLayer(GuiLayer var1);

    public void closeLayer(int var1);

    @Override
    default public boolean isParent(IGuiParent parent) {
        return parent == this;
    }

    @Override
    default public boolean hasGui() {
        return true;
    }

    default public GuiControl get(String control) {
        for (GuiLayer layer : this.getLayers()) {
            if (!control.startsWith(layer.getNestedName())) continue;
            if (control.equals(layer.getNestedName())) {
                return layer;
            }
            return layer.get(control.substring(layer.getNestedName().length() + 1));
        }
        return null;
    }

    @Override
    default public Rect toScreenRect(GuiControl control, Rect rect) {
        if (control instanceof GuiLayer) {
            GuiLayer layer = (GuiLayer)control;
            int offX = (class_310.method_1551().method_22683().method_4486() - layer.getWidth()) / 2;
            int offY = (class_310.method_1551().method_22683().method_4502() - layer.getHeight()) / 2;
            rect.move(offX, offY);
        }
        return rect;
    }

    @Override
    default public Rect toLayerRect(GuiControl control, Rect rect) {
        return rect;
    }

    @Override
    default public IGuiIntegratedParent getIntegratedParent() {
        return this;
    }

    public void send(CreativePacket var1);
}

