/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.control.simple;

import java.util.List;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import team.creative.creativecore.client.render.gui.CreativeGuiGraphics;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.parser.LongValueParser;
import team.creative.creativecore.common.gui.style.ControlFormatting;

public class GuiSeekBar
extends GuiControl {
    private final LongSupplier posSupplier;
    private final LongSupplier maxSupplier;
    public LongConsumer timeUpdate;
    public LongConsumer lastTimeUpdate;
    private long pos;
    private long max;
    public final LongValueParser parser;
    public boolean grabbedSlider;

    public GuiSeekBar(String name, LongSupplier posSupplier, LongSupplier maxSupplier) {
        this(name, posSupplier, maxSupplier, LongValueParser.TIME_DURATION);
    }

    public GuiSeekBar(String name, LongSupplier posSupplier, LongSupplier maxSupplier, LongValueParser parser) {
        super(name);
        this.posSupplier = posSupplier;
        this.maxSupplier = maxSupplier;
        this.parser = parser;
        this.tick();
    }

    public GuiSeekBar setOnTimeUpdate(LongConsumer consumer) {
        this.timeUpdate = consumer;
        return this;
    }

    public GuiSeekBar setOnLastTimeUpdate(LongConsumer consumer) {
        this.lastTimeUpdate = consumer;
        return this;
    }

    public void setPosition(long value) {
        if (this.pos >= this.max) {
            value = this.max;
        }
        this.timeUpdate.accept(value);
        this.pos = value;
        if (this.getParent() != null) {
            this.raiseEvent(new GuiControlChangedEvent<GuiSeekBar>(this));
        }
    }

    @Override
    public GuiSeekBar setTooltip(List<class_2561> tooltip) {
        super.setTooltip(tooltip);
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void renderContent(class_332 graphics, int mouseX, int mouseY) {
        double percent = this.max > 0L ? (double)this.pos / (double)this.max : 0.0;
        this.renderProgress(graphics, percent);
        ((CreativeGuiGraphics)graphics).drawStringCentered(this.parser.parse(this.pos, this.max), this.rect.getContentWidth(), this.rect.getContentHeight(), this.getStyle().fontColor.toInt(), true);
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderProgress(class_332 graphics, double percent) {
        this.getStyle().clickable.render(graphics, 0.0, 0.0, (double)this.rect.getContentWidth() * Math.min(percent, 1.0), this.rect.getContentHeight());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean mouseClicked(double x, double y, int button) {
        if (button == 0) {
            GuiSeekBar.playSound((class_6880.class_6883<class_3414>)class_3417.field_15015);
            this.grabbedSlider = this.max > 0L;
            this.mouseMoved(x, y);
            return true;
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void mouseMoved(double x, double y) {
        if (this.grabbedSlider) {
            long value;
            int width = this.rect.getWidth() - this.getContentOffset() * 2;
            if (x < (double)this.getContentOffset()) {
                value = 0L;
            } else if (x > (double)(this.getContentOffset() + width)) {
                value = this.maxSupplier.getAsLong();
            } else {
                int mouseOffsetX = (int)(x - (double)this.getContentOffset());
                value = (long)((float)this.maxSupplier.getAsLong() * ((float)mouseOffsetX / (float)width));
            }
            this.setPosition(value);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void mouseReleased(double x, double y, int button) {
        if (this.grabbedSlider) {
            this.lastTimeUpdate.accept(this.pos);
            this.grabbedSlider = false;
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void closed() {
    }

    @Override
    public void tick() {
        if (!this.grabbedSlider) {
            this.pos = this.posSupplier.getAsLong();
            this.max = this.maxSupplier.getAsLong();
        }
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.PROGRESSBAR;
    }

    @Override
    public void flowX(int width, int preferred) {
    }

    @Override
    public void flowY(int width, int height, int preferred) {
    }

    @Override
    protected int preferredWidth(int availableWidth) {
        return 40;
    }

    @Override
    protected int preferredHeight(int width, int availableHeight) {
        return 14;
    }
}

