/*
 * Decompiled with CFR 0.152.
 */
package jeb.mixin;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jeb.client.JEBClient;
import jeb.client.RecipeIndex;
import jeb.client.RecipeLoader;
import net.minecraft.class_10266;
import net.minecraft.class_10297;
import net.minecraft.class_10302;
import net.minecraft.class_10352;
import net.minecraft.class_10355;
import net.minecraft.class_10363;
import net.minecraft.class_155;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_299;
import net.minecraft.class_310;
import net.minecraft.class_516;
import net.minecraft.class_634;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_634.class})
public abstract class ClientPlayNetworkHandlerMixin {
    @Unique
    private static final Map<String, Integer> VANILLA_RECIPE_COUNTS = Map.of("1.21.4", 1358, "1.21.5", 1361, "1.21.6", 1395, "1.21.7", 1395);
    @Unique
    private static final Map<String, Integer> VANILLA_CT_ID = Map.of("1.21.4", 259, "1.21.5", 259, "1.21.6", 262, "1.21.7", 262);

    @Inject(method={"onRecipeBookAdd"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/recipebook/ClientRecipeBook;add(Lnet/minecraft/recipe/RecipeDisplayEntry;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void injectOnRecipeBookAdd(class_10266 packet, CallbackInfo ci, class_299 clientRecipeBook, Iterator var3, class_10266.class_10267 entry) {
        class_10352 context = class_10363.method_65008((class_1937)((class_1937)Objects.requireNonNull(class_310.method_1551().field_1687)));
        if (JEBClient.recipesLoaded) {
            long startTime = System.currentTimeMillis();
            class_10355 category = entry.comp_3233().comp_3265();
            JEBClient.LOGGER.info("[JEB] checking recipe {} started at {}", (Object)entry.comp_3233().comp_3263().comp_3258().method_64742(context).toString(), (Object)new Date(startTime));
            if (!RecipeIndex.recipeIdExistsInIndex(category, entry.comp_3233())) {
                RecipeIndex.addAndIndexRecipeIfAbsent(category, entry.comp_3233(), context);
                JEBClient.LOGGER.info("[JEB] The recipe has been added: {}", (Object)entry.comp_3233().comp_3263().comp_3258().method_64742(context).toString());
            }
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            JEBClient.LOGGER.info("[JEB] checking recipe done at {} ({} ms)", (Object)new Date(endTime), (Object)duration);
            return;
        }
        class_10302 resultSlot = entry.comp_3233().comp_3263().comp_3258();
        List stacks = resultSlot.method_64738(context);
        class_1799 stack = (class_1799)stacks.get(0);
        if (((class_1799)entry.comp_3233().comp_3263().comp_3259().method_64738(context).getFirst()).method_7909() == class_1802.field_8465) {
            JEBClient.existingResultItems.add(stack.method_7909());
        }
    }

    @Inject(method={"onRecipeBookAdd"}, at={@At(value="TAIL")})
    private void afterRecipeBookAdd(class_10266 packet, CallbackInfo ci) {
        if (JEBClient.recipesLoaded) {
            return;
        }
        String version = class_155.method_16673().comp_4025();
        int vanillaMaxRecipes = VANILLA_RECIPE_COUNTS.getOrDefault(version, 1358);
        int vanillaCTID = VANILLA_CT_ID.getOrDefault(version, 259);
        class_310 client = class_310.method_1551();
        int knownRecipeCount = 0;
        class_299 recipeBook = null;
        int craftingStationId = 0;
        recipeBook = client.field_1724.method_3130();
        List recipes = recipeBook.method_1393();
        for (class_516 collection : recipes) {
            List entries = collection.method_2650();
            for (class_10297 entry : entries) {
                class_10352 context;
                class_10302 resultSlot = entry.comp_3263().comp_3258();
                List stacks = resultSlot.method_64738(context = class_10363.method_65008((class_1937)((class_1937)Objects.requireNonNull(client.field_1687))));
                class_1799 stack = (class_1799)stacks.getFirst();
                if (stack.method_7909() == class_1802.field_8465) {
                    craftingStationId = entry.comp_3262().comp_3267();
                }
                ++knownRecipeCount;
            }
        }
        if (knownRecipeCount < vanillaMaxRecipes && craftingStationId == vanillaCTID) {
            try {
                RecipeLoader.loadRecipesFromLog();
                JEBClient.recipesLoaded = true;
                RecipeIndex.buildRecipeIndex();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (knownRecipeCount >= vanillaMaxRecipes || craftingStationId != vanillaCTID && craftingStationId != 0) {
            JEBClient.recipesLoaded = true;
            RecipeIndex.buildRecipeIndex();
        }
        if (JEBClient.recipesLoaded) {
            JEBClient.nonexistingResultItems.clear();
            for (class_1792 item : class_7923.field_41178) {
                if (item == class_1802.field_8162 || JEBClient.existingResultItems.contains(item)) continue;
                JEBClient.nonexistingResultItems.add(item);
            }
            RecipeIndex.fillItemIndex();
        }
    }
}

