/*
 * Decompiled with CFR 0.152.
 */
package jeb.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jeb.client.JEBClient;
import net.minecraft.class_10294;
import net.minecraft.class_10295;
import net.minecraft.class_10297;
import net.minecraft.class_10298;
import net.minecraft.class_10300;
import net.minecraft.class_10301;
import net.minecraft.class_10302;
import net.minecraft.class_10314;
import net.minecraft.class_10315;
import net.minecraft.class_10352;
import net.minecraft.class_10355;
import net.minecraft.class_10363;
import net.minecraft.class_155;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_299;
import net.minecraft.class_310;
import net.minecraft.class_314;
import net.minecraft.class_437;
import net.minecraft.class_518;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class RecipeLoader {
    private static List<String> parseBracketedList(String input) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        int bracketLevel = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == ',' && bracketLevel == 0) {
                result.add(current.toString().trim());
                current.setLength(0);
                continue;
            }
            if (c == '[') {
                ++bracketLevel;
            } else if (c == ']') {
                --bracketLevel;
            }
            current.append(c);
        }
        if (!current.isEmpty()) {
            result.add(current.toString().trim());
        }
        return result;
    }

    private static String fixResourceName(String resourceName) {
        if (resourceName.startsWith("minecraft:")) {
            return resourceName.substring("minecraft:".length());
        }
        return resourceName;
    }

    public static void loadRecipesFromLog() throws IOException {
        String name = "recipes_" + class_155.method_16673().comp_4025() + ".txt";
        try (InputStream input = RecipeLoader.class.getClassLoader().getResourceAsStream(name);){
            if (input == null) {
                System.err.println("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0444\u0430\u0439\u043b " + name + " \u0432 \u0440\u0435\u0441\u0443\u0440\u0441\u0430\u0445");
                return;
            }
            List lines = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.toList());
            for (String line : lines) {
                if (!line.startsWith("Display:")) continue;
                Optional<class_10297> recipeEntry = RecipeLoader.parseLineToRecipeEntry(line);
                recipeEntry.ifPresent(RecipeLoader::sendToClient);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Optional<class_10297> parseLineToRecipeEntry(String line) {
        block88: {
            try {
                Matcher categoryMatcher;
                if (line.contains("StonecutterRecipeDisplay")) {
                    Matcher categoryMatcher2;
                    Matcher idMatcher = Pattern.compile("NetworkID:NetworkRecipeId\\[index=(\\d+)]").matcher(line);
                    int index = idMatcher.find() ? Integer.parseInt(idMatcher.group(1)) : -1;
                    OptionalInt group = OptionalInt.empty();
                    Matcher groupMatcher = Pattern.compile("Group:OptionalInt\\[(\\d+)]").matcher(line);
                    if (groupMatcher.find()) {
                        group = OptionalInt.of(Integer.parseInt(groupMatcher.group(1)));
                    }
                    class_10355 category = (categoryMatcher2 = Pattern.compile("Category:Optional\\[ResourceKey\\[minecraft:recipe_book_category / minecraft:(\\w+)]]").matcher(line)).find() ? (class_10355)class_7923.field_54927.method_63535(class_2960.method_60655((String)"minecraft", (String)categoryMatcher2.group(1))) : class_314.field_1810;
                    Matcher inputMatcher = Pattern.compile("input=CompositeSlotDisplay\\[contents=\\[ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / minecraft:(.*?)]=minecraft:(.*?)\\}\\]\\]]").matcher(line);
                    if (!inputMatcher.find()) {
                        return Optional.empty();
                    }
                    String inputItem = RecipeLoader.fixResourceName(inputMatcher.group(2));
                    Matcher resultMatcher = Pattern.compile("result=StackSlotDisplay\\[stack=(\\d+) minecraft:(\\w+)]").matcher(line);
                    if (!resultMatcher.find()) {
                        return Optional.empty();
                    }
                    int resultCount = Integer.parseInt(resultMatcher.group(1));
                    String resultItem = RecipeLoader.fixResourceName(resultMatcher.group(2));
                    Matcher stationMatcher = Pattern.compile("craftingStation=ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / minecraft:(.*?)]=minecraft:(.*?)\\}\\]").matcher(line);
                    if (!stationMatcher.find()) {
                        return Optional.empty();
                    }
                    String stationName = RecipeLoader.fixResourceName(stationMatcher.group(2));
                    Matcher itemsMatcher = Pattern.compile("Crafting Requirements Items:(.*)").matcher(line);
                    if (!itemsMatcher.find()) {
                        return Optional.empty();
                    }
                    String itemsSection = itemsMatcher.group(1);
                    ArrayList<class_1856> ingredients = new ArrayList<class_1856>();
                    for (String rawItem : itemsSection.split(";")) {
                        ArrayList<class_1792> arrayList = new ArrayList<class_1792>();
                        for (String itemVariant : rawItem.split(",")) {
                            String path;
                            String[] splitItem;
                            String namespace;
                            class_2960 id;
                            class_1792 item;
                            String itemName = itemVariant.trim();
                            if (itemName.isBlank() || (item = (class_1792)class_7923.field_41178.method_63535(id = class_2960.method_60655((String)(namespace = (splitItem = itemName.split(":")).length == 2 ? splitItem[0] : "minecraft"), (String)(path = splitItem[splitItem.length - 1])))) == class_1802.field_8162) continue;
                            arrayList.add(item);
                        }
                        if (arrayList.isEmpty()) continue;
                        ingredients.add(class_1856.method_26964(arrayList.stream()));
                    }
                    class_10302.class_10306 itemSlot = new class_10302.class_10306((class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)inputItem)));
                    class_10302.class_10304 class_103042 = new class_10302.class_10304(List.of(itemSlot));
                    class_10302.class_10307 resultSlot = new class_10302.class_10307(new class_1799((class_1935)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)resultItem)), resultCount));
                    class_10302.class_10306 stationSlot = new class_10302.class_10306((class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)stationName)));
                    class_10298 class_102982 = new class_10298(index);
                    class_10315 display = new class_10315((class_10302)class_103042, (class_10302)resultSlot, (class_10302)stationSlot);
                    class_10297 entry = new class_10297(class_102982, (class_10295)display, group, category, Optional.of(ingredients));
                    return Optional.of(entry);
                }
                if (line.contains("SmithingRecipeDisplay")) {
                    Pattern stackPattern;
                    Matcher matcher;
                    Matcher categoryMatcher3;
                    Matcher idMatcher = Pattern.compile("NetworkID:NetworkRecipeId\\[index=(\\d+)]").matcher(line);
                    int index = idMatcher.find() ? Integer.parseInt(idMatcher.group(1)) : -1;
                    OptionalInt group = OptionalInt.empty();
                    Matcher groupMatcher = Pattern.compile("Group:OptionalInt\\[(\\d+)]").matcher(line);
                    if (groupMatcher.find()) {
                        group = OptionalInt.of(Integer.parseInt(groupMatcher.group(1)));
                    }
                    class_10355 category = (categoryMatcher3 = Pattern.compile("Category:Optional\\[ResourceKey\\[minecraft:recipe_book_category / minecraft:(\\w+)]]").matcher(line)).find() ? (class_10355)class_7923.field_54927.method_63535(class_2960.method_60655((String)"minecraft", (String)categoryMatcher3.group(1))) : class_314.field_1810;
                    Matcher templateMatcher = Pattern.compile("template=CompositeSlotDisplay\\[contents=\\[ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / minecraft:(.*?)\\]=minecraft:(.*?)\\}\\]\\]]").matcher(line);
                    String templateItem = templateMatcher.find() ? RecipeLoader.fixResourceName(templateMatcher.group(2)) : "air";
                    String baseItem = null;
                    boolean isBaseTag = false;
                    Matcher baseMatcher = Pattern.compile("base=(?:CompositeSlotDisplay\\[contents=\\[ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / minecraft:[^\\]]+\\]=minecraft:([^}\\]]+)\\}\\]\\]\\]|TagSlotDisplay\\[tag=TagKey\\[minecraft:item / minecraft:([^\\]]+)\\]\\])").matcher(line);
                    if (baseMatcher.find()) {
                        if (baseMatcher.group(1) != null) {
                            baseItem = RecipeLoader.fixResourceName(baseMatcher.group(1));
                            isBaseTag = true;
                        } else if (baseMatcher.group(2) != null) {
                            baseItem = baseMatcher.group(2);
                            isBaseTag = false;
                        }
                    }
                    if (baseItem == null) {
                        baseItem = "air";
                        isBaseTag = false;
                    }
                    String additionTag = null;
                    Matcher additionMatcher = Pattern.compile("addition=TagSlotDisplay\\[tag=TagKey\\[minecraft:item / minecraft:(.*?)\\]\\]").matcher(line);
                    if (additionMatcher.find()) {
                        if (additionMatcher.group(1) != null) {
                            additionTag = additionMatcher.group(1).contains("TagSlotDisplay") ? additionMatcher.group(1) : RecipeLoader.fixResourceName(additionMatcher.group(1));
                        } else if (additionMatcher.group(3) != null) {
                            additionTag = additionMatcher.group(3).contains("TagSlotDisplay") ? additionMatcher.group(3) : RecipeLoader.fixResourceName(additionMatcher.group(3));
                        }
                    }
                    if (additionTag == null) {
                        additionTag = "air";
                    }
                    class_10302.class_10307 resultSlot = null;
                    Pattern trimPattern = Pattern.compile("result=SmithingTrimSlotDisplay\\[base=TagSlotDisplay\\[tag=TagKey\\[minecraft:item / minecraft:([\\w_]+)\\]\\],\\s*material=TagSlotDisplay\\[tag=TagKey\\[minecraft:item / minecraft:([\\w_]+)\\]\\],\\s*pattern=(?:Reference\\{ResourceKey\\[minecraft:trim_pattern / minecraft:([\\w_]+)\\]=ArmorTrimPattern\\[assetId=minecraft:([\\w_]+),\\s*description=translation\\{key='trim_pattern\\.minecraft\\.([\\w_]+)',\\s*args=\\[\\]\\},\\s*decal=false\\]\\}\\]|CompositeSlotDisplay\\[contents=\\[ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / minecraft:([\\w_]+)\\]=minecraft:[\\w_]+\\}\\]\\]\\])\\]");
                    Matcher trimResultMatcher = trimPattern.matcher(line);
                    if (trimResultMatcher.find()) {
                        String[] trimPatternRegistry;
                        class_6880 patternEntry;
                        String baseTag = trimResultMatcher.group(1);
                        String string = trimResultMatcher.group(2);
                        String patternId = trimResultMatcher.group(3);
                        class_6862 baseTagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"minecraft", (String)baseTag));
                        class_6862 class_68622 = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"minecraft", (String)string));
                        if (trimResultMatcher.group(3) != null && (patternEntry = (class_6880)(trimPatternRegistry = class_310.method_1551().field_1687.method_30349().method_30530(class_7924.field_42082)).method_10223(class_2960.method_60655((String)"minecraft", (String)patternId)).orElse(null)) != null) {
                            resultSlot = new class_10302.class_10310((class_10302)new class_10302.class_10311(baseTagKey), (class_10302)new class_10302.class_10311(class_68622), patternEntry);
                        }
                    }
                    if (resultSlot == null && (matcher = (stackPattern = Pattern.compile("result=StackSlotDisplay\\[stack=\\d+ minecraft:([\\w_]+)]")).matcher(line)).find()) {
                        String itemId = RecipeLoader.fixResourceName(matcher.group(1));
                        class_1792 item = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)itemId));
                        resultSlot = new class_10302.class_10307(new class_1799((class_1935)item));
                    }
                    if (resultSlot == null) {
                        return Optional.empty();
                    }
                    Matcher stationMatcher = Pattern.compile("craftingStation=ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / minecraft:(.*?)\\]=minecraft:(.*?)\\}\\]").matcher(line);
                    if (!stationMatcher.find()) {
                        return Optional.empty();
                    }
                    String string = RecipeLoader.fixResourceName(stationMatcher.group(2));
                    Matcher itemsMatcher = Pattern.compile("Crafting Requirements Items:(.*)").matcher(line);
                    if (!itemsMatcher.find()) {
                        return Optional.empty();
                    }
                    String itemsSection = itemsMatcher.group(1);
                    ArrayList<class_1856> arrayList = new ArrayList<class_1856>();
                    for (String rawItem : itemsSection.split(";")) {
                        ArrayList<class_1792> alternatives = new ArrayList<class_1792>();
                        for (String itemVariant : rawItem.split(",")) {
                            String path;
                            String[] splitItem;
                            String namespace;
                            class_2960 id;
                            class_1792 item;
                            String itemName = itemVariant.trim();
                            if (itemName.isBlank() || (item = (class_1792)class_7923.field_41178.method_63535(id = class_2960.method_60655((String)(namespace = (splitItem = itemName.split(":")).length == 2 ? splitItem[0] : "minecraft"), (String)(path = splitItem[splitItem.length - 1])))) == class_1802.field_8162) continue;
                            alternatives.add(item);
                        }
                        if (alternatives.isEmpty()) continue;
                        arrayList.add(class_1856.method_26964(alternatives.stream()));
                    }
                    class_10302 baseSlot = RecipeLoader.createSlotDisplay(baseItem, isBaseTag);
                    class_10302 additionSlot = RecipeLoader.createSlotDisplay(additionTag, false);
                    class_10302.class_10306 stationSlot = new class_10302.class_10306((class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)string)));
                    class_10298 recipeId = new class_10298(index);
                    class_10314 display = new class_10314((class_10302)new class_10302.class_10304(Arrays.asList(new class_10302.class_10306((class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)templateItem))))), baseSlot, additionSlot, (class_10302)resultSlot, (class_10302)stationSlot);
                    class_10297 entry = new class_10297(recipeId, (class_10295)display, group, category, Optional.of(arrayList));
                    return Optional.of(entry);
                }
                if (line.contains("FurnaceRecipeDisplay")) {
                    String fuelValue;
                    Matcher categoryMatcher4;
                    Matcher idMatcher = Pattern.compile("NetworkID:NetworkRecipeId\\[index=(\\d+)]").matcher(line);
                    int index = idMatcher.find() ? Integer.parseInt(idMatcher.group(1)) : -1;
                    OptionalInt group = OptionalInt.empty();
                    Matcher groupMatcher = Pattern.compile("Group:OptionalInt\\[(\\d+)]").matcher(line);
                    if (groupMatcher.find()) {
                        int groupValue = Integer.parseInt(groupMatcher.group(1));
                        group = OptionalInt.of(groupValue);
                    }
                    class_10355 category = (categoryMatcher4 = Pattern.compile("Category:Optional\\[ResourceKey\\[minecraft:recipe_book_category / minecraft:(\\w+)]]").matcher(line)).find() ? (class_10355)class_7923.field_54927.method_63535(class_2960.method_60655((String)"minecraft", (String)categoryMatcher4.group(1))) : class_314.field_1810;
                    class_10302.class_10311 ingredientSlot = null;
                    Matcher tagMatcher = Pattern.compile("ingredient=TagSlotDisplay\\[tag=TagKey\\[minecraft:item / minecraft:([\\w_]+)]]").matcher(line);
                    if (tagMatcher.find()) {
                        String tag = tagMatcher.group(1);
                        ingredientSlot = new class_10302.class_10311(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"minecraft", (String)tag)));
                    } else {
                        Matcher ingredientMatcher = Pattern.compile("ingredient=CompositeSlotDisplay\\[contents=\\[(.*?)\\]\\]").matcher(line);
                        if (!ingredientMatcher.find()) {
                            return Optional.empty();
                        }
                        String ingredientsSection = ingredientMatcher.group(1);
                        ArrayList<class_10302.class_10306> ingredientSlots = new ArrayList<class_10302.class_10306>();
                        Matcher itemMatcher = Pattern.compile("ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / ([^\\]=]+)]=").matcher(ingredientsSection);
                        while (itemMatcher.find()) {
                            String ingredientItem = RecipeLoader.fixResourceName(itemMatcher.group(1));
                            ingredientSlots.add(new class_10302.class_10306((class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)ingredientItem))));
                        }
                        ingredientSlot = new class_10302.class_10304(ingredientSlots);
                    }
                    Matcher fuelMatcher = Pattern.compile("fuel=<([^>]+)>").matcher(line);
                    String fuel = null;
                    if (fuelMatcher.find() && !"any fuel".equals(fuelValue = fuelMatcher.group(1))) {
                        fuel = RecipeLoader.fixResourceName(fuelValue);
                    }
                    class_10302.class_10303 fuelSlot = fuel != null ? new class_10302.class_10306((class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", fuel))) : class_10302.class_10303.field_54674;
                    Matcher resultMatcher = Pattern.compile("result=StackSlotDisplay\\[stack=(\\d+) minecraft:(\\w+)]").matcher(line);
                    if (!resultMatcher.find()) {
                        return Optional.empty();
                    }
                    int resultCount = Integer.parseInt(resultMatcher.group(1));
                    String resultItem = RecipeLoader.fixResourceName(resultMatcher.group(2));
                    Matcher stationMatcher = Pattern.compile("craftingStation=ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / ([^\\]]+)]").matcher(line);
                    if (!stationMatcher.find()) {
                        return Optional.empty();
                    }
                    String stationName = RecipeLoader.fixResourceName(stationMatcher.group(1));
                    Matcher durationMatcher = Pattern.compile("duration=(\\d+)").matcher(line);
                    int n = durationMatcher.find() ? Integer.parseInt(durationMatcher.group(1)) : 0;
                    Matcher experienceMatcher = Pattern.compile("experience=(\\d+\\.\\d+)").matcher(line);
                    float experience = experienceMatcher.find() ? Float.parseFloat(experienceMatcher.group(1)) : 0.0f;
                    Matcher matcher = Pattern.compile("Crafting Requirements Items:(.*)").matcher(line);
                    if (!matcher.find()) {
                        return Optional.empty();
                    }
                    String itemsSection = matcher.group(1);
                    ArrayList<class_1856> ingredients = new ArrayList<class_1856>();
                    for (String rawItem : itemsSection.split(";")) {
                        ArrayList<class_1792> alternatives = new ArrayList<class_1792>();
                        for (String itemVariant : rawItem.split(",")) {
                            String path;
                            String[] splitItem;
                            String namespace;
                            class_2960 id;
                            class_1792 item;
                            String itemName = itemVariant.trim();
                            if (itemName.isBlank() || (item = (class_1792)class_7923.field_41178.method_63535(id = class_2960.method_60655((String)(namespace = (splitItem = itemName.split(":")).length == 2 ? splitItem[0] : "minecraft"), (String)(path = splitItem[splitItem.length - 1])))) == class_1802.field_8162) continue;
                            alternatives.add(item);
                        }
                        if (alternatives.isEmpty()) continue;
                        ingredients.add(class_1856.method_26964(alternatives.stream()));
                    }
                    class_10302.class_10307 result = new class_10302.class_10307(new class_1799((class_1935)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)resultItem)), resultCount));
                    class_10302.class_10306 station = new class_10302.class_10306((class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)stationName)));
                    class_10298 recipeId = new class_10298(index);
                    class_10294 display = new class_10294((class_10302)ingredientSlot, (class_10302)fuelSlot, (class_10302)result, (class_10302)station, n, experience);
                    class_10297 entry = new class_10297(recipeId, (class_10295)display, group, category, Optional.of(ingredients));
                    return Optional.of(entry);
                }
                if (line.contains("ShapelessCraftingRecipeDisplay")) {
                    void var18_106;
                    Matcher categoryMatcher5;
                    Matcher idMatcher = Pattern.compile("NetworkID:NetworkRecipeId\\[index\\s*=\\s*(\\d+)\\]").matcher(line);
                    int index = idMatcher.find() ? Integer.parseInt(idMatcher.group(1)) : -1;
                    OptionalInt group = OptionalInt.empty();
                    Matcher groupMatcher = Pattern.compile("Group:OptionalInt\\[(\\d+)]").matcher(line);
                    if (groupMatcher.find()) {
                        int groupValue = Integer.parseInt(groupMatcher.group(1));
                        group = OptionalInt.of(groupValue);
                    }
                    class_10355 category = (categoryMatcher5 = Pattern.compile("Category:Optional\\[ResourceKey\\[minecraft:recipe_book_category / minecraft:(\\w+)]]").matcher(line)).find() ? (class_10355)class_7923.field_54927.method_63535(class_2960.method_60655((String)"minecraft", (String)categoryMatcher5.group(1))) : class_314.field_1810;
                    Matcher resultMatcher = Pattern.compile("result=StackSlotDisplay\\[stack=(\\d+) minecraft:(\\w+)]").matcher(line);
                    String resultItem = null;
                    int resultCount = 1;
                    if (!resultMatcher.find() && !(resultMatcher = Pattern.compile("result=ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / minecraft:(\\w+)]=minecraft:(\\w+)}\\]").matcher(line)).find()) {
                        return Optional.empty();
                    }
                    if (resultMatcher.group(1) != null && resultMatcher.group(2) != null) {
                        try {
                            resultCount = Integer.parseInt(resultMatcher.group(1));
                        }
                        catch (NumberFormatException e) {
                            resultCount = 1;
                        }
                        resultItem = RecipeLoader.fixResourceName(resultMatcher.group(2));
                    } else if (resultMatcher.group(2) != null) {
                        resultItem = RecipeLoader.fixResourceName(resultMatcher.group(2));
                        resultCount = 1;
                    }
                    Matcher stationMatcher = Pattern.compile("craftingStation=ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / ([^\\]]+)]").matcher(line);
                    if (!stationMatcher.find()) {
                        return Optional.empty();
                    }
                    String stationName = RecipeLoader.fixResourceName(stationMatcher.group(1));
                    Matcher ingredientsMatcher = Pattern.compile("ingredients=\\[(.*)]").matcher(line);
                    if (!ingredientsMatcher.find()) {
                        return Optional.empty();
                    }
                    String ingredientsSection = ingredientsMatcher.group(1);
                    ArrayList<Object> slots = new ArrayList<Object>();
                    for (String rawSlot : RecipeLoader.splitTopLevelSlotDisplays(ingredientsSection)) {
                        Matcher itemMatcher;
                        if ((rawSlot = rawSlot.trim()).startsWith("<empty")) {
                            slots.add(class_10302.class_10305.field_54681);
                            continue;
                        }
                        if (rawSlot.startsWith("TagSlotDisplay")) {
                            String tagName = rawSlot.substring(rawSlot.indexOf("minecraft:") + "minecraft:".length(), rawSlot.indexOf("]")).trim();
                            String[] stringArray = tagName.split(":");
                            String lastWord = stringArray[stringArray.length - 1];
                            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"minecraft", (String)lastWord));
                            slots.add(new class_10302.class_10311(tagKey));
                            continue;
                        }
                        if (rawSlot.startsWith("CompositeSlotDisplay")) {
                            List<String> innerItems = RecipeLoader.extractItemSlotDisplays(rawSlot);
                            ArrayList<Object> arrayList = new ArrayList<Object>();
                            for (String nested : innerItems) {
                                Matcher matcher;
                                if ((nested = nested.trim()).startsWith("WithRemainderSlotDisplay")) {
                                    Matcher matcher2 = Pattern.compile("input=ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / ([^\\]]+)]").matcher(nested);
                                    Matcher remainderMatcher = Pattern.compile("remainder=StackSlotDisplay\\[stack=(\\d+) minecraft:([a-z0-9_]+)]").matcher(nested);
                                    if (!matcher2.find()) continue;
                                    String inputItemName = RecipeLoader.fixResourceName(matcher2.group(1));
                                    class_1792 inputItem = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)inputItemName));
                                    class_10302.class_10306 input = new class_10302.class_10306(inputItem);
                                    if (remainderMatcher.find()) {
                                        int count = Integer.parseInt(remainderMatcher.group(1));
                                        String remainderItemName = RecipeLoader.fixResourceName(remainderMatcher.group(2));
                                        class_1792 remainderItem = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)remainderItemName));
                                        class_10302.class_10307 remainder = new class_10302.class_10307(new class_1799((class_1935)remainderItem, count));
                                        arrayList.add(new class_10302.class_10362((class_10302)input, (class_10302)remainder));
                                        continue;
                                    }
                                    arrayList.add(input);
                                    continue;
                                }
                                if (!nested.startsWith("ItemSlotDisplay") || !(matcher = Pattern.compile("ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / ([^\\]]+)]").matcher(nested)).find()) continue;
                                String itemName = RecipeLoader.fixResourceName(matcher.group(1));
                                class_1792 item = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)itemName));
                                arrayList.add(new class_10302.class_10306(item));
                            }
                            slots.add(new class_10302.class_10304(arrayList));
                            continue;
                        }
                        if (!rawSlot.startsWith("ItemSlotDisplay") || !(itemMatcher = Pattern.compile("ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / ([^\\]]+)]").matcher(rawSlot)).find()) continue;
                        String string = RecipeLoader.fixResourceName(itemMatcher.group(1));
                        class_1792 item = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)string));
                        slots.add(new class_10302.class_10306(item));
                    }
                    Matcher itemsMatcher = Pattern.compile("Crafting Requirements Items:(.*)").matcher(line);
                    if (!itemsMatcher.find()) {
                        return Optional.empty();
                    }
                    String itemsSection = itemsMatcher.group(1);
                    ArrayList<class_1856> ingredients = new ArrayList<class_1856>();
                    for (String string : itemsSection.split(";")) {
                        ArrayList<class_1792> alternatives = new ArrayList<class_1792>();
                        for (String itemVariant : string.split(",")) {
                            String path;
                            String[] splitItem;
                            String namespace;
                            class_2960 id;
                            class_1792 item;
                            String itemName = itemVariant.trim();
                            if (itemName.isBlank() || (item = (class_1792)class_7923.field_41178.method_63535(id = class_2960.method_60655((String)(namespace = (splitItem = itemName.split(":")).length == 2 ? splitItem[0] : "minecraft"), (String)(path = splitItem[splitItem.length - 1])))) == class_1802.field_8162) continue;
                            alternatives.add(item);
                        }
                        if (alternatives.isEmpty()) continue;
                        ingredients.add(class_1856.method_26964(alternatives.stream()));
                    }
                    if (line.contains("result=StackSlotDisplay")) {
                        class_10302.class_10307 class_103072 = new class_10302.class_10307(new class_1799((class_1935)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)resultItem)), resultCount));
                    } else {
                        class_10302.class_10306 class_103062 = new class_10302.class_10306((class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)resultItem)));
                    }
                    class_10302.class_10306 station = new class_10302.class_10306((class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)stationName)));
                    class_10298 recipeId = new class_10298(index);
                    class_10301 class_103012 = new class_10301(slots, (class_10302)var18_106, (class_10302)station);
                    class_10297 entry = new class_10297(recipeId, (class_10295)class_103012, group, category, Optional.of(ingredients));
                    return Optional.of(entry);
                }
                if (!line.contains("ShapedCraftingRecipeDisplay")) break block88;
                Matcher idMatcher = Pattern.compile("NetworkID:NetworkRecipeId\\[index=(\\d+)]").matcher(line);
                int index = idMatcher.find() ? Integer.parseInt(idMatcher.group(1)) : -1;
                OptionalInt group = OptionalInt.empty();
                Matcher groupMatcher = Pattern.compile("Group:OptionalInt\\[(\\d+)]").matcher(line);
                if (groupMatcher.find()) {
                    group = OptionalInt.of(Integer.parseInt(groupMatcher.group(1)));
                }
                class_10355 category = (categoryMatcher = Pattern.compile("Category:Optional\\[ResourceKey\\[minecraft:recipe_book_category / minecraft:(\\w+)]]").matcher(line)).find() ? (class_10355)class_7923.field_54927.method_63535(class_2960.method_60655((String)"minecraft", (String)categoryMatcher.group(1))) : class_314.field_1810;
                Matcher dimMatcher = Pattern.compile("ShapedCraftingRecipeDisplay\\[width=(\\d+), height=(\\d+)").matcher(line);
                if (!dimMatcher.find()) {
                    return Optional.empty();
                }
                int width = Integer.parseInt(dimMatcher.group(1));
                int height = Integer.parseInt(dimMatcher.group(2));
                Matcher resultMatcher = Pattern.compile("result=StackSlotDisplay\\[stack=(\\d+) minecraft:(\\w+)]").matcher(line);
                String resultItem = null;
                int resultCount = 1;
                if (!resultMatcher.find() && !(resultMatcher = Pattern.compile("result=ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / minecraft:(\\w+)]=minecraft:(\\w+)}\\]").matcher(line)).find()) {
                    return Optional.empty();
                }
                if (resultMatcher.group(1) != null && resultMatcher.group(2) != null) {
                    try {
                        resultCount = Integer.parseInt(resultMatcher.group(1));
                    }
                    catch (NumberFormatException e) {
                        resultCount = 1;
                    }
                    resultItem = RecipeLoader.fixResourceName(resultMatcher.group(2));
                } else if (resultMatcher.group(2) != null) {
                    resultItem = RecipeLoader.fixResourceName(resultMatcher.group(2));
                    resultCount = 1;
                }
                Matcher stationMatcher = Pattern.compile("craftingStation=ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / ([^\\]]+)]").matcher(line);
                if (!stationMatcher.find()) {
                    return Optional.empty();
                }
                String stationName = RecipeLoader.fixResourceName(stationMatcher.group(1));
                Matcher ingredientsMatcher = Pattern.compile("ingredients=\\[(.*)]").matcher(line);
                if (!ingredientsMatcher.find()) {
                    return Optional.empty();
                }
                String ingredientsSection = ingredientsMatcher.group(1);
                List<class_10302.class_10311> slots = new ArrayList<Object>();
                for (String rawSlot : RecipeLoader.splitTopLevelSlotDisplays(ingredientsSection)) {
                    Matcher itemMatcher;
                    if ((rawSlot = rawSlot.trim()).startsWith("<empty")) {
                        slots.add((class_10302.class_10311)class_10302.class_10305.field_54681);
                        continue;
                    }
                    if (rawSlot.startsWith("TagSlotDisplay")) {
                        String tagName = rawSlot.substring(rawSlot.indexOf("minecraft:") + "minecraft:".length(), rawSlot.indexOf("]")).trim();
                        String[] stringArray = tagName.split(":");
                        String lastWord = stringArray[stringArray.length - 1];
                        class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"minecraft", (String)lastWord));
                        slots.add(new class_10302.class_10311(tagKey));
                        continue;
                    }
                    if (rawSlot.startsWith("CompositeSlotDisplay")) {
                        List<String> innerItems = RecipeLoader.extractItemSlotDisplays(rawSlot);
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        for (String nested : innerItems) {
                            Matcher itemMatcher3;
                            if ((nested = nested.trim()).startsWith("WithRemainderSlotDisplay")) {
                                Matcher inputMatcher = Pattern.compile("input=ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / ([^\\]]+)]").matcher(nested);
                                Matcher remainderMatcher = Pattern.compile("remainder=StackSlotDisplay\\[stack=(\\d+) minecraft:([a-z0-9_]+)]").matcher(nested);
                                if (!inputMatcher.find()) continue;
                                String inputItemName = RecipeLoader.fixResourceName(inputMatcher.group(1));
                                class_1792 inputItem = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)inputItemName));
                                class_10302.class_10306 input = new class_10302.class_10306(inputItem);
                                if (remainderMatcher.find()) {
                                    int count = Integer.parseInt(remainderMatcher.group(1));
                                    String remainderItemName = RecipeLoader.fixResourceName(remainderMatcher.group(2));
                                    class_1792 remainderItem = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)remainderItemName));
                                    class_10302.class_10307 remainder = new class_10302.class_10307(new class_1799((class_1935)remainderItem, count));
                                    arrayList.add(new class_10302.class_10362((class_10302)input, (class_10302)remainder));
                                    continue;
                                }
                                arrayList.add(input);
                                continue;
                            }
                            if (!nested.startsWith("ItemSlotDisplay") || !(itemMatcher3 = Pattern.compile("ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / ([^\\]]+)]").matcher(nested)).find()) continue;
                            String itemName = RecipeLoader.fixResourceName(itemMatcher3.group(1));
                            class_1792 item = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)itemName));
                            arrayList.add(new class_10302.class_10306(item));
                        }
                        slots.add((class_10302.class_10311)new class_10302.class_10304(arrayList));
                        continue;
                    }
                    if (!rawSlot.startsWith("ItemSlotDisplay") || !(itemMatcher = Pattern.compile("ItemSlotDisplay\\[item=Reference\\{ResourceKey\\[minecraft:item / ([^\\]]+)]").matcher(rawSlot)).find()) continue;
                    String string = RecipeLoader.fixResourceName(itemMatcher.group(1));
                    class_1792 item = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)string));
                    slots.add((class_10302.class_10311)new class_10302.class_10306(item));
                }
                Matcher matcher = Pattern.compile("Crafting Requirements Items:(.*)").matcher(line);
                if (!matcher.find()) {
                    return Optional.empty();
                }
                String itemsSection = matcher.group(1);
                ArrayList<class_1856> ingredients = new ArrayList<class_1856>();
                for (String rawItem : itemsSection.split(";")) {
                    ArrayList<class_1792> alternatives = new ArrayList<class_1792>();
                    for (String itemVariant : rawItem.split(",")) {
                        String itemName = itemVariant.trim();
                        if (itemName.isBlank()) continue;
                        String[] splitItem = itemName.split(":");
                        String namespace = splitItem.length == 2 ? splitItem[0] : "minecraft";
                        String path = splitItem[splitItem.length - 1];
                        try {
                            class_2960 id = class_2960.method_60655((String)namespace, (String)path);
                            class_1792 item = (class_1792)class_7923.field_41178.method_63535(id);
                            if (item == class_1802.field_8162) continue;
                            alternatives.add(item);
                        }
                        catch (Exception e) {
                            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 Identifier! line: " + line + " | namespace: " + namespace + " | path: " + path);
                            e.printStackTrace();
                        }
                    }
                    if (alternatives.isEmpty()) continue;
                    ingredients.add(class_1856.method_26964(alternatives.stream()));
                }
                int n = width * height;
                while (slots.size() < n) {
                    slots.add((class_10302.class_10311)new class_10302.class_10304(List.of()));
                }
                if (slots.size() > n) {
                    slots = slots.subList(0, n);
                }
                class_10302.class_10307 result = new class_10302.class_10307(new class_1799((class_1935)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)resultItem)), resultCount));
                class_10302.class_10306 station = new class_10302.class_10306((class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)stationName)));
                class_10298 recipeId = new class_10298(index);
                class_10300 display = new class_10300(width, height, slots, (class_10302)result, (class_10302)station);
                class_10297 entry = new class_10297(recipeId, (class_10295)display, group, category, Optional.of(ingredients));
                return Optional.of(entry);
            }
            catch (Exception e) {
                System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0435 \u0441\u0442\u0440\u043e\u043a\u0438: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return Optional.empty();
    }

    private static List<String> extractItemSlotDisplays(String rawSlot) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher contentsMatcher = Pattern.compile("contents=\\[(.*)]\\]?").matcher(rawSlot);
        if (!contentsMatcher.find()) {
            return result;
        }
        String contents = contentsMatcher.group(1).trim();
        int depth = 0;
        StringBuilder current = new StringBuilder();
        for (int i = 0; i < contents.length(); ++i) {
            char c = contents.charAt(i);
            if (c == '[') {
                ++depth;
            }
            if (c == ']') {
                --depth;
            }
            current.append(c);
            if ((c != ',' || depth != 0) && i != contents.length() - 1) continue;
            String part = current.toString().trim();
            if (!part.isEmpty() && !part.equals(",")) {
                result.add(part.replaceAll(",$", ""));
            }
            current.setLength(0);
        }
        return result;
    }

    private static List<String> splitTopLevelSlotDisplays(String input) {
        ArrayList<String> result = new ArrayList<String>();
        int bracketLevel = 0;
        StringBuilder current = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '[') {
                ++bracketLevel;
            } else if (c == ']') {
                --bracketLevel;
            }
            if (c == ',' && bracketLevel == 0) {
                result.add(current.toString().trim());
                current.setLength(0);
                continue;
            }
            current.append(c);
        }
        if (!current.toString().isBlank()) {
            result.add(current.toString().trim());
        }
        return result;
    }

    private static class_10302 createSlotDisplay(String itemOrTag, boolean isBase) {
        if (itemOrTag.equals("air")) {
            return new class_10302.class_10306(class_1802.field_8162);
        }
        if (isBase) {
            return new class_10302.class_10304(Arrays.asList(new class_10302.class_10306((class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)itemOrTag)))));
        }
        return new class_10302.class_10311(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"minecraft", (String)itemOrTag)));
    }

    static void sendToClient(class_10297 entry) {
        class_10352 context;
        class_10302 resultSlot;
        List stacks;
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            class_299 clientRecipeBook = client.field_1724.method_3130();
            class_634 handler = client.method_1562();
            class_638 world = client.field_1687;
            clientRecipeBook.method_64849(entry);
            clientRecipeBook.method_64853();
            handler.method_60347().method_60352(clientRecipeBook, (class_1937)world);
            class_437 var3 = client.field_1755;
            if (var3 instanceof class_518) {
                class_518 recipeBookProvider = (class_518)var3;
                recipeBookProvider.method_16891();
            }
        }
        if ((stacks = (resultSlot = entry.comp_3263().comp_3258()).method_64738(context = class_10363.method_65008((class_1937)((class_1937)Objects.requireNonNull(client.field_1687))))).isEmpty()) {
            System.err.println("Warning: Empty stacks for resultSlot in recipe " + String.valueOf(entry));
            return;
        }
        class_1799 stack = (class_1799)stacks.get(0);
        if (((class_1799)entry.comp_3263().comp_3259().method_64738(context).getFirst()).method_7909() == class_1802.field_8465) {
            JEBClient.existingResultItems.add(stack.method_7909());
        }
    }
}

