/*
 * Decompiled with CFR 0.152.
 */
package jeb.client;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import jeb.client.JEBClient;
import net.minecraft.class_10287;
import net.minecraft.class_10295;
import net.minecraft.class_10297;
import net.minecraft.class_10298;
import net.minecraft.class_10301;
import net.minecraft.class_10302;
import net.minecraft.class_10331;
import net.minecraft.class_10352;
import net.minecraft.class_10355;
import net.minecraft.class_10363;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_299;
import net.minecraft.class_310;
import net.minecraft.class_314;
import net.minecraft.class_516;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class RecipeIndex {
    public final Map<class_10355, Map<String, List<class_516>>> byResult = new HashMap<class_10355, Map<String, List<class_516>>>();
    public final Map<class_10355, Map<String, List<class_516>>> byMod = new HashMap<class_10355, Map<String, List<class_516>>>();
    public final Map<class_10355, Map<String, List<class_516>>> byIngredientWord = new HashMap<class_10355, Map<String, List<class_516>>>();
    public final Map<class_10355, Map<String, List<class_516>>> byTooltipWord = new HashMap<class_10355, Map<String, List<class_516>>>();
    public final Map<class_10355, Set<class_516>> allCollections = new HashMap<class_10355, Set<class_516>>();
    public static final Map<class_10355, Map<class_1792, class_516>> GLOBAL_COLLECTIONS_BY_RESULT = new HashMap<class_10355, Map<class_1792, class_516>>();
    public static final RecipeIndex GLOBAL_RECIPE_INDEX = new RecipeIndex();
    public static boolean jebIndexReady = false;
    public static List<IndexedItem> ITEM_INDEX = new ArrayList<IndexedItem>();

    public static void buildRecipeIndex() {
        long startTime = System.currentTimeMillis();
        JEBClient.LOGGER.info("[JEB] buildRecipeIndex started at {}", (Object)new Date(startTime));
        jebIndexReady = false;
        class_310 client = class_310.method_1551();
        class_299 book = client.field_1724.method_3130();
        RecipeIndex.GLOBAL_RECIPE_INDEX.byResult.clear();
        RecipeIndex.GLOBAL_RECIPE_INDEX.byMod.clear();
        RecipeIndex.GLOBAL_RECIPE_INDEX.byIngredientWord.clear();
        RecipeIndex.GLOBAL_RECIPE_INDEX.byTooltipWord.clear();
        RecipeIndex.GLOBAL_RECIPE_INDEX.allCollections.clear();
        GLOBAL_COLLECTIONS_BY_RESULT.clear();
        class_10352 context = class_10363.method_65008((class_1937)((class_1937)Objects.requireNonNull(client.field_1687)));
        ArrayList<class_10355> allCategories = new ArrayList<class_10355>();
        for (Field field : class_314.class.getFields()) {
            if (field.getType() != class_10355.class) continue;
            try {
                class_10355 category = (class_10355)field.get(null);
                allCategories.add(category);
            }
            catch (Exception category) {
                // empty catch block
            }
        }
        int totalIndexedRecipes = 0;
        for (class_10355 category : allCategories) {
            List collections = book.method_1396((class_10287)category);
            if (collections.isEmpty()) continue;
            Map collectionsByResult = GLOBAL_COLLECTIONS_BY_RESULT.computeIfAbsent(category, k -> new HashMap());
            LinkedHashSet<class_516> categoryCollections = new LinkedHashSet<class_516>();
            HashMap<String, List> resultIndex = new HashMap<String, List>();
            HashMap<String, List> modIndex = new HashMap<String, List>();
            HashMap<String, List> ingredientIndex = new HashMap<String, List>();
            HashMap<String, List> tooltipIndex = new HashMap<String, List>();
            for (class_516 collection : collections) {
                List entries = collection.method_2650();
                for (class_10297 recipe : entries) {
                    Optional opt;
                    ++totalIndexedRecipes;
                    class_1799 result = recipe.comp_3263().comp_3258().method_64742(context);
                    if (result == null || result.method_7960()) continue;
                    class_1792 resultItem = result.method_7909();
                    class_516 realCollection = (class_516)collectionsByResult.get(resultItem);
                    if (realCollection == null) {
                        realCollection = new class_516(new ArrayList());
                        collectionsByResult.put(resultItem, realCollection);
                        categoryCollections.add(realCollection);
                    }
                    if (!realCollection.method_2650().contains(recipe)) {
                        realCollection.method_2650().add(recipe);
                    }
                    if ((opt = recipe.comp_3266()).isPresent()) {
                        for (class_1856 ingredient : (List)opt.get()) {
                            for (class_1799 stack : ingredient.method_64673().method_64738(context)) {
                                String ingredientId = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString().toLowerCase(Locale.ROOT);
                                ingredientIndex.computeIfAbsent(ingredientId, k -> new ArrayList()).add(realCollection);
                            }
                        }
                    }
                    String mod = class_7923.field_41178.method_10221((Object)resultItem).method_12836().toLowerCase(Locale.ROOT);
                    for (int i = 0; i < mod.length(); ++i) {
                        for (int j = i + 1; j <= mod.length(); ++j) {
                            String substr = mod.substring(i, j);
                            if (substr.isEmpty()) continue;
                            modIndex.computeIfAbsent(substr, k -> new ArrayList()).add(realCollection);
                        }
                    }
                    String resultId = class_7923.field_41178.method_10221((Object)resultItem).toString().toLowerCase(Locale.ROOT);
                    String name = result.method_63693().getString().toLowerCase(Locale.ROOT).replaceAll("[\\[\\]\u00ab\u00bb\"]", "");
                    for (String source : List.of(resultId, name)) {
                        for (int i = 0; i < source.length(); ++i) {
                            for (int j = i + 1; j <= source.length(); ++j) {
                                String substr = source.substring(i, j);
                                if (substr.isEmpty()) continue;
                                resultIndex.computeIfAbsent(substr, k -> new ArrayList()).add(realCollection);
                            }
                        }
                    }
                    ArrayList<String> tooltipLines = new ArrayList<String>();
                    try {
                        class_5455 lookup = client.field_1687.method_30349();
                        class_1792.class_9635 tooltipContext = class_1792.class_9635.method_59530((class_7225.class_7874)lookup);
                        class_1836.class_1837 tooltipType = class_1836.class_1837.field_41070;
                        List tooltip = result.method_7950(tooltipContext, (class_1657)client.field_1724, (class_1836)tooltipType);
                        for (class_2561 line : tooltip) {
                            String clean = class_124.method_539((String)line.getString()).toLowerCase(Locale.ROOT).trim();
                            tooltipLines.add(clean);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    for (String tooltipLine : tooltipLines) {
                        String[] words;
                        for (String word : words = tooltipLine.split("[\\s,;.:!\\-]+")) {
                            if (word.length() < 3) continue;
                            for (int i = 0; i <= word.length() - 3; ++i) {
                                for (int j = i + 3; j <= word.length(); ++j) {
                                    String substr = word.substring(i, j);
                                    if (substr.isEmpty()) continue;
                                    tooltipIndex.computeIfAbsent(substr, k -> new ArrayList()).add(realCollection);
                                }
                            }
                        }
                    }
                }
            }
            RecipeIndex.GLOBAL_RECIPE_INDEX.allCollections.put(category, categoryCollections);
            RecipeIndex.GLOBAL_RECIPE_INDEX.byResult.put(category, resultIndex);
            RecipeIndex.GLOBAL_RECIPE_INDEX.byMod.put(category, modIndex);
            RecipeIndex.GLOBAL_RECIPE_INDEX.byIngredientWord.put(category, ingredientIndex);
            RecipeIndex.GLOBAL_RECIPE_INDEX.byTooltipWord.put(category, tooltipIndex);
        }
        jebIndexReady = true;
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        JEBClient.LOGGER.info("[JEB] buildRecipeIndex done at {} ({} ms), total indexed recipes: {}", new Object[]{new Date(endTime), duration, totalIndexedRecipes});
    }

    public static List<class_516> fastSearch(List<class_10355> categories, String query, String modName, boolean searchIngredients) {
        if (!jebIndexReady) {
            return List.of();
        }
        query = query == null ? "" : query.toLowerCase(Locale.ROOT).trim();
        modName = modName == null ? "" : modName.toLowerCase(Locale.ROOT).trim();
        LinkedHashSet result = new LinkedHashSet();
        for (class_10355 category : categories) {
            Map modIndex = RecipeIndex.GLOBAL_RECIPE_INDEX.byMod.getOrDefault(category, Map.of());
            Map ingredientIndex = RecipeIndex.GLOBAL_RECIPE_INDEX.byIngredientWord.getOrDefault(category, Map.of());
            Set all = RecipeIndex.GLOBAL_RECIPE_INDEX.allCollections.getOrDefault(category, Set.of());
            Map resultIndex = RecipeIndex.GLOBAL_RECIPE_INDEX.byResult.getOrDefault(category, Map.of());
            Map tooltipIndex = RecipeIndex.GLOBAL_RECIPE_INDEX.byTooltipWord.getOrDefault(category, Map.of());
            if (modName.isEmpty() && query.isEmpty()) {
                result.addAll(all);
                continue;
            }
            if (!modName.isEmpty()) {
                List modCollections = modIndex.getOrDefault(modName, List.of());
                if (query.isEmpty()) {
                    result.addAll(modCollections);
                    continue;
                }
                for (String word : query.split("[\\s:_\\-]+")) {
                    List byWord = resultIndex.getOrDefault(word, List.of());
                    for (class_516 rc : byWord) {
                        if (!modCollections.contains(rc)) continue;
                        result.add(rc);
                    }
                }
                continue;
            }
            if (searchIngredients && !query.isEmpty()) {
                List byIng = ingredientIndex.getOrDefault(query, List.of());
                result.addAll(byIng);
                continue;
            }
            if (query.isEmpty() || searchIngredients) continue;
            List byResult = resultIndex.getOrDefault(query, List.of());
            result.addAll(byResult);
            List byTooltip = tooltipIndex.getOrDefault(query, List.of());
            result.addAll(byTooltip);
        }
        return new ArrayList<class_516>(result);
    }

    public static List<class_516> fastSearch(Object categoryOrType, String query, String modName, boolean searchIngredients) {
        List<Object> categories = categoryOrType instanceof List ? (List<class_10355>)categoryOrType : (categoryOrType instanceof class_10331 ? ((class_10331)categoryOrType).method_64888() : (categoryOrType instanceof class_10355 ? List.of((class_10355)categoryOrType) : List.of()));
        return RecipeIndex.fastSearch(categories, query, modName, searchIngredients);
    }

    public static List<class_516> generateCustomRecipeList(String filter) {
        ArrayList<class_516> list = new ArrayList<class_516>();
        class_310 client = class_310.method_1551();
        filter = filter.trim();
        String _modName = null;
        String _query = "";
        if (filter.startsWith("@")) {
            String[] parts = filter.substring(1).split(" ", 2);
            _modName = parts[0].toLowerCase(Locale.ROOT);
            if (parts.length > 1) {
                _query = parts[1].toLowerCase(Locale.ROOT);
            }
        } else {
            _query = filter.toLowerCase(Locale.ROOT);
        }
        String modName = _modName;
        String query = _query;
        ITEM_INDEX.stream().filter(idx -> !(modName != null && !idx.mod.contains(modName) || !query.isEmpty() && !idx.name.contains(query) && !idx.id.contains(query) && !idx.key.contains(query) && !idx.tooltip.stream().anyMatch(line -> line.contains(query)))).forEach(idx -> {
            class_516 dummy = RecipeIndex.createDummyResultCollection(idx.item);
            list.add(dummy);
        });
        return list;
    }

    private static class_516 createDummyResultCollection(class_1792 item) {
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        class_10298 recipeId = new class_10298(9999);
        List<class_10302.class_10311> slots = List.of(new class_10302.class_10311(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)id)));
        class_10302.class_10307 resultSlot = new class_10302.class_10307(new class_1799((class_1935)item, 1));
        class_10302.class_10306 stationSlot = new class_10302.class_10306((class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)"crafting_table")));
        List<class_1856> ingredients = List.of(class_1856.method_8091((class_1935[])new class_1935[]{item}));
        class_10301 display = new class_10301(slots, (class_10302)resultSlot, (class_10302)stationSlot);
        OptionalInt group = OptionalInt.empty();
        class_10355 category = class_314.field_1810;
        class_10297 entry = new class_10297(recipeId, (class_10295)display, group, category, Optional.of(ingredients));
        return new class_516(List.of(entry));
    }

    public static void fillItemIndex() {
        class_310 client = class_310.method_1551();
        ITEM_INDEX.clear();
        for (class_1792 item : JEBClient.nonexistingResultItems) {
            if (item == class_1802.field_8162) continue;
            String id = item.toString().toLowerCase(Locale.ROOT);
            String name = item.method_63680().getString().toLowerCase(Locale.ROOT);
            String mod = class_7923.field_41178.method_10221((Object)item).method_12836().toLowerCase(Locale.ROOT);
            String key = class_1074.method_4662((String)item.method_7876(), (Object[])new Object[0]).toLowerCase(Locale.ROOT);
            ArrayList<String> tooltipLines = new ArrayList<String>(List.of());
            if (client.field_1687 != null) {
                try {
                    class_5455 lookup = client.field_1687.method_30349();
                    class_1792.class_9635 tooltipContext = class_1792.class_9635.method_59530((class_7225.class_7874)lookup);
                    class_1836.class_1837 tooltipType = class_1836.class_1837.field_41070;
                    List tooltip = item.method_7854().method_7950(tooltipContext, (class_1657)client.field_1724, (class_1836)tooltipType);
                    for (class_2561 line : tooltip) {
                        String clean = class_124.method_539((String)line.getString()).toLowerCase(Locale.ROOT).trim();
                        tooltipLines.add(clean);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ITEM_INDEX.add(new IndexedItem(item, id, name, mod, key, tooltipLines));
        }
    }

    public static boolean recipeIdExistsInIndex(class_10355 category, class_10297 recipeEntry) {
        Map<String, List<class_516>> resultIndex = RecipeIndex.GLOBAL_RECIPE_INDEX.byResult.get(category);
        if (resultIndex == null) {
            return false;
        }
        class_10352 context = class_10363.method_65008((class_1937)((class_1937)Objects.requireNonNull(class_310.method_1551().field_1687)));
        class_1799 result = recipeEntry.comp_3263().comp_3258().method_64742(context);
        if (result == null || result.method_7960()) {
            return false;
        }
        String resultId = class_7923.field_41178.method_10221((Object)result.method_7909()).toString().toLowerCase(Locale.ROOT);
        List<class_516> collections = resultIndex.get(resultId);
        if (collections == null) {
            return false;
        }
        String incomingId = recipeEntry.comp_3262().toString();
        for (class_516 collection : collections) {
            for (class_10297 r : collection.method_2650()) {
                if (!r.comp_3262().toString().equals(incomingId)) continue;
                return true;
            }
        }
        return false;
    }

    public static void updateIndexesWithRecipe(class_10355 category, class_516 collection, class_10297 recipeEntry) {
        RecipeIndex.GLOBAL_RECIPE_INDEX.allCollections.computeIfAbsent(category, k -> new LinkedHashSet()).add(collection);
        class_10352 context = class_10363.method_65008((class_1937)((class_1937)Objects.requireNonNull(class_310.method_1551().field_1687)));
        class_1799 result = recipeEntry.comp_3263().comp_3258().method_64742(context);
        if (result == null || result.method_7960()) {
            return;
        }
        class_1792 resultItem = result.method_7909();
        String mod = class_7923.field_41178.method_10221((Object)resultItem).method_12836().toLowerCase(Locale.ROOT);
        Map modIndex = RecipeIndex.GLOBAL_RECIPE_INDEX.byMod.computeIfAbsent(category, k -> new HashMap());
        for (int i = 0; i < mod.length(); ++i) {
            for (int j = i + 1; j <= mod.length(); ++j) {
                Object list;
                String substr = mod.substring(i, j);
                if (substr.isEmpty() || (list = modIndex.computeIfAbsent(substr, k -> new ArrayList())).contains(collection)) continue;
                list.add(collection);
            }
        }
        String resultId = class_7923.field_41178.method_10221((Object)resultItem).toString().toLowerCase(Locale.ROOT);
        String name = result.method_63693().getString().toLowerCase(Locale.ROOT).replaceAll("[\\[\\]\u00ab\u00bb\"]", "");
        Map resultIndex = RecipeIndex.GLOBAL_RECIPE_INDEX.byResult.computeIfAbsent(category, k -> new HashMap());
        for (String source : List.of(resultId, name)) {
            for (int i = 0; i < source.length(); ++i) {
                for (int j = i + 1; j <= source.length(); ++j) {
                    List list;
                    String substr = source.substring(i, j);
                    if (substr.isEmpty() || (list = resultIndex.computeIfAbsent(substr, k -> new ArrayList())).contains(collection)) continue;
                    list.add(collection);
                }
            }
        }
        Map ingredientIndex = RecipeIndex.GLOBAL_RECIPE_INDEX.byIngredientWord.computeIfAbsent(category, k -> new HashMap());
        Optional opt = recipeEntry.comp_3266();
        if (opt.isPresent()) {
            for (class_1856 ingredient : (List)opt.get()) {
                for (class_1799 stack : ingredient.method_64673().method_64738(context)) {
                    String ingredientId = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString().toLowerCase(Locale.ROOT);
                    List list = ingredientIndex.computeIfAbsent(ingredientId, k -> new ArrayList());
                    if (list.contains(collection)) continue;
                    list.add(collection);
                }
            }
        }
        Map tooltipIndex = RecipeIndex.GLOBAL_RECIPE_INDEX.byTooltipWord.computeIfAbsent(category, k -> new HashMap());
        class_310 client = class_310.method_1551();
        ArrayList<String> tooltipLines = new ArrayList<String>();
        try {
            class_5455 lookup = client.field_1687.method_30349();
            class_1792.class_9635 tooltipContext = class_1792.class_9635.method_59530((class_7225.class_7874)lookup);
            class_1836.class_1837 tooltipType = class_1836.class_1837.field_41070;
            List tooltip = result.method_7950(tooltipContext, (class_1657)client.field_1724, (class_1836)tooltipType);
            for (class_2561 line : tooltip) {
                String clean = class_124.method_539((String)line.getString()).toLowerCase(Locale.ROOT).trim();
                tooltipLines.add(clean);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String tooltipLine : tooltipLines) {
            String[] words;
            for (String word : words = tooltipLine.split("[\\s,;.:!\\-]+")) {
                if (word.length() < 3) continue;
                for (int i = 0; i <= word.length() - 3; ++i) {
                    for (int j = i + 3; j <= word.length(); ++j) {
                        List list;
                        String substr = word.substring(i, j);
                        if (substr.isEmpty() || (list = tooltipIndex.computeIfAbsent(substr, k -> new ArrayList())).contains(collection)) continue;
                        list.add(collection);
                    }
                }
            }
        }
    }

    public static void addRecipeToCollectionIfAbsent(class_10355 category, class_10297 recipeEntry, class_10352 context) {
        List recipes;
        Map byItem = GLOBAL_COLLECTIONS_BY_RESULT.computeIfAbsent(category, k -> new HashMap());
        class_1799 result = recipeEntry.comp_3263().comp_3258().method_64742(context);
        if (result == null || result.method_7960()) {
            return;
        }
        class_1792 resultItem = result.method_7909();
        class_516 collection = (class_516)byItem.get(resultItem);
        if (collection == null) {
            collection = new class_516(new ArrayList());
            byItem.put(resultItem, collection);
            RecipeIndex.GLOBAL_RECIPE_INDEX.allCollections.computeIfAbsent(category, k -> new LinkedHashSet()).add(collection);
        }
        if ((recipes = collection.method_2650()).contains(recipeEntry)) {
            return;
        }
        try {
            recipes.add(recipeEntry);
        }
        catch (UnsupportedOperationException e) {
            ArrayList<class_10297> fixed = new ArrayList<class_10297>(recipes);
            fixed.add(recipeEntry);
            class_516 newCollection = new class_516(fixed);
            byItem.put(resultItem, newCollection);
            Set set = RecipeIndex.GLOBAL_RECIPE_INDEX.allCollections.computeIfAbsent(category, k -> new LinkedHashSet());
            set.remove(collection);
            set.add(newCollection);
        }
    }

    public static void addAndIndexRecipeIfAbsent(class_10355 category, class_10297 recipeEntry, class_10352 context) {
        RecipeIndex.addRecipeToCollectionIfAbsent(category, recipeEntry, context);
        Map byItem = GLOBAL_COLLECTIONS_BY_RESULT.computeIfAbsent(category, k -> new HashMap());
        class_1799 result = recipeEntry.comp_3263().comp_3258().method_64742(context);
        if (result == null || result.method_7960()) {
            return;
        }
        class_1792 resultItem = result.method_7909();
        class_516 collection = (class_516)byItem.get(resultItem);
        if (collection == null) {
            return;
        }
        RecipeIndex.updateIndexesWithRecipe(category, collection, recipeEntry);
    }

    public static class IndexedItem {
        public final class_1792 item;
        public final String id;
        public final String name;
        public final String mod;
        public final String key;
        public final List<String> tooltip;

        public IndexedItem(class_1792 item, String id, String name, String mod, String key, List<String> tooltip) {
            this.item = item;
            this.id = id;
            this.name = name;
            this.mod = mod;
            this.key = key;
            this.tooltip = tooltip;
        }
    }
}

