/*
 * Decompiled with CFR 0.152.
 */
package org.windclan.embeddedcomputer.embedded;

import dan200.computercraft.api.filesystem.WritableMount;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlockEntity;
import dan200.computercraft.shared.computer.core.ServerComputer;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.util.Objects;
import java.util.Scanner;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;
import org.windclan.embeddedcomputer.embedded.ServerEmbeddedComputer;
import org.windclan.embeddedcomputer.embedded.block.EmbeddedComputerBlockEntity;
import org.windclan.embeddedcomputer.main;
import org.windclan.embeddedcomputer.secure.HashUtil;

public class EmbeddedComputerPeripheral
implements IPeripheral {
    public final EmbeddedComputerBlockEntity comp;

    public EmbeddedComputerPeripheral(AbstractComputerBlockEntity owner) {
        this.comp = (EmbeddedComputerBlockEntity)owner;
    }

    public String getType() {
        return "embeddedcomputer";
    }

    public boolean equals(@Nullable IPeripheral other) {
        boolean same = false;
        if (this == other) {
            same = true;
        }
        if (other instanceof EmbeddedComputerPeripheral) {
            EmbeddedComputerPeripheral comp1 = (EmbeddedComputerPeripheral)other;
            if (comp1.comp == this.comp) {
                same = true;
            }
        }
        return same;
    }

    public ServerEmbeddedComputer getServerComp() {
        ServerComputer comp1 = this.comp.getServerComputer();
        return (ServerEmbeddedComputer)comp1;
    }

    @LuaFunction
    public final boolean isOn() {
        ServerEmbeddedComputer comp1 = this.getServerComp();
        return !Objects.isNull((Object)comp1) && comp1.isOn();
    }

    @LuaFunction
    public final int getId() {
        ServerEmbeddedComputer comp1 = this.getServerComp();
        if (!Objects.isNull((Object)comp1)) {
            return comp1.getID();
        }
        return -1;
    }

    @LuaFunction
    public final void reboot() {
        ServerEmbeddedComputer comp1 = this.getServerComp();
        if (!Objects.isNull((Object)comp1)) {
            comp1.reboot();
        }
    }

    /*
     * Loose catch block
     */
    @LuaFunction(mainThread=true)
    public final boolean format() {
        ServerEmbeddedComputer comp1 = this.getServerComp();
        if (!Objects.isNull((Object)comp1)) {
            WritableMount mnt;
            block6: {
                mnt = comp1.createRootMount();
                if (!mnt.exists(".LOCKED") && !mnt.exists(".LOCKED_HASHED")) break block6;
                return false;
                {
                    catch (Exception ex) {
                        main.log.info(ex.getMessage(), ex.fillInStackTrace());
                        return false;
                    }
                }
            }
            try {
                mnt.delete("/");
                comp1.reboot();
                return true;
            }
            catch (Exception ignored) {
                comp1.reboot();
                return false;
            }
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final void unlockPlainText(String pass1) {
        ServerEmbeddedComputer comp1 = this.getServerComp();
        if (!Objects.isNull((Object)this.comp)) {
            Channel root = null;
            Scanner scan = null;
            try {
                WritableMount mnt = comp1.createRootMount();
                if (mnt.exists(".LOCKED")) {
                    Object pass = "";
                    root = comp1.createRootMount().openForRead(".LOCKED");
                    scan = new Scanner((ReadableByteChannel)root);
                    while (scan.hasNext()) {
                        pass = (String)pass + scan.next();
                    }
                    scan.close();
                    if (!((String)pass).equals(pass1)) {
                        root.close();
                        return;
                    }
                    mnt.delete(".LOCKED");
                    return;
                }
            }
            catch (Exception ex) {
                main.log.warn(ex.toString());
                if (!Objects.isNull(root)) {
                    try {
                        root.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!Objects.isNull(scan)) {
                    scan.close();
                }
                return;
            }
        }
    }

    @LuaFunction(mainThread=true)
    public final void unlockHashed(String pass1, String hashType) {
        int i;
        String hashedPass;
        ServerEmbeddedComputer comp1 = this.getServerComp();
        if (hashType.equalsIgnoreCase("sha256")) {
            hashedPass = HashUtil.hashStrSHA256(pass1);
            for (i = 0; i <= pass1.length(); ++i) {
                hashedPass = HashUtil.hashStrSHA256(hashedPass);
            }
        } else if (hashType.equalsIgnoreCase("murmur3")) {
            hashedPass = HashUtil.hashStrMurmur3(pass1);
            for (i = 0; i <= pass1.length(); ++i) {
                hashedPass = HashUtil.hashStrMurmur3(hashedPass);
            }
        } else if (hashType.equalsIgnoreCase("adler32")) {
            hashedPass = HashUtil.hashStrAdler32(pass1);
            for (i = 0; i <= pass1.length(); ++i) {
                hashedPass = HashUtil.hashStrAdler32(hashedPass);
            }
        } else if (hashType.equalsIgnoreCase("siphash24")) {
            hashedPass = HashUtil.hashStrSipHash24(pass1);
            for (i = 0; i <= pass1.length(); ++i) {
                hashedPass = HashUtil.hashStrSipHash24(hashedPass);
            }
        } else {
            return;
        }
        for (i = 0; i <= pass1.length(); ++i) {
            hashedPass = HashUtil.hashStrSHA512(hashedPass);
        }
        if (!Objects.isNull((Object)this.comp)) {
            Channel root = null;
            Scanner scan = null;
            try {
                WritableMount mnt = comp1.createRootMount();
                if (mnt.exists(".LOCKED_HASHED")) {
                    Object pass = "";
                    root = comp1.createRootMount().openForRead(".LOCKED_HASHED");
                    scan = new Scanner((ReadableByteChannel)root);
                    while (scan.hasNext()) {
                        pass = (String)pass + scan.next();
                    }
                    scan.close();
                    if (!((String)pass).equals(hashedPass)) {
                        root.close();
                        return;
                    }
                    mnt.delete(".LOCKED_HASHED");
                    return;
                }
            }
            catch (Exception ex) {
                main.log.warn(ex.toString());
                if (!Objects.isNull(root)) {
                    try {
                        root.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!Objects.isNull(scan)) {
                    scan.close();
                }
                return;
            }
        }
    }

    @LuaFunction(mainThread=true)
    public final void unlock(String pass1) {
        this.unlockHashed(pass1, "sha256");
    }

    public void attach(IComputerAccess computer) {
    }

    public void detach(IComputerAccess computer) {
    }

    public Object getTarget() {
        return this.comp;
    }

    public static IPeripheral getPeripheral(class_2586 blockEntity, class_2350 direction) {
        return ((EmbeddedComputerBlockEntity)blockEntity).peripheral();
    }
}

