/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.gui;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.ClientComponentSplitter;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.TooltipBuilder;
import fuzs.puzzleslib.impl.client.gui.WidgetTooltipHolderImpl;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_339;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8000;
import org.jetbrains.annotations.Nullable;

public final class TooltipBuilderImpl
implements TooltipBuilder {
    final List<class_5348> tooltipLines = new ArrayList<class_5348>();
    Duration tooltipDelay = Duration.ofMillis(-1L);
    @Nullable
    BiFunction<class_8000, class_339, class_8000> tooltipPositionerFactory;
    Function<List<? extends class_5348>, List<class_5481>> tooltipLineProcessor = tooltipLines -> ClientComponentSplitter.processTooltipLines(tooltipLines).toList();
    @Nullable
    Supplier<List<? extends class_5348>> tooltipLinesSupplier;

    public TooltipBuilderImpl() {
        this(new class_5348[0]);
    }

    public TooltipBuilderImpl(class_5348 ... lines) {
        this(Arrays.asList(lines));
    }

    public TooltipBuilderImpl(List<? extends class_5348> lines) {
        this.tooltipLines.addAll(lines);
    }

    @Override
    public TooltipBuilder addLines(class_5348 ... lines) {
        Objects.requireNonNull(lines, "tooltip lines is null");
        return this.addLines(Arrays.asList(lines));
    }

    @Override
    public TooltipBuilder addLines(List<? extends class_5348> lines) {
        Objects.requireNonNull(lines, "tooltip lines is null");
        this.tooltipLines.addAll(lines);
        return this;
    }

    @Override
    public TooltipBuilder setLines(Supplier<List<? extends class_5348>> supplier) {
        Objects.requireNonNull(supplier, "tooltip lines supplier is null");
        this.tooltipLinesSupplier = supplier;
        return this;
    }

    @Override
    public TooltipBuilder setDelay(Duration delay) {
        Objects.requireNonNull(delay, "tooltip delay is null");
        this.tooltipDelay = delay;
        return this;
    }

    @Override
    public TooltipBuilder setTooltipPositionerFactory(BiFunction<class_8000, class_339, class_8000> factory) {
        Objects.requireNonNull(factory, "tooltip positioner factory is null");
        this.tooltipPositionerFactory = factory;
        return this;
    }

    @Override
    public TooltipBuilder splitLines() {
        return this.splitLines(175);
    }

    @Override
    public TooltipBuilder splitLines(int maxWidth) {
        Preconditions.checkArgument((maxWidth >= 0 ? 1 : 0) != 0, (Object)"max line width is negative");
        return this.setTooltipLineProcessor(tooltipLines -> ClientComponentSplitter.splitTooltipLines(maxWidth, tooltipLines).toList());
    }

    @Override
    public TooltipBuilder setTooltipLineProcessor(Function<List<? extends class_5348>, List<class_5481>> processor) {
        Objects.requireNonNull(processor, "tooltip line processor is null");
        this.tooltipLineProcessor = processor;
        return this;
    }

    @Override
    public void build(class_339 abstractWidget) {
        abstractWidget.field_41095 = new WidgetTooltipHolderImpl(abstractWidget, this);
    }
}

