/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.mixin.client;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import fuzs.puzzleslib.api.client.event.v1.InputEvents;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.fabric.api.client.event.v1.ExtraScreenMouseEvents;
import fuzs.puzzleslib.fabric.api.client.event.v1.FabricClientEvents;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_437;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_312.class}, priority=900)
abstract class MouseHandlerFabricMixin {
    @Shadow
    @Final
    private class_310 field_1779;
    @Shadow
    private int field_1780;
    @Unique
    private class_437 puzzleslib$currentScreen;

    MouseHandlerFabricMixin() {
    }

    @Inject(method={"onPress"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;getOverlay()Lnet/minecraft/client/gui/screens/Overlay;", ordinal=0)}, cancellable=true)
    private void onPress(long windowPointer, int button, int action, int modifiers, CallbackInfo callback) {
        EventResult result = ((InputEvents.MouseClick)FabricClientEvents.MOUSE_CLICK.invoker()).onMouseClick(button, action, modifiers);
        if (result.isInterrupt()) {
            callback.cancel();
        }
    }

    @Inject(method={"onScroll"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isSpectator()Z", shift=At.Shift.BEFORE)}, cancellable=true)
    private void onScroll(long windowPointer, double xOffset, double yOffset, CallbackInfo callback) {
        boolean discreteMouseScroll = (Boolean)this.field_1779.field_1690.method_42439().method_41753();
        double mouseWheelSensitivity = (Double)this.field_1779.field_1690.method_41806().method_41753();
        double horizontalScrollAmount = discreteMouseScroll ? Math.signum(xOffset) : xOffset * mouseWheelSensitivity;
        double verticalScrollAmount = discreteMouseScroll ? Math.signum(yOffset) : yOffset * mouseWheelSensitivity;
        EventResult result = ((InputEvents.MouseScroll)FabricClientEvents.MOUSE_SCROLL.invoker()).onMouseScroll(this.method_1608(), this.method_35707(), this.method_1609(), horizontalScrollAmount, verticalScrollAmount);
        if (result.isInterrupt()) {
            callback.cancel();
        }
    }

    @Shadow
    public abstract boolean method_1608();

    @Shadow
    public abstract boolean method_35707();

    @Shadow
    public abstract boolean method_1609();

    @WrapWithCondition(method={"handleAccumulatedMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;mouseDragged(DDIDD)Z")})
    private boolean handleAccumulatedMovement(class_437 screen, double mouseX, double mouseY, int activeButton, double dragX, double dragY) {
        this.puzzleslib$currentScreen = this.field_1779.field_1755;
        if (this.puzzleslib$currentScreen == null) {
            return true;
        }
        if (!((ExtraScreenMouseEvents.AllowMouseDrag)ExtraScreenMouseEvents.allowMouseDrag(screen).invoker()).allowMouseDrag(screen, mouseX, mouseY, activeButton, dragX, dragY)) {
            this.puzzleslib$currentScreen = null;
            return false;
        }
        ((ExtraScreenMouseEvents.BeforeMouseDrag)ExtraScreenMouseEvents.beforeMouseDrag(this.puzzleslib$currentScreen).invoker()).beforeMouseDrag(this.puzzleslib$currentScreen, mouseX, mouseY, this.field_1780, dragX, dragY);
        return true;
    }

    @Inject(method={"handleAccumulatedMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;mouseDragged(DDIDD)Z", shift=At.Shift.AFTER)})
    private void handleAccumulatedMovement(CallbackInfo callback, @Local(ordinal=2) double mouseX, @Local(ordinal=3) double mouseY, @Local(ordinal=4) double dragX, @Local(ordinal=5) double dragY) {
        if (this.puzzleslib$currentScreen == null) {
            return;
        }
        ((ExtraScreenMouseEvents.AfterMouseDrag)ExtraScreenMouseEvents.afterMouseDrag(this.puzzleslib$currentScreen).invoker()).afterMouseDrag(this.puzzleslib$currentScreen, mouseX, mouseY, this.field_1780, dragX, dragY);
        this.puzzleslib$currentScreen = null;
    }
}

