/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.event.v1.entity.ChangeEntitySizeCallback;
import fuzs.puzzleslib.api.event.v1.entity.EntityRidingEvents;
import fuzs.puzzleslib.api.event.v1.entity.EntityTickEvents;
import fuzs.puzzleslib.fabric.api.event.v1.FabricEntityEvents;
import fuzs.puzzleslib.fabric.impl.event.CapturedDropsEntity;
import java.util.Collection;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
abstract class EntityFabricMixin
implements CapturedDropsEntity {
    @Shadow
    @Nullable
    private class_1297 field_6034;
    @Shadow
    private class_1937 field_6002;
    @Shadow
    private class_4048 field_18065;
    @Shadow
    private float field_18066;
    @Unique
    @Nullable
    private Collection<class_1542> puzzleslib$capturedDrops;

    EntityFabricMixin() {
    }

    @WrapWithCondition(method={"rideTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;tick()V")})
    public boolean rideTick(class_1297 entity, @Share(value="isEntityTickCancelled") LocalBooleanRef isEntityTickCancelled) {
        EventResult result = ((EntityTickEvents.Start)FabricEntityEvents.ENTITY_TICK_START.invoker()).onStartEntityTick(entity);
        isEntityTickCancelled.set(result.isInterrupt());
        return result.isPass();
    }

    @Inject(method={"rideTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;tick()V", shift=At.Shift.AFTER)})
    public void rideTick(CallbackInfo callback, @Share(value="isEntityTickCancelled") LocalBooleanRef isEntityTickCancelled) {
        if (!isEntityTickCancelled.get()) {
            ((EntityTickEvents.End)FabricEntityEvents.ENTITY_TICK_END.invoker()).onEndEntityTick((class_1297)class_1297.class.cast(this));
        }
    }

    @Override
    public Collection<class_1542> puzzleslib$acceptCapturedDrops(Collection<class_1542> capturedDrops) {
        Collection<class_1542> oldCapturedDrops = this.puzzleslib$capturedDrops;
        this.puzzleslib$capturedDrops = capturedDrops;
        return oldCapturedDrops;
    }

    @Override
    @Nullable
    public Collection<class_1542> puzzleslib$getCapturedDrops() {
        return this.puzzleslib$capturedDrops;
    }

    @WrapWithCondition(method={"spawnAtLocation(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z")})
    public boolean spawnAtLocation(class_3218 serverLevel, class_1297 entity) {
        Collection<class_1542> capturedDrops = this.puzzleslib$getCapturedDrops();
        if (capturedDrops != null) {
            capturedDrops.add((class_1542)entity);
            return false;
        }
        return true;
    }

    @Inject(method={"startRiding(Lnet/minecraft/world/entity/Entity;Z)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;isPassenger()Z", shift=At.Shift.BEFORE)}, cancellable=true)
    public void startRiding(class_1297 vehicle, boolean force, CallbackInfoReturnable<Boolean> callback) {
        EventResult result = ((EntityRidingEvents.Start)FabricEntityEvents.ENTITY_START_RIDING.invoker()).onStartRiding(this.field_6002, (class_1297)class_1297.class.cast(this), vehicle);
        if (result.isInterrupt()) {
            callback.setReturnValue((Object)false);
        }
    }

    @Inject(method={"removeVehicle"}, at={@At(value="HEAD")}, cancellable=true)
    public void removeVehicle(CallbackInfo callback) {
        EventResult result;
        if (this.field_6034 != null && (result = ((EntityRidingEvents.Stop)FabricEntityEvents.ENTITY_STOP_RIDING.invoker()).onStopRiding(this.field_6002, (class_1297)class_1297.class.cast(this), this.field_6034)).isInterrupt()) {
            callback.cancel();
        }
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void init(class_1299<?> entityType, class_1937 level, CallbackInfo callback) {
        EventResultHolder<class_4048> result = ((ChangeEntitySizeCallback)FabricEntityEvents.CHANGE_ENTITY_SIZE.invoker()).onChangeEntitySize((class_1297)class_1297.class.cast(this), class_4050.field_18076, entityType.method_18386());
        result.ifInterrupt(entityDimensions -> {
            this.field_18065 = entityDimensions;
            this.field_18066 = entityDimensions.comp_2187();
        });
    }

    @ModifyVariable(method={"refreshDimensions"}, at=@At(value="STORE"), ordinal=1)
    public class_4048 refreshDimensions(class_4048 entityDimensions) {
        EventResultHolder<class_4048> result = ((ChangeEntitySizeCallback)FabricEntityEvents.CHANGE_ENTITY_SIZE.invoker()).onChangeEntitySize((class_1297)class_1297.class.cast(this), this.method_18376(), entityDimensions);
        return result.getInterrupt().orElse(entityDimensions);
    }

    @Shadow
    public abstract class_4050 method_18376();
}

