/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.config.v3;

import fuzs.puzzleslib.api.config.v3.ConfigCore;
import fuzs.puzzleslib.api.config.v3.ConfigDataHolder;
import fuzs.puzzleslib.api.core.v1.utility.Buildable;
import fuzs.puzzleslib.impl.config.ConfigHolderRegistry;
import fuzs.puzzleslib.impl.core.ModContext;
import fuzs.puzzleslib.impl.core.proxy.ProxyImpl;
import java.nio.file.Paths;
import java.util.function.UnaryOperator;

public interface ConfigHolder {
    public static Builder builder(String modId) {
        return ModContext.get(modId).getConfigHolder();
    }

    public <T extends ConfigCore> ConfigDataHolder<T> getHolder(Class<T> var1);

    default public <T extends ConfigCore> T get(Class<T> clazz) {
        return this.getHolder(clazz).getConfig();
    }

    public static UnaryOperator<String> getSimpleNameFactory() {
        return modId -> modId + ".toml";
    }

    public static UnaryOperator<String> getDefaultNameFactory(String configType) {
        return modId -> modId + "-" + configType + ".toml";
    }

    public static UnaryOperator<String> getDirectoryNameFactory(String configType, String directory) {
        return modId -> Paths.get(directory, (String)ConfigHolder.getDefaultNameFactory(configType).apply((String)modId)).toString();
    }

    public static void registerConfigurationScreen(String modId, String ... otherModIds) {
        ProxyImpl.get().registerConfigurationScreen(modId, otherModIds);
    }

    public static interface Builder
    extends ConfigHolderRegistry,
    Buildable {
        public <T extends ConfigCore> Builder client(Class<T> var1);

        public <T extends ConfigCore> Builder common(Class<T> var1);

        public <T extends ConfigCore> Builder server(Class<T> var1);

        public <T extends ConfigCore> Builder setFileName(Class<T> var1, UnaryOperator<String> var2);
    }
}

