/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.data.v2;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1535;
import net.minecraft.class_156;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1928;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2405;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3414;
import net.minecraft.class_3448;
import net.minecraft.class_5321;
import net.minecraft.class_5794;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7403;
import net.minecraft.class_7417;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import org.jetbrains.annotations.ApiStatus;

public abstract class AbstractLanguageProvider
implements class_2405 {
    private final class_2960 filePath;
    private final class_7784.class_7489 pathProvider;

    public AbstractLanguageProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput());
    }

    public AbstractLanguageProvider(String languageCode, DataProviderContext context) {
        this(languageCode, context.getModId(), context.getPackOutput());
    }

    public AbstractLanguageProvider(String modId, class_7784 packOutput) {
        this("en_us", modId, packOutput);
    }

    public AbstractLanguageProvider(String languageCode, String modId, class_7784 packOutput) {
        this.filePath = ResourceLocationHelper.fromNamespaceAndPath(modId, languageCode);
        this.pathProvider = packOutput.method_45973(class_7784.class_7490.field_39368, "lang");
    }

    public abstract void addTranslations(TranslationBuilder var1);

    public CompletableFuture<?> method_10319(class_7403 cachedOutput) {
        JsonObject jsonObject = new JsonObject();
        this.addTranslations((translationKey, value) -> {
            Objects.requireNonNull(translationKey, "translation key is null");
            Objects.requireNonNull(value, "value is null");
            if (jsonObject.has(translationKey)) {
                throw new IllegalStateException("Created duplicate translation key: " + translationKey);
            }
            jsonObject.addProperty(translationKey, value);
        });
        this.verifyRequiredTranslationKeys(arg_0 -> ((JsonObject)jsonObject).has(arg_0), (class_2378)class_7923.field_41175, TranslationBuilder::addBlock);
        this.verifyRequiredTranslationKeys(arg_0 -> ((JsonObject)jsonObject).has(arg_0), (class_2378)class_7923.field_41178, TranslationBuilder::addItem);
        this.verifyRequiredTranslationKeys(arg_0 -> ((JsonObject)jsonObject).has(arg_0), (class_2378)class_7923.field_41177, TranslationBuilder::addEntityType);
        this.verifyRequiredTranslationKeys(arg_0 -> ((JsonObject)jsonObject).has(arg_0), class_7923.field_41190, TranslationBuilder::addAttribute);
        this.verifyRequiredTranslationKeys(arg_0 -> ((JsonObject)jsonObject).has(arg_0), class_7923.field_41174, TranslationBuilder::addMobEffect);
        return class_2405.method_10320((class_7403)cachedOutput, (JsonElement)jsonObject, (Path)this.pathProvider.method_44107(this.filePath));
    }

    private <T> void verifyRequiredTranslationKeys(Predicate<String> predicate, class_2378<T> registry, HolderTranslationCollector<T> holderTranslationCollector) {
        registry.method_42017().filter(holder -> holder.method_40237().method_29177().method_12836().equals(this.filePath.method_12836())).forEach(holder -> holderTranslationCollector.accept((translationKey, value) -> {
            Objects.requireNonNull(translationKey, "translation key is null");
            if (this.mustHaveTranslationKey((class_6880.class_6883<?>)holder, translationKey) && !predicate.test(translationKey)) {
                throw new IllegalStateException("Missing translation key '%s' for '%s'".formatted(translationKey, holder));
            }
        }, (class_6880)holder, ""));
    }

    protected boolean mustHaveTranslationKey(class_6880.class_6883<?> holder, String translationKey) {
        return true;
    }

    public String method_10321() {
        return "Language (" + this.filePath.method_12832() + ")";
    }

    @FunctionalInterface
    @ApiStatus.NonExtendable
    public static interface TranslationBuilder {
        public void add(String var1, String var2);

        default public void add(String translationKey, String additionalKey, String value) {
            Objects.requireNonNull(additionalKey, "additional key is null");
            this.add(translationKey + (String)(additionalKey.isEmpty() ? "" : "." + additionalKey), value);
        }

        default public void add(class_2960 resourceLocation, String value) {
            this.add(resourceLocation, "", value);
        }

        default public void add(class_2960 resourceLocation, String additionalKey, String value) {
            Objects.requireNonNull(resourceLocation, "resource location is null");
            this.add(resourceLocation.method_42094(), additionalKey, value);
        }

        default public void add(class_6880<?> holder, String value) {
            this.add(holder, "", value);
        }

        default public void add(class_6880<?> holder, String additionalKey, String value) {
            Objects.requireNonNull(holder, "holder is null");
            this.add((class_5321)holder.method_40230().orElseThrow(), additionalKey, value);
        }

        default public void add(class_5321<?> resourceKey, String value) {
            this.add(resourceKey, "", value);
        }

        default public void add(class_5321<?> resourceKey, String additionalKey, String value) {
            Objects.requireNonNull(resourceKey, "resource key is null");
            this.add(class_7924.method_60915((class_5321)resourceKey.method_58273()), resourceKey.method_29177(), additionalKey, value);
        }

        default public void add(String registry, class_2960 resourceLocation, String value) {
            this.add(registry, resourceLocation, "", value);
        }

        default public void add(String registry, class_2960 resourceLocation, String additionalKey, String value) {
            Objects.requireNonNull(registry, "registry is null");
            Objects.requireNonNull(resourceLocation, "resource location is null");
            String translationKey = class_156.method_646((String)registry, (class_2960)resourceLocation);
            this.add(translationKey, additionalKey, value);
        }

        default public void add(class_6862<?> tagKey, String value) {
            String descriptionId = class_156.method_646((String)class_7924.method_60915((class_5321)tagKey.comp_326()), (class_2960)tagKey.comp_327());
            this.add("tag." + descriptionId, value);
        }

        default public BlockFamilyBuilder blockFamily(String blockValue) {
            return new BlockFamilyBuilder(this::add, blockValue);
        }

        default public BlockFamilyBuilder blockFamily(String blockValue, String baseBlockValue) {
            return new BlockFamilyBuilder(this::add, blockValue, baseBlockValue);
        }

        default public void addBlock(class_6880<class_2248> block, String value) {
            this.add((class_2248)block.comp_349(), value);
        }

        default public void add(class_2248 block, String value) {
            this.add(block, "", value);
        }

        default public void add(class_2248 block, String additionalKey, String value) {
            Objects.requireNonNull(block, "block is null");
            this.add(block.method_63499(), additionalKey, value);
        }

        default public void addItem(class_6880<class_1792> item, String value) {
            this.add((class_1792)item.comp_349(), value);
        }

        default public void add(class_1792 item, String value) {
            this.add(item, "", value);
        }

        default public void add(class_1792 item, String additionalKey, String value) {
            Objects.requireNonNull(item, "item is null");
            this.add(item.method_7876(), additionalKey, value);
        }

        default public void addSpawnEgg(class_1792 item, String value) {
            if (!(item instanceof class_1826)) {
                throw new IllegalArgumentException("Unsupported item: " + String.valueOf(item));
            }
            this.add(item, value + " Spawn Egg");
        }

        default public void addMobEffect(class_6880<class_1291> mobEffect, String value) {
            Objects.requireNonNull(mobEffect, "mob effect is null");
            this.add((class_1291)mobEffect.comp_349(), value);
        }

        default public void add(class_1291 mobEffect, String value) {
            this.add(mobEffect, "", value);
        }

        default public void add(class_1291 mobEffect, String additionalKey, String value) {
            Objects.requireNonNull(mobEffect, "mob effect is null");
            this.add(mobEffect.method_5567(), additionalKey, value);
        }

        default public void addEntityType(class_6880<? extends class_1299<?>> entityType, String value) {
            this.add((class_1299)entityType.comp_349(), value);
        }

        default public void add(class_1299<?> entityType, String value) {
            this.add(entityType, "", value);
        }

        default public void add(class_1299<?> entityType, String additionalKey, String value) {
            Objects.requireNonNull(entityType, "entity type is null");
            this.add(entityType.method_5882(), additionalKey, value);
        }

        default public void addAttribute(class_6880<class_1320> attribute, String value) {
            this.add((class_1320)attribute.comp_349(), value);
        }

        default public void add(class_1320 attribute, String value) {
            this.add(attribute, "", value);
        }

        default public void add(class_1320 attribute, String additionalKey, String value) {
            Objects.requireNonNull(attribute, "attribute is null");
            this.add(attribute.method_26830(), additionalKey, value);
        }

        default public void add(class_3448<?> statType, String value) {
            this.add(statType, "", value);
        }

        default public void add(class_3448<?> statType, String additionalKey, String value) {
            Objects.requireNonNull(statType, "stat type is null");
            Objects.requireNonNull(statType.method_30739(), "component is null");
            class_7417 class_74172 = statType.method_30739().method_10851();
            if (!(class_74172 instanceof class_2588)) {
                throw new IllegalArgumentException("Unsupported component: " + String.valueOf(statType.method_30739()));
            }
            class_2588 contents = (class_2588)class_74172;
            this.add(contents.method_11022(), additionalKey, value);
        }

        default public void add(class_1928.class_4313<?> gameRule, String value) {
            this.add(gameRule, "", value);
        }

        default public void addGameRuleDescription(class_1928.class_4313<?> gameRule, String value) {
            this.add(gameRule, "description", value);
        }

        default public void add(class_1928.class_4313<?> gameRule, String additionalKey, String value) {
            Objects.requireNonNull(gameRule, "game rule is null");
            this.add(gameRule.method_27334(), additionalKey, value);
        }

        default public void addPotion(class_6880<class_1842> potion, String value) {
            Objects.requireNonNull(potion, "potion is null");
            Function<class_1792, class_2561> potionNameGetter = item -> new class_1844(potion).method_64195(item.method_7876() + ".effect.");
            this.add(potionNameGetter.apply(class_1802.field_8087), "Arrow of " + value);
            this.add(potionNameGetter.apply(class_1802.field_8574), "Potion of " + value);
            this.add(potionNameGetter.apply(class_1802.field_8436), "Splash Potion of " + value);
            this.add(potionNameGetter.apply(class_1802.field_8150), "Lingering Potion of " + value);
        }

        default public void addSoundEvent(class_6880<class_3414> soundEvent, String value) {
            this.add((class_3414)soundEvent.comp_349(), value);
        }

        default public void add(class_3414 soundEvent, String value) {
            Objects.requireNonNull(soundEvent, "sound event is null");
            this.add("subtitles." + soundEvent.comp_3319().method_12832(), value);
        }

        default public void addCreativeModeTab(class_6880<class_1761> creativeModeTab, String value) {
            Objects.requireNonNull(creativeModeTab, "creative mode tab is null");
            this.add((class_1761)creativeModeTab.comp_349(), value);
        }

        default public void add(class_1761 creativeModeTab, String value) {
            Objects.requireNonNull(creativeModeTab, "creative mode tab is null");
            this.add(creativeModeTab.method_7737(), value);
        }

        default public void add(class_304 keyMapping, String value) {
            Objects.requireNonNull(keyMapping, "key mapping is null");
            this.add(keyMapping.method_1431(), value);
        }

        default public void addKeyCategory(String modId, String value) {
            this.add("key.categories." + modId, value);
        }

        default public void add(class_2561 component, String value) {
            Objects.requireNonNull(component, "component is null");
            class_7417 class_74172 = component.method_10851();
            if (!(class_74172 instanceof class_2588)) {
                throw new IllegalArgumentException("Unsupported component: " + String.valueOf(component));
            }
            class_2588 contents = (class_2588)class_74172;
            this.add(contents.method_11022(), value);
        }

        default public void addGenericDamageType(class_5321<class_8110> damageType, String value) {
            Objects.requireNonNull(damageType, "damage type is null");
            this.add("death.attack." + damageType.method_29177().method_12832(), value);
        }

        default public void addPlayerDamageType(class_5321<class_8110> damageType, String value) {
            Objects.requireNonNull(damageType, "damage type is null");
            this.add("death.attack." + damageType.method_29177().method_12832() + ".player", value);
        }

        default public void addItemDamageType(class_5321<class_8110> damageType, String value) {
            Objects.requireNonNull(damageType, "damage type is null");
            this.add("death.attack." + damageType.method_29177().method_12832() + ".item", value);
        }

        default public void addPaintingVariant(class_5321<class_1535> paintingVariant, String title, String author) {
            Objects.requireNonNull(paintingVariant, "painting variant is null");
            this.add(paintingVariant.method_29177().method_48747("painting", "title"), title);
            this.add(paintingVariant.method_29177().method_48747("painting", "author"), author);
        }
    }

    @FunctionalInterface
    protected static interface HolderTranslationCollector<T> {
        public void accept(TranslationBuilder var1, class_6880<T> var2, String var3);
    }

    public static class BlockFamilyBuilder {
        static final Map<class_5794.class_5796, BiFunction<BlockFamilyBuilder, class_2248, BlockFamilyBuilder>> VARIANT_FUNCTIONS = ImmutableMap.builder().put((Object)class_5794.class_5796.field_28533, BlockFamilyBuilder::button).put((Object)class_5794.class_5796.field_28534, BlockFamilyBuilder::chiseled).put((Object)class_5794.class_5796.field_29503, BlockFamilyBuilder::cracked).put((Object)class_5794.class_5796.field_33689, BlockFamilyBuilder::cut).put((Object)class_5794.class_5796.field_28535, BlockFamilyBuilder::door).put((Object)class_5794.class_5796.field_40592, BlockFamilyBuilder::fence).put((Object)class_5794.class_5796.field_28536, BlockFamilyBuilder::fence).put((Object)class_5794.class_5796.field_40593, BlockFamilyBuilder::fenceGate).put((Object)class_5794.class_5796.field_28537, BlockFamilyBuilder::fenceGate).put((Object)class_5794.class_5796.field_40594, BlockFamilyBuilder::mosaic).put((Object)class_5794.class_5796.field_28538, BlockFamilyBuilder::sign).put((Object)class_5794.class_5796.field_28539, BlockFamilyBuilder::slab).put((Object)class_5794.class_5796.field_28540, BlockFamilyBuilder::stairs).put((Object)class_5794.class_5796.field_28541, BlockFamilyBuilder::pressurePlate).put((Object)class_5794.class_5796.field_28542, BlockFamilyBuilder::polished).put((Object)class_5794.class_5796.field_28543, BlockFamilyBuilder::trapdoor).put((Object)class_5794.class_5796.field_28544, BlockFamilyBuilder::wall).build();
        private final BiConsumer<class_2248, String> valueConsumer;
        private final String blockValue;
        private final String baseBlockValue;

        private BlockFamilyBuilder(BiConsumer<class_2248, String> valueConsumer, String blockValue) {
            this(valueConsumer, blockValue, blockValue);
        }

        private BlockFamilyBuilder(BiConsumer<class_2248, String> valueConsumer, String blockValue, String baseBlockValue) {
            this.valueConsumer = valueConsumer;
            this.blockValue = blockValue;
            this.baseBlockValue = baseBlockValue;
        }

        public void generateFor(class_5794 blockFamily) {
            this.baseBlock(blockFamily.method_33469());
            blockFamily.method_33474().forEach((variant, block) -> {
                BiFunction<BlockFamilyBuilder, class_2248, BlockFamilyBuilder> variantFunction = VARIANT_FUNCTIONS.get(variant);
                if (variantFunction != null) {
                    variantFunction.apply(this, (class_2248)block);
                }
            });
        }

        public BlockFamilyBuilder baseBlock(class_2248 block) {
            this.valueConsumer.accept(block, this.baseBlockValue);
            return this;
        }

        public BlockFamilyBuilder button(class_2248 block) {
            this.valueConsumer.accept(block, this.blockValue + " Button");
            return this;
        }

        public BlockFamilyBuilder chiseled(class_2248 block) {
            this.valueConsumer.accept(block, "Chiseled " + this.blockValue);
            return this;
        }

        public BlockFamilyBuilder cracked(class_2248 block) {
            this.valueConsumer.accept(block, "Cracked " + this.blockValue);
            return this;
        }

        public BlockFamilyBuilder cut(class_2248 block) {
            this.valueConsumer.accept(block, "Cut " + this.blockValue);
            return this;
        }

        public BlockFamilyBuilder door(class_2248 block) {
            this.valueConsumer.accept(block, this.blockValue + " Door");
            return this;
        }

        public BlockFamilyBuilder fence(class_2248 block) {
            this.valueConsumer.accept(block, this.blockValue + " Fence");
            return this;
        }

        public BlockFamilyBuilder fenceGate(class_2248 block) {
            this.valueConsumer.accept(block, this.blockValue + " Fence Gate");
            return this;
        }

        public BlockFamilyBuilder mosaic(class_2248 block) {
            this.valueConsumer.accept(block, "Mosaic " + this.blockValue);
            return this;
        }

        public BlockFamilyBuilder sign(class_2248 block) {
            this.valueConsumer.accept(block, this.blockValue + " Sign");
            return this;
        }

        public BlockFamilyBuilder slab(class_2248 block) {
            this.valueConsumer.accept(block, this.blockValue + " Slab");
            return this;
        }

        public BlockFamilyBuilder hangingSign(class_2248 block) {
            this.valueConsumer.accept(block, this.blockValue + " Hanging Sign");
            return this;
        }

        public BlockFamilyBuilder stairs(class_2248 block) {
            this.valueConsumer.accept(block, this.blockValue + " Stairs");
            return this;
        }

        public BlockFamilyBuilder pressurePlate(class_2248 block) {
            this.valueConsumer.accept(block, this.blockValue + " Pressure Plate");
            return this;
        }

        public BlockFamilyBuilder polished(class_2248 block) {
            this.valueConsumer.accept(block, "Polished " + this.blockValue);
            return this;
        }

        public BlockFamilyBuilder trapdoor(class_2248 block) {
            this.valueConsumer.accept(block, this.blockValue + " Trapdoor");
            return this;
        }

        public BlockFamilyBuilder wall(class_2248 block) {
            this.valueConsumer.accept(block, this.blockValue + " Wall");
            return this;
        }
    }
}

