/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.server.channel;

import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.net.SocketAddress;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.server.channel.RakNetChildChannel;

public class RakNetApplicationChannel
extends AbstractChannel {
    public static final String NAME_SERVER_PARENT_THREADED_READ_HANDLER = "rn-server-parent-threaded-read-handler";

    protected RakNetApplicationChannel(RakNetChildChannel parent) {
        super((Channel)parent);
    }

    public boolean isWritable() {
        Boolean result = (Boolean)this.attr(RakNet.WRITABLE).get();
        return (result == null || result != false) && this.parent().isWritable();
    }

    public long bytesBeforeUnwritable() {
        return this.parent().bytesBeforeUnwritable();
    }

    public long bytesBeforeWritable() {
        return this.parent().bytesBeforeWritable();
    }

    public RakNetChildChannel parent() {
        return (RakNetChildChannel)super.parent();
    }

    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new RakNetApplicationChannelUnsafe();
    }

    public Channel.Unsafe unsafe() {
        return ((RakNetApplicationChannelUnsafe)super.unsafe()).wrapped;
    }

    protected boolean isCompatible(EventLoop eventloop) {
        return true;
    }

    protected SocketAddress localAddress0() {
        return this.parent().localAddress();
    }

    protected SocketAddress remoteAddress0() {
        return this.parent().remoteAddress();
    }

    protected void doBind(SocketAddress addr) {
        throw new UnsupportedOperationException();
    }

    protected void doDisconnect() {
        this.close();
        this.parent().close();
    }

    protected void doClose() {
        this.close();
        this.parent().close();
    }

    protected void doBeginRead() {
    }

    protected void doWrite(ChannelOutboundBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    public RakNet.Config config() {
        return this.parent().config();
    }

    public boolean isOpen() {
        return this.parent().isOpen();
    }

    public boolean isActive() {
        return this.isOpen() && this.parent().isActive();
    }

    public ChannelMetadata metadata() {
        return this.parent().metadata();
    }

    public ChannelFuture close() {
        if (this.isRegistered()) {
            return super.close();
        }
        return this.parent().close();
    }

    protected final class RakNetApplicationChannelUnsafe
    extends AbstractChannel.AbstractUnsafe {
        final Channel.Unsafe wrapped;

        protected RakNetApplicationChannelUnsafe() {
            super((AbstractChannel)RakNetApplicationChannel.this);
            this.wrapped = new Channel.Unsafe(){

                public RecvByteBufAllocator.Handle recvBufAllocHandle() {
                    return RakNetApplicationChannelUnsafe.this.recvBufAllocHandle();
                }

                public SocketAddress localAddress() {
                    return RakNetApplicationChannelUnsafe.this.localAddress();
                }

                public SocketAddress remoteAddress() {
                    return RakNetApplicationChannelUnsafe.this.remoteAddress();
                }

                public void register(EventLoop eventLoop, ChannelPromise promise) {
                    RakNetApplicationChannelUnsafe.this.register(eventLoop, promise);
                }

                public void bind(SocketAddress localAddress, ChannelPromise promise) {
                    RakNetApplicationChannelUnsafe.this.bind(localAddress, promise);
                }

                public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
                    RakNetApplicationChannelUnsafe.this.connect(remoteAddress, localAddress, promise);
                }

                public void disconnect(ChannelPromise promise) {
                    RakNetApplicationChannelUnsafe.this.disconnect(promise);
                }

                public void close(ChannelPromise promise) {
                    EventLoop parentEventLoop = RakNetApplicationChannel.this.parent().eventLoop();
                    RakNetApplicationChannel.this.parent().close().addListener(future -> {
                        PromiseCombiner combiner = new PromiseCombiner();
                        ChannelPromise newPromise = promise.channel().newPromise();
                        parentEventLoop.execute(() -> promise.channel().eventLoop().execute(() -> RakNetApplicationChannelUnsafe.this.close(newPromise)));
                        combiner.add((Future)newPromise);
                        combiner.add(future);
                        combiner.finish((Promise)promise);
                    });
                }

                public void closeForcibly() {
                    RakNetApplicationChannelUnsafe.this.closeForcibly();
                }

                public void deregister(ChannelPromise promise) {
                    RakNetApplicationChannelUnsafe.this.deregister(promise);
                }

                public void beginRead() {
                    RakNetApplicationChannelUnsafe.this.beginRead();
                }

                public void write(Object msg, ChannelPromise promise) {
                    ChannelFuture future = RakNetApplicationChannel.this.parent().write(msg);
                    future.addListener((GenericFutureListener)RakNet.INTERNAL_WRITE_LISTENER);
                    future.addListener(future1 -> {
                        if (future1.isSuccess()) {
                            promise.trySuccess();
                        } else {
                            promise.tryFailure(future1.cause());
                        }
                    });
                }

                public void flush() {
                    RakNetApplicationChannel.this.parent().flush();
                }

                public ChannelPromise voidPromise() {
                    return RakNetApplicationChannelUnsafe.this.voidPromise();
                }

                public ChannelOutboundBuffer outboundBuffer() {
                    return RakNetApplicationChannelUnsafe.this.outboundBuffer();
                }
            };
        }

        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            throw new UnsupportedOperationException();
        }
    }
}

