/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.pipeline;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.util.ReferenceCountUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import network.ycc.raknet.frame.Frame;
import network.ycc.raknet.packet.FramedPacket;
import network.ycc.raknet.utils.Constants;
import network.ycc.raknet.utils.UINT;

public class FrameOrderIn
extends MessageToMessageDecoder<Frame> {
    public static final String NAME = "rn-order-in";
    protected final OrderedChannelPacketQueue[] channels = new OrderedChannelPacketQueue[8];

    public FrameOrderIn() {
        for (int i = 0; i < this.channels.length; ++i) {
            this.channels[i] = new OrderedChannelPacketQueue();
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        Arrays.stream(this.channels).forEach(OrderedChannelPacketQueue::clear);
    }

    protected void decode(ChannelHandlerContext ctx, Frame frame, List<Object> list) {
        if (frame.getReliability().isSequenced) {
            frame.touch("Sequenced");
            this.channels[frame.getOrderChannel()].decodeSequenced(frame, list);
        } else if (frame.getReliability().isOrdered) {
            frame.touch("Ordered");
            this.channels[frame.getOrderChannel()].decodeOrdered(frame, list);
        } else {
            frame.touch("No order");
            list.add(frame.retainedFrameData());
        }
    }

    protected static class OrderedChannelPacketQueue {
        protected final Int2ObjectOpenHashMap<FramedPacket> queue = new Int2ObjectOpenHashMap();
        protected int lastOrderIndex = -1;
        protected int lastSequenceIndex = -1;

        protected OrderedChannelPacketQueue() {
        }

        protected void decodeSequenced(Frame frame, List<Object> list) {
            if (UINT.B3.minusWrap(frame.getSequenceIndex(), this.lastSequenceIndex) > 0) {
                this.lastSequenceIndex = frame.getSequenceIndex();
                while (UINT.B3.minusWrap(frame.getOrderIndex(), this.lastOrderIndex) > 1) {
                    ReferenceCountUtil.release((Object)this.queue.remove(this.lastOrderIndex));
                    this.lastOrderIndex = UINT.B3.plus(this.lastOrderIndex, 1);
                }
            }
            this.decodeOrdered(frame, list);
        }

        protected void decodeOrdered(Frame frame, List<Object> list) {
            int indexDiff = UINT.B3.minusWrap(frame.getOrderIndex(), this.lastOrderIndex);
            Constants.packetLossCheck(indexDiff, "ordered difference");
            if (indexDiff == 1) {
                FramedPacket data = frame.retainedFrameData();
                do {
                    list.add(data);
                    this.lastOrderIndex = UINT.B3.plus(this.lastOrderIndex, 1);
                } while ((data = (FramedPacket)this.queue.remove(UINT.B3.plus(this.lastOrderIndex, 1))) != null);
            } else if (indexDiff > 1 && !this.queue.containsKey(frame.getOrderIndex())) {
                this.queue.put(frame.getOrderIndex(), (Object)frame.retainedFrameData());
            }
            Constants.packetLossCheck(this.queue.size(), "missed ordered packets");
        }

        protected void clear() {
            this.queue.values().forEach(ReferenceCountUtil::release);
            this.queue.clear();
        }
    }
}

