/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.util.ReferenceCountUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.frame.Frame;
import network.ycc.raknet.packet.FramedPacket;
import network.ycc.raknet.utils.Constants;

public class FrameJoiner
extends MessageToMessageDecoder<Frame> {
    public static final String NAME = "rn-join";
    protected final Int2ObjectOpenHashMap<Builder> pendingPackets = new Int2ObjectOpenHashMap();

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        this.pendingPackets.values().forEach(Builder::release);
        this.pendingPackets.clear();
    }

    protected void decode(ChannelHandlerContext ctx, Frame frame, List<Object> list) {
        if (!frame.hasSplit()) {
            frame.touch("Not split");
            list.add((Object)frame.retain());
        } else {
            int splitID = frame.getSplitId();
            Builder partial = (Builder)this.pendingPackets.get(splitID);
            int totalSize = frame.getSplitCount() * frame.getRoughPacketSize();
            frame.touch("Is split");
            if (totalSize > RakNet.config(ctx).getMaxQueuedBytes()) {
                throw new TooLongFrameException("Fragmented frame too large");
            }
            if (partial == null) {
                Constants.packetLossCheck(frame.getSplitCount(), "frame join elements");
                this.pendingPackets.put(splitID, (Object)Builder.create(ctx.alloc(), frame));
            } else {
                partial.add(frame);
                if (partial.isDone()) {
                    this.pendingPackets.remove(splitID);
                    list.add((Object)partial.finish());
                }
            }
            Constants.packetLossCheck(this.pendingPackets.size(), "pending frame joins");
        }
    }

    protected static final class Builder {
        protected final Int2ObjectOpenHashMap<ByteBuf> queue;
        protected Frame samplePacket;
        protected CompositeByteBuf data;
        protected int splitIdx;
        protected int orderId;
        protected FramedPacket.Reliability reliability;

        private Builder(int size) {
            this.queue = new Int2ObjectOpenHashMap(size);
        }

        private static Builder create(ByteBufAllocator alloc, Frame frame) {
            Builder out = new Builder(frame.getSplitCount());
            out.init(alloc, frame);
            return out;
        }

        void init(ByteBufAllocator alloc, Frame packet) {
            assert (this.data == null);
            this.splitIdx = 0;
            this.data = alloc.compositeDirectBuffer(packet.getSplitCount());
            this.orderId = packet.getOrderChannel();
            this.reliability = packet.getReliability();
            this.samplePacket = packet.retain();
            this.add(packet);
        }

        void add(Frame packet) {
            assert (packet.getReliability().equals((Object)this.samplePacket.getReliability()));
            assert (packet.getOrderChannel() == this.samplePacket.getOrderChannel());
            assert (packet.getOrderIndex() == this.samplePacket.getOrderIndex());
            if (!this.queue.containsKey(packet.getSplitIndex()) && packet.getSplitIndex() >= this.splitIdx) {
                this.queue.put(packet.getSplitIndex(), (Object)packet.retainedFragmentData());
                this.update();
            }
            Constants.packetLossCheck(this.queue.size(), "packet defragment queue");
        }

        void update() {
            ByteBuf fragment;
            while ((fragment = (ByteBuf)this.queue.remove(this.splitIdx)) != null) {
                this.data.addComponent(true, fragment);
                ++this.splitIdx;
            }
        }

        Frame finish() {
            assert (this.isDone());
            assert (this.queue.isEmpty());
            try {
                Frame frame = this.samplePacket.completeFragment((ByteBuf)this.data);
                return frame;
            }
            finally {
                this.release();
            }
        }

        boolean isDone() {
            assert (this.samplePacket.getSplitCount() >= this.splitIdx);
            return this.samplePacket.getSplitCount() == this.splitIdx;
        }

        void release() {
            if (this.data != null) {
                this.data.release();
                this.data = null;
            }
            if (this.samplePacket != null) {
                this.samplePacket.release();
                this.samplePacket = null;
            }
            this.queue.values().forEach(ReferenceCountUtil::release);
            this.queue.clear();
        }
    }
}

