/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.packet;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCounted;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import java.util.ArrayList;
import java.util.function.Consumer;
import network.ycc.raknet.frame.Frame;
import network.ycc.raknet.packet.Packet;

public final class FrameSet
extends AbstractReferenceCounted
implements Packet {
    public static final int HEADER_SIZE = 4;
    private static final ResourceLeakDetector<FrameSet> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(FrameSet.class);
    private static final Recycler<FrameSet> recycler = new Recycler<FrameSet>(){

        protected FrameSet newObject(Recycler.Handle<FrameSet> handle) {
            return new FrameSet(handle);
        }
    };
    protected final ArrayList<Frame> frames = new ArrayList(8);
    protected final Recycler.Handle<FrameSet> handle;
    protected int seqId;
    protected long sentTime;
    protected ResourceLeakTracker<FrameSet> tracker;
    protected int size;

    private FrameSet(Recycler.Handle<FrameSet> handle) {
        this.handle = handle;
        this.setRefCnt(0);
    }

    public static FrameSet create() {
        FrameSet out = (FrameSet)recycler.get();
        assert (out.refCnt() == 0);
        assert (out.tracker == null);
        out.sentTime = System.nanoTime();
        out.seqId = 0;
        out.tracker = leakDetector.track((Object)out);
        out.size = 4;
        out.setRefCnt(1);
        return out;
    }

    public static FrameSet read(ByteBuf buf) {
        FrameSet out = FrameSet.create();
        try {
            AbstractReferenceCounted frame;
            out.size = buf.readableBytes();
            buf.skipBytes(1);
            out.seqId = buf.readUnsignedMediumLE();
            while (buf.isReadable()) {
                frame = Frame.read(buf);
                out.frames.add((Frame)frame);
            }
            frame = out.retain();
            return frame;
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptedFrameException("Failed to parse Frame", (Throwable)e);
        }
        finally {
            out.release();
        }
    }

    @Override
    public int sizeHint() {
        return this.getRoughSize();
    }

    public FrameSet retain() {
        super.retain();
        return this;
    }

    protected void deallocate() {
        this.frames.forEach(AbstractReferenceCounted::release);
        this.frames.clear();
        this.size = 4;
        if (this.tracker != null) {
            this.tracker.close((Object)this);
            this.tracker = null;
        }
        this.handle.recycle((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuf produce(ByteBufAllocator alloc) {
        ByteBuf header = alloc.ioBuffer(4, 4);
        CompositeByteBuf out = alloc.compositeDirectBuffer(1 + this.frames.size() * 2);
        try {
            this.writeHeader(header);
            out.addComponent(true, header.retain());
            this.frames.forEach(frame -> frame.produce(alloc, out));
            CompositeByteBuf compositeByteBuf = out.retain();
            return compositeByteBuf;
        }
        finally {
            header.release();
            out.release();
        }
    }

    public void write(ByteBuf out) {
        this.writeHeader(out);
        this.frames.forEach(frame -> frame.write(out));
    }

    protected void writeHeader(ByteBuf out) {
        out.writeByte(128);
        out.writeMediumLE(this.seqId);
    }

    public void succeed() {
        this.frames.forEach(frame -> {
            ChannelPromise promise = frame.getPromise();
            if (promise != null) {
                promise.trySuccess();
                frame.setPromise(null);
            }
        });
    }

    public void fail(Throwable e) {
        this.frames.forEach(frame -> {
            ChannelPromise promise = frame.getPromise();
            if (promise != null) {
                promise.tryFailure(e);
                frame.setPromise(null);
            }
        });
    }

    public ReferenceCounted touch(Object hint) {
        if (this.tracker != null) {
            this.tracker.record(hint);
        }
        this.frames.forEach(packet -> packet.touch(hint));
        return this;
    }

    public long getSentTime() {
        return this.sentTime;
    }

    public int getSeqId() {
        return this.seqId;
    }

    public void setSeqId(int seqId) {
        this.seqId = seqId;
    }

    public int getNumPackets() {
        return this.frames.size();
    }

    public void addPacket(Frame packet) {
        this.frames.add(packet);
        this.size += packet.getRoughPacketSize();
    }

    public void createFrames(Consumer<Frame> consumer) {
        this.frames.forEach(frame -> consumer.accept(frame.retain()));
    }

    public int getRoughSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.frames.isEmpty();
    }

    public String toString() {
        return String.format("FramedData(frames: %s, seq: %s)", this.frames.size(), this.getSeqId());
    }
}

