/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.common.util;

import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class NetworkInterfaceListener {
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r, "Raknetify IFListener");
        thread.setDaemon(true);
        thread.setPriority(4);
        return thread;
    });
    private static final ObjectOpenHashSet<InetAddress> knownAddresses;
    private static final ReferenceSet<Consumer<InterfaceAddressChangeEvent>> listeners;

    public static void init() {
    }

    private static void pollChanges() {
        try {
            List<NetworkInterface> networkInterfaces = NetworkInterface.networkInterfaces().toList();
            ObjectOpenHashSet currentAddresses = new ObjectOpenHashSet();
            for (NetworkInterface networkInterface : networkInterfaces) {
                if (!networkInterface.isUp()) continue;
                for (InetAddress address : networkInterface.inetAddresses().toList()) {
                    currentAddresses.add((Object)address);
                    if (!knownAddresses.add((Object)address)) continue;
                    listeners.forEach(consumer -> consumer.accept(new InterfaceAddressChangeEvent(true, address)));
                }
            }
            ObjectIterator iterator = knownAddresses.iterator();
            while (iterator.hasNext()) {
                InetAddress address = (InetAddress)iterator.next();
                if (currentAddresses.contains((Object)address)) continue;
                iterator.remove();
                listeners.forEach(consumer -> consumer.accept(new InterfaceAddressChangeEvent(false, address)));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void addListener(Consumer<InterfaceAddressChangeEvent> consumer) {
        listeners.add(consumer);
    }

    public static void removeListener(Consumer<InterfaceAddressChangeEvent> consumer) {
        listeners.remove(consumer);
    }

    static {
        scheduler.scheduleAtFixedRate(() -> {
            try {
                NetworkInterfaceListener.pollChanges();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }, 0L, 10L, TimeUnit.SECONDS);
        knownAddresses = new ObjectOpenHashSet();
        listeners = ReferenceSets.synchronize((ReferenceSet)new ReferenceOpenHashSet());
    }

    public record InterfaceAddressChangeEvent(boolean added, InetAddress address) {
    }
}

