/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.common.connection;

import com.ishland.raknetify.common.Constants;
import com.ishland.raknetify.common.connection.SynchronizationLayer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import network.ycc.raknet.frame.FrameData;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class MultiChannelingStreamingCompression
extends ChannelDuplexHandler {
    public static final String NAME = "raknetify-multichannel-streaming-compression";
    public static final long SERVER_HANDSHAKE = 0x40000010L;
    public static final long CHANNEL_START = 1073741842L;
    private final Inflater[] inflaters = new Inflater[8];
    private final Deflater[] deflaters = new Deflater[8];
    private final IntOpenHashSet channelsToIgnoreWhenReinit = new IntOpenHashSet();
    private final byte[] inflateBuffer = new byte[262144];
    private final byte[] deflateBuffer = new byte[262144];
    private final int rawPacketId;
    private final int compressedPacketId;
    private volatile long outBytesRaw = 0L;
    private volatile long outBytesCompressed = 0L;
    private volatile long inBytesCompressed = 0L;
    private volatile long inBytesRaw = 0L;
    private boolean active = false;
    private ScheduledFuture<?> future;
    private long lastInBytesCompressed;
    private long lastInBytesRaw;
    private long lastOutBytesRaw;
    private long lastOutBytesCompressed;
    private final DescriptiveStatistics inCompressionRatioStats = new DescriptiveStatistics(16);
    private final DescriptiveStatistics outCompressionRatioStats = new DescriptiveStatistics(16);
    private volatile double inCompressionRatio;
    private volatile double outCompressionRatio;

    public MultiChannelingStreamingCompression(int rawPacketId, int compressedPacketId) {
        this.rawPacketId = rawPacketId;
        this.compressedPacketId = compressedPacketId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doServerHandshake(ChannelHandlerContext ctx) {
        ByteBuf buf = ctx.alloc().buffer().writeLong(0x40000010L);
        try {
            FrameData data = FrameData.create(ctx.alloc(), 236, buf);
            ctx.write((Object)data);
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChannelStart(ChannelHandlerContext ctx) {
        if (!this.active) {
            return;
        }
        ByteBuf buf = ctx.alloc().buffer().writeLong(1073741842L);
        try {
            for (int i = 0; i < 8; ++i) {
                FrameData data = FrameData.create(ctx.alloc(), 236, buf);
                data.setOrderChannel(i);
                ctx.write((Object)data);
                this.initDeflater(i);
            }
        }
        finally {
            buf.release();
        }
    }

    private void initDeflater(int channel) {
        if (!this.active) {
            return;
        }
        if (this.deflaters[channel] != null) {
            this.deflaters[channel].end();
        }
        this.deflaters[channel] = new Deflater();
        if (Constants.DEBUG) {
            System.out.println("Raknetify: Streaming compression deflater for ch%d is ready".formatted(channel));
        }
    }

    private void initInflater(int channel) {
        if (!this.active) {
            return;
        }
        if (this.inflaters[channel] != null) {
            this.inflaters[channel].end();
        }
        this.inflaters[channel] = new Inflater();
        if (Constants.DEBUG) {
            System.out.println("Raknetify: Streaming compression inflater for ch%d is ready".formatted(channel));
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.doServerHandshake(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        block17: {
            if (msg instanceof FrameData) {
                FrameData compressedFrameData = (FrameData)msg;
                compressedFrameData.touch();
                if (compressedFrameData.getPacketId() == 236) {
                    int orderChannel = compressedFrameData.getOrderChannel();
                    ByteBuf payload = null;
                    try {
                        payload = compressedFrameData.createData().skipBytes(1);
                        if (payload.readableBytes() == 8) {
                            long l = payload.readLong();
                            if (l == 1073741842L) {
                                this.initInflater(orderChannel);
                                return;
                            }
                            if (l == 0x40000010L) {
                                this.active = true;
                                this.doChannelStart(ctx);
                                return;
                            }
                        }
                        break block17;
                    }
                    finally {
                        compressedFrameData.release();
                        if (payload != null) {
                            payload.release();
                        }
                    }
                }
                if (compressedFrameData.getPacketId() == this.compressedPacketId && compressedFrameData.getReliability().isReliable && compressedFrameData.getReliability().isOrdered && !compressedFrameData.getReliability().isSequenced && this.inflaters[compressedFrameData.getOrderChannel()] != null) {
                    int orderChannel = compressedFrameData.getOrderChannel();
                    Inflater inflater = this.inflaters[orderChannel];
                    ByteBuf data = compressedFrameData.createData().skipBytes(1);
                    ByteBuf out = null;
                    FrameData rawFrameData = null;
                    try {
                        int inflatedBytes;
                        inflater.setInput(data.nioBuffer());
                        this.inBytesCompressed += (long)data.readableBytes();
                        out = ctx.alloc().buffer();
                        while ((inflatedBytes = inflater.inflate(this.inflateBuffer)) != 0) {
                            out.writeBytes(this.inflateBuffer, 0, inflatedBytes);
                        }
                        this.inBytesRaw += (long)out.writerIndex();
                        rawFrameData = FrameData.create(ctx.alloc(), this.rawPacketId, out);
                        rawFrameData.setReliability(compressedFrameData.getReliability());
                        rawFrameData.setOrderChannel(orderChannel);
                        ctx.fireChannelRead((Object)rawFrameData);
                        rawFrameData = null;
                        return;
                    }
                    finally {
                        data.release();
                        compressedFrameData.release();
                        if (out != null) {
                            out.release();
                        }
                        if (rawFrameData != null) {
                            rawFrameData.release();
                        }
                    }
                }
            }
        }
        super.channelRead(ctx, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg == SynchronizationLayer.SYNC_REQUEST_OBJECT) {
            super.write(ctx, msg, promise);
            this.doChannelStart(ctx);
            return;
        }
        if (msg instanceof FrameData) {
            FrameData rawFrameData = (FrameData)msg;
            rawFrameData.touch();
            if (rawFrameData.getPacketId() == this.rawPacketId && rawFrameData.getReliability().isReliable && rawFrameData.getReliability().isOrdered && !rawFrameData.getReliability().isSequenced && this.deflaters[rawFrameData.getOrderChannel()] != null) {
                if (rawFrameData.getDataSize() < 17) {
                    this.outBytesRaw += (long)(rawFrameData.getDataSize() - 1);
                    this.outBytesCompressed += (long)(rawFrameData.getDataSize() - 1);
                    ctx.write((Object)rawFrameData, promise);
                    return;
                }
                int orderChannel = rawFrameData.getOrderChannel();
                Deflater deflater = this.deflaters[orderChannel];
                ByteBuf data = rawFrameData.createData().skipBytes(1);
                ByteBuf out = null;
                FrameData compressedFrameData = null;
                try {
                    int deflatedBytes;
                    deflater.setInput(data.nioBuffer());
                    this.outBytesRaw += (long)data.readableBytes();
                    out = ctx.alloc().buffer();
                    while ((deflatedBytes = deflater.deflate(this.deflateBuffer, 0, this.deflateBuffer.length, 2)) != 0) {
                        out.writeBytes(this.deflateBuffer, 0, deflatedBytes);
                    }
                    this.outBytesCompressed += (long)out.writerIndex();
                    compressedFrameData = FrameData.create(ctx.alloc(), this.compressedPacketId, out);
                    compressedFrameData.setReliability(rawFrameData.getReliability());
                    compressedFrameData.setOrderChannel(orderChannel);
                    ctx.write((Object)compressedFrameData, promise);
                    compressedFrameData = null;
                    return;
                }
                finally {
                    data.release();
                    rawFrameData.release();
                    if (out != null) {
                        out.release();
                    }
                    if (compressedFrameData != null) {
                        compressedFrameData.release();
                    }
                }
            }
        }
        super.write(ctx, msg, promise);
    }

    public long getInBytesCompressed() {
        return this.inBytesCompressed;
    }

    public long getInBytesRaw() {
        return this.inBytesRaw;
    }

    public long getOutBytesCompressed() {
        return this.outBytesCompressed;
    }

    public long getOutBytesRaw() {
        return this.outBytesRaw;
    }

    public boolean isActive() {
        return this.active;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.future = ctx.channel().eventLoop().scheduleAtFixedRate(this::tickMetrics, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        if (this.future != null) {
            this.future.cancel(false);
        }
        for (int i = 0; i < 8; ++i) {
            if (this.inflaters[i] != null) {
                this.inflaters[i].end();
            }
            if (this.deflaters[i] == null) continue;
            this.deflaters[i].end();
        }
    }

    private void tickMetrics() {
        long deltaInBytesCompressed = this.inBytesCompressed - this.lastInBytesCompressed;
        long deltaInBytesRaw = this.inBytesRaw - this.lastInBytesRaw;
        long deltaOutBytesCompressed = this.outBytesCompressed - this.lastOutBytesCompressed;
        long deltaOutBytesRaw = this.outBytesRaw - this.lastOutBytesRaw;
        if (deltaInBytesRaw != 0L) {
            double currentInCompressionRatio = (double)deltaInBytesCompressed / (double)deltaInBytesRaw;
            this.inCompressionRatioStats.addValue(currentInCompressionRatio);
        }
        if (deltaOutBytesRaw != 0L) {
            double currentOutCompressionRatio = (double)deltaOutBytesCompressed / (double)deltaOutBytesRaw;
            this.outCompressionRatioStats.addValue(currentOutCompressionRatio);
        }
        this.inCompressionRatio = this.inCompressionRatioStats.getMean();
        this.outCompressionRatio = this.outCompressionRatioStats.getMean();
        this.lastInBytesCompressed = this.inBytesCompressed;
        this.lastInBytesRaw = this.inBytesRaw;
        this.lastOutBytesCompressed = this.outBytesCompressed;
        this.lastOutBytesRaw = this.outBytesRaw;
    }

    public double getInCompressionRatio() {
        return this.inCompressionRatio;
    }

    public double getOutCompressionRatio() {
        return this.outCompressionRatio;
    }
}

