/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.mouse.setup.config;

import aquariusplayz.animalgarden.mouse.setup.config.ModConfigProvider;
import aquariusplayz.animalgarden.mouse.setup.config.SimpleConfig;
import com.mojang.datafixers.util.Pair;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfigs {
    public static SimpleConfig CONFIG;
    private static ModConfigProvider configs;
    public static int WEIGHT;
    public static int MIN;
    public static int MAX;
    public static int SEARCH_RANGE;
    public static String BIOMES;
    public static String BIOMES_DEFAULT;
    public static int WEIGHT_DEFAULT;

    public static void changeConfig() throws IOException {
        try {
            Path path = FabricLoader.getInstance().getConfigDir();
            String filename = "animalgarden_mouse.properties";
            FileWriter fw = new FileWriter(String.valueOf(String.valueOf(path) + "\\" + filename), false);
            PrintWriter pw = new PrintWriter((Writer)fw, Boolean.parseBoolean("UTF-8"));
            pw.println("animalgarden_mouse.weight=" + WEIGHT + " #int | default: " + WEIGHT_DEFAULT);
            pw.println("animalgarden_mouse.min=" + MIN + " #int | default: 1");
            pw.println("animalgarden_mouse.max=" + MAX + " #int | default: 2");
            pw.println("animalgarden_mouse.biomes=" + BIOMES + " #String | default: " + BIOMES_DEFAULT);
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void registerConfigs() {
        configs = new ModConfigProvider();
        ModConfigs.createConfigs();
        CONFIG = SimpleConfig.of("animalgarden_mouseconfig").provider(configs).request();
        ModConfigs.assignConfigs();
    }

    private static void createConfigs() {
        configs.addKeyValuePair(new Pair((Object)"animalgarden_mouse.weight", (Object)WEIGHT_DEFAULT), "int");
        configs.addKeyValuePair(new Pair((Object)"animalgarden_mouse.min", (Object)1), "int");
        configs.addKeyValuePair(new Pair((Object)"animalgarden_mouse.max", (Object)2), "int");
        configs.addKeyValuePair(new Pair((Object)"animalgarden_mouse.biomes", (Object)BIOMES_DEFAULT), "String");
    }

    private static void assignConfigs() {
        WEIGHT = CONFIG.getOrDefault("animalgarden_mouse.weight", WEIGHT_DEFAULT);
        MIN = CONFIG.getOrDefault("animalgarden_mouse.min", 1);
        MAX = CONFIG.getOrDefault("animalgarden_mouse.max", 2);
        BIOMES = CONFIG.getOrDefault("animalgarden_mouse.biomes", BIOMES_DEFAULT);
        System.out.println("All " + configs.getConfigsList().size() + " have been set properly");
    }

    static {
        BIOMES = "forest,flower_forest,birch_forest,old_growth_birch_forest,savanna,plains,dark_forest,taiga,badlands";
        BIOMES_DEFAULT = "forest,flower_forest,birch_forest,old_growth_birch_forest,savanna,plains,dark_forest,taiga,badlands";
        WEIGHT_DEFAULT = 15;
    }
}

